/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.webrtc.GlUtil;
import org.webrtc.RendererCommon;
import org.webrtc.VideoFrame;
import org.webrtc.VideoRenderer;

public class VideoFrameDrawer {
    private static final String TAG = "VideoFrameDrawer";
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private final Point renderSize = new Point();
    private int renderWidth;
    private int renderHeight;
    private final YuvUploader yuvUploader = new YuvUploader();
    private VideoFrame lastI420Frame;
    private final Matrix renderMatrix = new Matrix();

    static void drawTexture(RendererCommon.GlDrawer glDrawer, VideoFrame.TextureBuffer textureBuffer, Matrix matrix, int n2, int n3, int n4, int n5, int n6, int n7) {
        Matrix matrix2 = new Matrix(textureBuffer.getTransformMatrix());
        matrix2.preConcat(matrix);
        float[] fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(matrix2);
        switch (textureBuffer.getType()) {
            case OES: {
                glDrawer.drawOes(textureBuffer.getTextureId(), fArray, n2, n3, n4, n5, n6, n7);
                break;
            }
            case RGB: {
                glDrawer.drawRgb(textureBuffer.getTextureId(), fArray, n2, n3, n4, n5, n6, n7);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
    }

    private static int distance(float f2, float f3, float f4, float f5) {
        return (int)Math.round(Math.hypot(f4 - f2, f5 - f3));
    }

    private void calculateTransformedRenderSize(int n2, int n3, Matrix matrix) {
        if (matrix == null) {
            this.renderWidth = n2;
            this.renderHeight = n3;
            return;
        }
        matrix.mapPoints(this.dstPoints, srcPoints);
        for (int i2 = 0; i2 < 3; ++i2) {
            int n4 = i2 * 2 + 0;
            this.dstPoints[n4] = this.dstPoints[n4] * (float)n2;
            int n5 = i2 * 2 + 1;
            this.dstPoints[n5] = this.dstPoints[n5] * (float)n3;
        }
        this.renderWidth = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[2], this.dstPoints[3]);
        this.renderHeight = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[4], this.dstPoints[5]);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer) {
        this.drawFrame(videoFrame, glDrawer, null);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer, Matrix matrix) {
        this.drawFrame(videoFrame, glDrawer, matrix, 0, 0, videoFrame.getRotatedWidth(), videoFrame.getRotatedHeight());
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer, Matrix matrix, int n2, int n3, int n4, int n5) {
        int n6 = videoFrame.getRotatedWidth();
        int n7 = videoFrame.getRotatedHeight();
        this.calculateTransformedRenderSize(n6, n7, matrix);
        boolean bl = videoFrame.getBuffer() instanceof VideoFrame.TextureBuffer;
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        if (!bl) {
            this.renderMatrix.preScale(1.0f, -1.0f);
        }
        this.renderMatrix.preRotate((float)videoFrame.getRotation());
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (matrix != null) {
            this.renderMatrix.preConcat(matrix);
        }
        if (bl) {
            this.lastI420Frame = null;
            VideoFrameDrawer.drawTexture(glDrawer, (VideoFrame.TextureBuffer)videoFrame.getBuffer(), this.renderMatrix, this.renderWidth, this.renderHeight, n2, n3, n4, n5);
        } else {
            if (videoFrame != this.lastI420Frame) {
                this.lastI420Frame = videoFrame;
                VideoFrame.I420Buffer i420Buffer = videoFrame.getBuffer().toI420();
                this.yuvUploader.uploadFromBuffer(i420Buffer);
                i420Buffer.release();
            }
            glDrawer.drawYuv(this.yuvUploader.getYuvTextures(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, n2, n3, n4, n5);
        }
    }

    public void release() {
        this.yuvUploader.release();
        this.lastI420Frame = null;
    }

    private static class YuvUploader {
        private ByteBuffer copyBuffer;
        private int[] yuvTextures;

        private YuvUploader() {
        }

        public int[] uploadYuvData(int n2, int n3, int[] nArray, ByteBuffer[] byteBufferArray) {
            int n4;
            int[] nArray2 = new int[]{n2, n2 / 2, n2 / 2};
            int[] nArray3 = new int[]{n3, n3 / 2, n3 / 2};
            int n5 = 0;
            for (n4 = 0; n4 < 3; ++n4) {
                if (nArray[n4] <= nArray2[n4]) continue;
                n5 = Math.max(n5, nArray2[n4] * nArray3[n4]);
            }
            if (n5 > 0 && (this.copyBuffer == null || this.copyBuffer.capacity() < n5)) {
                this.copyBuffer = ByteBuffer.allocateDirect(n5);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (n4 = 0; n4 < 3; ++n4) {
                    this.yuvTextures[n4] = GlUtil.generateTexture(3553);
                }
            }
            for (n4 = 0; n4 < 3; ++n4) {
                ByteBuffer byteBuffer;
                GLES20.glActiveTexture((int)(33984 + n4));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[n4]);
                if (nArray[n4] == nArray2[n4]) {
                    byteBuffer = byteBufferArray[n4];
                } else {
                    VideoRenderer.nativeCopyPlane(byteBufferArray[n4], nArray2[n4], nArray3[n4], nArray[n4], this.copyBuffer, nArray2[n4]);
                    byteBuffer = this.copyBuffer;
                }
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)nArray2[n4], (int)nArray3[n4], (int)0, (int)6409, (int)5121, (Buffer)byteBuffer);
            }
            return this.yuvTextures;
        }

        public int[] uploadFromBuffer(VideoFrame.I420Buffer i420Buffer) {
            int[] nArray = new int[]{i420Buffer.getStrideY(), i420Buffer.getStrideU(), i420Buffer.getStrideV()};
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{i420Buffer.getDataY(), i420Buffer.getDataU(), i420Buffer.getDataV()};
            return this.uploadYuvData(i420Buffer.getWidth(), i420Buffer.getHeight(), nArray, byteBufferArray);
        }

        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            this.copyBuffer = null;
            if (this.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])this.yuvTextures, (int)0);
                this.yuvTextures = null;
            }
        }
    }
}

