/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.JNINamespace;
import org.webrtc.JavaI420Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;

@JNINamespace(value="webrtc::jni")
public class VideoRenderer {
    long nativeVideoRenderer;

    static native void nativeCopyPlane(ByteBuffer var0, int var1, int var2, int var3, ByteBuffer var4, int var5);

    public static void renderFrameDone(I420Frame i420Frame) {
        i420Frame.yuvPlanes = null;
        i420Frame.textureId = 0;
        if (i420Frame.nativeFramePointer != 0L) {
            VideoRenderer.nativeReleaseFrame(i420Frame.nativeFramePointer);
            i420Frame.nativeFramePointer = 0L;
        }
    }

    public VideoRenderer(Callbacks callbacks) {
        this.nativeVideoRenderer = VideoRenderer.nativeCreateVideoRenderer(callbacks);
    }

    public void dispose() {
        if (this.nativeVideoRenderer == 0L) {
            return;
        }
        VideoRenderer.nativeFreeWrappedVideoRenderer(this.nativeVideoRenderer);
        this.nativeVideoRenderer = 0L;
    }

    private static native long nativeCreateVideoRenderer(Callbacks var0);

    private static native void nativeFreeWrappedVideoRenderer(long var0);

    private static native void nativeReleaseFrame(long var0);

    public static interface Callbacks {
        @CalledByNative(value="Callbacks")
        public void renderFrame(I420Frame var1);
    }

    public static class I420Frame {
        public final int width;
        public final int height;
        public final int[] yuvStrides;
        public ByteBuffer[] yuvPlanes;
        public final boolean yuvFrame;
        public final float[] samplingMatrix;
        public int textureId;
        private long nativeFramePointer;
        public int rotationDegree;
        private final VideoFrame.Buffer backingBuffer;

        public I420Frame(int n2, int n3, int n4, int[] nArray, ByteBuffer[] byteBufferArray, long l2) {
            this.width = n2;
            this.height = n3;
            this.yuvStrides = nArray;
            this.yuvPlanes = byteBufferArray;
            this.yuvFrame = true;
            this.rotationDegree = n4;
            this.nativeFramePointer = l2;
            this.backingBuffer = null;
            if (n4 % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + n4);
            }
            this.samplingMatrix = RendererCommon.verticalFlipMatrix();
        }

        public I420Frame(int n2, int n3, int n4, int n5, float[] fArray, long l2) {
            this.width = n2;
            this.height = n3;
            this.yuvStrides = null;
            this.yuvPlanes = null;
            this.samplingMatrix = fArray;
            this.textureId = n5;
            this.yuvFrame = false;
            this.rotationDegree = n4;
            this.nativeFramePointer = l2;
            this.backingBuffer = null;
            if (n4 % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + n4);
            }
        }

        @CalledByNative(value="I420Frame")
        public I420Frame(int n2, VideoFrame.Buffer buffer, long l2) {
            this.width = buffer.getWidth();
            this.height = buffer.getHeight();
            this.rotationDegree = n2;
            if (n2 % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + n2);
            }
            if (buffer instanceof VideoFrame.TextureBuffer && ((VideoFrame.TextureBuffer)buffer).getType() == VideoFrame.TextureBuffer.Type.OES) {
                VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)buffer;
                this.yuvFrame = false;
                this.textureId = textureBuffer.getTextureId();
                this.samplingMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(textureBuffer.getTransformMatrix());
                this.yuvStrides = null;
                this.yuvPlanes = null;
            } else if (buffer instanceof VideoFrame.I420Buffer) {
                VideoFrame.I420Buffer i420Buffer = (VideoFrame.I420Buffer)buffer;
                this.yuvFrame = true;
                this.yuvStrides = new int[]{i420Buffer.getStrideY(), i420Buffer.getStrideU(), i420Buffer.getStrideV()};
                this.yuvPlanes = new ByteBuffer[]{i420Buffer.getDataY(), i420Buffer.getDataU(), i420Buffer.getDataV()};
                this.samplingMatrix = RendererCommon.verticalFlipMatrix();
                this.textureId = 0;
            } else {
                this.yuvFrame = false;
                this.textureId = 0;
                this.samplingMatrix = null;
                this.yuvStrides = null;
                this.yuvPlanes = null;
            }
            this.nativeFramePointer = l2;
            this.backingBuffer = buffer;
        }

        public int rotatedWidth() {
            return this.rotationDegree % 180 == 0 ? this.width : this.height;
        }

        public int rotatedHeight() {
            return this.rotationDegree % 180 == 0 ? this.height : this.width;
        }

        public String toString() {
            String string = this.yuvFrame ? "Y: " + this.yuvStrides[0] + ", U: " + this.yuvStrides[1] + ", V: " + this.yuvStrides[2] : "Texture: " + this.textureId;
            return this.width + "x" + this.height + ", " + string;
        }

        VideoFrame toVideoFrame() {
            VideoFrame.Buffer buffer;
            if (this.backingBuffer != null) {
                this.backingBuffer.retain();
                VideoRenderer.renderFrameDone(this);
                buffer = this.backingBuffer;
            } else {
                buffer = this.yuvFrame ? JavaI420Buffer.wrap(this.width, this.height, this.yuvPlanes[0], this.yuvStrides[0], this.yuvPlanes[1], this.yuvStrides[1], this.yuvPlanes[2], this.yuvStrides[2], () -> VideoRenderer.renderFrameDone(this)) : new TextureBufferImpl(this.width, this.height, VideoFrame.TextureBuffer.Type.OES, this.textureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(this.samplingMatrix), null, () -> VideoRenderer.renderFrameDone(this));
            }
            return new VideoFrame(buffer, this.rotationDegree, 0L);
        }

        @CalledByNative(value="I420Frame")
        static I420Frame createI420Frame(int n2, int n3, int n4, int n5, ByteBuffer byteBuffer, int n6, ByteBuffer byteBuffer2, int n7, ByteBuffer byteBuffer3, long l2) {
            return new I420Frame(n2, n3, n4, new int[]{n5, n6, n7}, new ByteBuffer[]{byteBuffer, byteBuffer2, byteBuffer3}, l2);
        }

        @CalledByNative(value="I420Frame")
        static I420Frame createTextureFrame(int n2, int n3, int n4, int n5, float[] fArray, long l2) {
            return new I420Frame(n2, n3, n4, n5, fArray, l2);
        }
    }
}

