/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import com.ucloudrtclib.a.i;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.webrtc.JNINamespace;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoSink;

@JNINamespace(value="webrtc::jni")
public class VideoTrack
extends MediaStreamTrack {
    private static final String TAG = "VideoTrack";
    private final List<VideoRenderer> renderers = new ArrayList<VideoRenderer>();
    private final IdentityHashMap<VideoSink, Long> sinks = new IdentityHashMap();

    public VideoTrack(long l2) {
        super(l2);
    }

    public void addSink(VideoSink videoSink) {
        i.d(TAG, "add sinks before size " + this.sinks.size());
        long l2 = VideoTrack.nativeWrapSink(videoSink);
        this.sinks.put(videoSink, l2);
        VideoTrack.nativeAddSink(this.nativeTrack, l2);
        i.d(TAG, "add sinks after size " + this.sinks.size());
        for (VideoSink videoSink2 : this.sinks.keySet()) {
            i.d(TAG, "add after sink key " + videoSink2);
        }
    }

    public void removeSink(VideoSink videoSink) {
        i.d(TAG, "remove before sinks size " + this.sinks.size());
        Long l2 = this.sinks.remove(videoSink);
        if (l2 != null) {
            long l3 = l2;
            if (l3 != 0L) {
                VideoTrack.nativeRemoveSink(this.nativeTrack, l3);
                VideoTrack.nativeFreeSink(l3);
                i.d(TAG, "remove sink suc");
            }
            i.d(TAG, "remove after sinks size " + this.sinks.size());
        } else {
            i.d(TAG, "remove sink " + videoSink + " is not in list");
        }
        for (VideoSink videoSink2 : this.sinks.keySet()) {
            i.d(TAG, "remove after sink key " + videoSink2);
        }
    }

    public void addRenderer(VideoRenderer videoRenderer) {
        this.renderers.add(videoRenderer);
        VideoTrack.nativeAddSink(this.nativeTrack, videoRenderer.nativeVideoRenderer);
    }

    public void removeRenderer(VideoRenderer videoRenderer) {
        if (!this.renderers.remove(videoRenderer)) {
            return;
        }
        VideoTrack.nativeRemoveSink(this.nativeTrack, videoRenderer.nativeVideoRenderer);
        i.d(TAG, "VideoTrack native remove render: " + videoRenderer.nativeVideoRenderer);
        videoRenderer.dispose();
        i.d("dispose", " render: " + videoRenderer);
    }

    @Override
    public void dispose() {
        for (VideoRenderer videoRenderer : this.renderers) {
            VideoTrack.nativeRemoveSink(this.nativeTrack, videoRenderer.nativeVideoRenderer);
            videoRenderer.dispose();
        }
        this.renderers.clear();
        Iterator<Object> iterator = this.sinks.values().iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            VideoTrack.nativeRemoveSink(this.nativeTrack, l2);
            VideoTrack.nativeFreeSink(l2);
        }
        this.sinks.clear();
        i.d(TAG, "sinks clear dispose " + this.sinks.size());
        super.dispose();
    }

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(VideoSink var0);

    private static native void nativeFreeSink(long var0);
}

