/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;
import org.webrtc.VideoFrame;

class WrappedNativeI420Buffer
implements VideoFrame.I420Buffer {
    private static final String TAG = "WrappedNativeI420Buffer";
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final int strideY;
    private final ByteBuffer dataU;
    private final int strideU;
    private final ByteBuffer dataV;
    private final int strideV;
    private final long nativeBuffer;

    @CalledByNative
    WrappedNativeI420Buffer(int n2, int n3, ByteBuffer byteBuffer, int n4, ByteBuffer byteBuffer2, int n5, ByteBuffer byteBuffer3, int n6, long l2) {
        this.width = n2;
        this.height = n3;
        this.dataY = byteBuffer;
        this.strideY = n4;
        this.dataU = byteBuffer2;
        this.strideU = n5;
        this.dataV = byteBuffer3;
        this.strideV = n6;
        this.nativeBuffer = l2;
        this.retain();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        ByteBuffer byteBuffer = this.dataV.slice();
        return byteBuffer;
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        this.retain();
        return this;
    }

    @Override
    public void retain() {
        JniCommon.nativeAddRef(this.nativeBuffer);
    }

    @Override
    public void release() {
        JniCommon.nativeReleaseRef(this.nativeBuffer);
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        return VideoFrame.cropAndScaleI420(this, n2, n3, n4, n5, n6, n7);
    }
}

