/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud;

import android.content.Context;
import android.os.SystemClock;
import com.ucloudrtclib.sdkengine.UCloudRtcSdkEnv;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRTCDataProvider;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.webrtc.JavaI420Buffer;
import org.webrtc.JniCommon;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;
import org.webrtc.YuvHelper;
import org.webrtc.ucloud.UcloudConvert2YUVData;
import org.webrtc.ucloud.UcloudRTCDataSource;
import org.webrtc.ucloud.UcloudRTCVideoReader;

public class UcloudRtcExDevice2YUVCapturer
implements VideoCapturer {
    private static final String TAG = "YUVCapture";
    private int mFrameRate;
    private Timer mTimer = null;
    private TimerTask mTickTask = null;
    private UcloudRTCVideoReader mVideoReader;
    private VideoCapturer.CapturerObserver mCapturerObserver;
    UCloudRTCDataProvider mDataPusher;
    private boolean mStop;
    private final Object lock = new Object();
    private ByteBuffer yuvCache;
    private OutputStream os;
    public static final ReentrantLock reentrantLock = new ReentrantLock(true);

    public UcloudRtcExDevice2YUVCapturer(UCloudRTCDataProvider uCloudRTCDataProvider) {
        this.mVideoReader = new UcloudRGBAReader();
        this.mDataPusher = uCloudRTCDataProvider;
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, VideoCapturer.CapturerObserver capturerObserver) {
        this.mCapturerObserver = capturerObserver;
    }

    public int getFrameRate() {
        return this.mFrameRate;
    }

    private void initTimerTask() {
        this.mTickTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = UcloudRtcExDevice2YUVCapturer.this.lock;
                synchronized (object) {
                    if (!UcloudRtcExDevice2YUVCapturer.this.mStop) {
                        UcloudRtcExDevice2YUVCapturer.this.tickConvertData();
                    }
                }
            }
        };
        this.mTimer = new Timer("ucloudcaptuer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickConvertData() {
        reentrantLock.lock();
        try {
            UcloudConvert2YUVData ucloudConvert2YUVData = new UcloudConvert2YUVData();
            ucloudConvert2YUVData.pushData(this.mDataPusher);
            if (ucloudConvert2YUVData.mSrcData != null && ucloudConvert2YUVData.mSrcData.limit() > 0) {
                int n2 = -1;
                ucloudConvert2YUVData.mSrcData.position(0);
                this.yuvCache.clear();
                switch (ucloudConvert2YUVData.mType) {
                    case 0x1001040: 
                    case 0x1001041: 
                    case 16781378: {
                        n2 = YuvHelper.RgbaToI420(ucloudConvert2YUVData.mType, ucloudConvert2YUVData.mSrcData, this.yuvCache, ucloudConvert2YUVData.mSrcWidth, ucloudConvert2YUVData.mSrcHeight);
                        break;
                    }
                    case 16781379: {
                        n2 = YuvHelper.ArgbToI420(ucloudConvert2YUVData.mType, ucloudConvert2YUVData.mSrcData, this.yuvCache, ucloudConvert2YUVData.mSrcWidth, ucloudConvert2YUVData.mSrcHeight);
                        break;
                    }
                    case 16781364: {
                        n2 = YuvHelper.Rgb24ToI420(ucloudConvert2YUVData.mType, ucloudConvert2YUVData.mSrcData, this.yuvCache, ucloudConvert2YUVData.mSrcWidth, ucloudConvert2YUVData.mSrcHeight);
                        break;
                    }
                    case 16781349: {
                        n2 = YuvHelper.Rgb565ToI420(ucloudConvert2YUVData.mType, ucloudConvert2YUVData.mSrcData, this.yuvCache, ucloudConvert2YUVData.mSrcWidth, ucloudConvert2YUVData.mSrcHeight);
                        break;
                    }
                    case 0x1001090: {
                        n2 = YuvHelper.NV21ToI420(ucloudConvert2YUVData.mType, ucloudConvert2YUVData.mSrcData, this.yuvCache, ucloudConvert2YUVData.mSrcWidth, ucloudConvert2YUVData.mSrcHeight);
                        break;
                    }
                    case 0x1001091: {
                        n2 = YuvHelper.NV12ToI420(ucloudConvert2YUVData.mType, ucloudConvert2YUVData.mSrcData, this.yuvCache, ucloudConvert2YUVData.mSrcWidth, ucloudConvert2YUVData.mSrcHeight);
                        break;
                    }
                    case 0x1001099: {
                        this.yuvCache.put(ucloudConvert2YUVData.mSrcData);
                        n2 = 0;
                    }
                }
                if (n2 == 0) {
                    int n3 = this.getFrameOrientation();
                    VideoFrame videoFrame = this.mVideoReader.getNextFrame(ucloudConvert2YUVData, n3);
                    if (this.mCapturerObserver != null && videoFrame != null) {
                        this.mCapturerObserver.onFrameCaptured(videoFrame);
                        this.yuvCache.clear();
                        videoFrame.release();
                    }
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public static byte[] convert(ByteBuffer byteBuffer) {
        byteBuffer.position(0);
        int n2 = byteBuffer.limit() - byteBuffer.position();
        byte[] byArray = new byte[n2];
        if (byteBuffer.isReadOnly()) {
            return null;
        }
        byteBuffer.get(byArray);
        return byArray;
    }

    public static byte[] convert(ByteBuffer byteBuffer, int n2, int n3) {
        byteBuffer.position(0);
        int n4 = (n3 + 1) / 2;
        int n5 = (n2 + 1) / 2;
        int n6 = 0;
        int n7 = n6 + n2 * n3;
        int n8 = n7 + n5 * n4;
        int n9 = n2 * n3 + 2 * n5 * n4;
        byte[] byArray = new byte[n9];
        boolean bl = UCloudRtcSdkEnv.isFrontCameraMirror();
        if (byteBuffer.isReadOnly()) {
            return null;
        }
        byteBuffer.get(byArray);
        if (bl) {
            UcloudRtcExDevice2YUVCapturer.Mirror(byArray, n2, n3);
        }
        return byArray;
    }

    public static void Mirror(byte[] byArray, int n2, int n3) {
        byte by;
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = n6 * n2;
            for (n4 = (n6 + 1) * n2 - 1; n5 < n4; ++n5, --n4) {
                by = byArray[n5];
                byArray[n5] = byArray[n4];
                byArray[n4] = by;
            }
        }
        int n7 = n2 * n3;
        for (n6 = 0; n6 < n3 / 2; ++n6) {
            n5 = n6 * n2 / 2;
            for (n4 = (n6 + 1) * n2 / 2 - 1; n5 < n4; ++n5, --n4) {
                by = byArray[n5 + n7];
                byArray[n5 + n7] = byArray[n4 + n7];
                byArray[n4 + n7] = by;
            }
        }
        n7 = n2 * n3 / 4 * 5;
        for (n6 = 0; n6 < n3 / 2; ++n6) {
            n5 = n6 * n2 / 2;
            for (n4 = (n6 + 1) * n2 / 2 - 1; n5 < n4; ++n5, --n4) {
                by = byArray[n5 + n7];
                byArray[n5 + n7] = byArray[n4 + n7];
                byArray[n4 + n7] = by;
            }
        }
    }

    @Override
    public void startCapture(int n2, int n3, int n4) {
        this.mFrameRate = n4;
        this.mStop = false;
        if (this.mDataPusher != null) {
            this.yuvCache = JniCommon.nativeAllocateByteBuffer(35389440);
            this.initTimerTask();
            this.mTimer.scheduleAtFixedRate(this.mTickTask, 0L, (long)(1000 / n4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCapture() {
        Object object = this.lock;
        synchronized (object) {
            this.mStop = true;
            this.mTimer.cancel();
            this.mTimer.purge();
            this.mTimer = null;
            JniCommon.nativeFreeByteBuffer(this.yuvCache);
        }
    }

    @Override
    public void changeCaptureFormat(int n2, int n3, int n4) {
    }

    @Override
    public void dispose() {
        if (this.mVideoReader != null) {
            this.mVideoReader.close();
        }
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    private int getFrameOrientation() {
        int n2 = 0;
        boolean bl = UCloudRtcSdkEnv.isFrontCameraMirror();
        switch (UCloudRtcSdkEnv.getPushOrientation()) {
            case UCLOUD_RTC_PUSH_LANDSCAPE_MODE: {
                n2 = 0;
                break;
            }
            case UCLOUD_RTC_PUSH_PORTRAIT_MODE: {
                n2 = bl ? 90 : 270;
                break;
            }
            case UCLOUD_RTC_PUSH_LANDSCAPE_MODE2: {
                n2 = 180;
                break;
            }
            case UCLOUD_RTC_PUSH_PORTRAIT_MODE2: {
                n2 = bl ? 270 : 90;
            }
        }
        return n2;
    }

    private class UcloudRGBAReader
    implements UcloudRTCVideoReader {
        private UcloudRGBAReader() {
        }

        public VideoFrame getNextFrame(UcloudRTCDataSource ucloudRTCDataSource, int n2) {
            if (ucloudRTCDataSource instanceof UcloudConvert2YUVData) {
                UcloudConvert2YUVData ucloudConvert2YUVData = (UcloudConvert2YUVData)ucloudRTCDataSource;
                long l2 = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(UcloudRtcExDevice2YUVCapturer.convert(UcloudRtcExDevice2YUVCapturer.this.yuvCache, ucloudConvert2YUVData.mSrcWidth, ucloudConvert2YUVData.mSrcHeight), ucloudConvert2YUVData.mSrcWidth, ucloudConvert2YUVData.mSrcHeight);
                return new VideoFrame(javaI420Buffer, n2, l2);
            }
            return null;
        }

        @Override
        public void close() {
        }
    }
}

