/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record;

import android.media.AudioRecord;
import org.webrtc.ucloud.record.IMediaRecorder;

public class AudioRecorder
extends Thread {
    private AudioRecord mAudioRecord = null;
    private int mSampleRate = 44100;
    private IMediaRecorder mMediaRecorder;

    public AudioRecorder(IMediaRecorder iMediaRecorder) {
        this.mMediaRecorder = iMediaRecorder;
    }

    public void setSampleRate(int n2) {
        this.mSampleRate = n2;
    }

    @Override
    public void run() {
        if (this.mSampleRate != 8000 && this.mSampleRate != 16000 && this.mSampleRate != 22050 && this.mSampleRate != 44100) {
            this.mMediaRecorder.onAudioError(1, "sampleRate not support.");
            return;
        }
        int n2 = AudioRecord.getMinBufferSize((int)this.mSampleRate, (int)16, (int)2);
        if (-2 == n2) {
            this.mMediaRecorder.onAudioError(2, "parameters are not supported by the hardware.");
            return;
        }
        this.mAudioRecord = new AudioRecord(1, this.mSampleRate, 16, 2, n2);
        if (null == this.mAudioRecord) {
            this.mMediaRecorder.onAudioError(3, "new AudioRecord failed.");
            return;
        }
        try {
            this.mAudioRecord.startRecording();
        }
        catch (IllegalStateException illegalStateException) {
            this.mMediaRecorder.onAudioError(0, "startRecording failed.");
            return;
        }
        byte[] byArray = new byte[2048];
        try {
            while (!Thread.currentThread().isInterrupted()) {
                int n3 = this.mAudioRecord.read(byArray, 0, 2048);
                if (n3 <= 0) continue;
                this.mMediaRecorder.receiveAudioData(byArray, n3);
            }
        }
        catch (Exception exception) {
            String string = "";
            if (exception != null) {
                string = exception.getMessage();
            }
            this.mMediaRecorder.onAudioError(0, string);
        }
        this.mAudioRecord.release();
        this.mAudioRecord = null;
    }
}

