/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record;

import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.webrtc.ucloud.record.DeviceUtils;
import org.webrtc.ucloud.record.StringUtils;

public class FileUtils {
    public static String concatPath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            for (String string : stringArray) {
                boolean bl;
                if (string == null || string.length() <= 0) continue;
                int n2 = stringBuilder.length();
                boolean bl2 = n2 > 0 && stringBuilder.charAt(n2 - 1) == File.separatorChar;
                boolean bl3 = bl = string.charAt(0) == File.separatorChar;
                if (bl2 && bl) {
                    stringBuilder.append(string.substring(1));
                    continue;
                }
                if (!bl2 && !bl) {
                    stringBuilder.append(File.separatorChar);
                    stringBuilder.append(string);
                    continue;
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public static String calculateMD5(File file) {
        FileInputStream fileInputStream;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.e((String)"FileUtils", (String)"Exception while getting digest", (Throwable)noSuchAlgorithmException);
            return null;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)"FileUtils", (String)"Exception while getting FileInputStream", (Throwable)fileNotFoundException);
            return null;
        }
        byte[] byArray = new byte[8192];
        try {
            int n2;
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                messageDigest.update(byArray, 0, n2);
            }
            byte[] byArray2 = messageDigest.digest();
            BigInteger bigInteger = new BigInteger(1, byArray2);
            String string = bigInteger.toString(16);
            String string2 = string = String.format("%32s", string).replace(' ', '0');
            return string2;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to process file for MD5", iOException);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                Log.e((String)"FileUtils", (String)"Exception on closing MD5 input stream", (Throwable)iOException);
            }
        }
    }

    public static String calculateMD5(File file, int n2, int n3) {
        FileInputStream fileInputStream;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.e((String)"FileUtils", (String)"Exception while getting digest", (Throwable)noSuchAlgorithmException);
            return null;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)"FileUtils", (String)"Exception while getting FileInputStream", (Throwable)fileNotFoundException);
            return null;
        }
        int n4 = 8192;
        byte[] byArray = new byte[8192];
        try {
            int n5;
            if (n2 > 0) {
                ((InputStream)fileInputStream).skip(n2);
            }
            int n6 = Math.min(8192, n3);
            int n7 = 0;
            while ((n5 = ((InputStream)fileInputStream).read(byArray, 0, n6)) > 0 && n7 < n3) {
                messageDigest.update(byArray, 0, n5);
                if ((n7 += n5) + 8192 <= n3) continue;
                n6 = n3 - n7;
            }
            byte[] byArray2 = messageDigest.digest();
            BigInteger bigInteger = new BigInteger(1, byArray2);
            String string = bigInteger.toString(16);
            String string2 = string = String.format("%32s", string).replace(' ', '0');
            return string2;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to process file for MD5", iOException);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                Log.e((String)"FileUtils", (String)"Exception on closing MD5 input stream", (Throwable)iOException);
            }
        }
    }

    public static boolean checkFile(File file) {
        return file != null && file.exists() && file.canRead() && (file.isDirectory() || file.isFile() && file.length() > 0L);
    }

    public static boolean checkFile(String string) {
        File file;
        return StringUtils.isNotEmpty(string) && (file = new File(string)) != null && file.exists() && file.canRead() && (file.isDirectory() || file.isFile() && file.length() > 0L);
    }

    public static String getExternalStorageDirectory() {
        String string = Environment.getExternalStorageDirectory().getPath();
        if (DeviceUtils.isZte()) {
            string = string.replace("/sdcard", "/sdcard-ext");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileSize(String string) {
        File file = null;
        long l2 = 0L;
        try {
            file = new File(string);
            l2 = file.length();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            file = null;
        }
        return l2 < 0L ? null : Long.valueOf(l2);
    }

    public static long getFileSize(File file) {
        return file == null ? 0L : file.length();
    }

    public static String getFileType(String string, String string2) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String string3 = fileNameMap.getContentTypeFor(string);
        return string3 == null ? string2 : string3;
    }

    public static String getFileType(String string) {
        return FileUtils.getFileType(string, "application/octet-stream");
    }

    public static String getFileExtension(String string) {
        int n2;
        String string2 = "";
        if (string != null && (n2 = string.lastIndexOf(".")) >= 0 && n2 < string.length() - 1) {
            string2 = string.substring(n2 + 1);
        }
        return string2.toLowerCase();
    }

    public static boolean deleteFile(File file) {
        if (file != null && file.exists() && !file.isDirectory()) {
            return file.delete();
        }
        return false;
    }

    public static void deleteDir(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    FileUtils.deleteDir(file2);
                }
                file2.delete();
            }
            file.delete();
        }
    }

    public static void deleteCacheFile(String string) {
        File file;
        if (string != null && string.length() > 0 && (file = new File(string)).exists() && file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory() || !file2.getName().contains(".ts") && !file2.getName().contains("temp")) continue;
                file2.delete();
            }
        }
    }

    public static void deleteCacheFile2TS(String string) {
        File file;
        if (string != null && string.length() > 0 && (file = new File(string)).exists() && file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory() || !file2.getName().contains(".ts")) continue;
                file2.delete();
            }
        }
    }

    public static void deleteDir(String string) {
        if (string != null && string.length() > 0) {
            FileUtils.deleteDir(new File(string));
        }
    }

    public static boolean deleteFile(String string) {
        if (string != null && string.length() > 0) {
            return FileUtils.deleteFile(new File(string));
        }
        return false;
    }

    public static String readFile(File file, String string) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (file == null || !file.isFile()) {
            return stringBuilder.toString();
        }
        BufferedReader bufferedReader = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!stringBuilder.toString().equals("")) {
                    stringBuilder.append("\r\n");
                }
                stringBuilder.append(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred. ", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException("IOException occurred. ", iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String readFile(String string, String string2) {
        return FileUtils.readFile(new File(string), string2);
    }

    public static String readFile(File file) {
        return FileUtils.readFile(file, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileCopy(String string, String string2) {
        boolean bl = false;
        int n2 = 1024;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[n2];
            int n3 = -1;
            while ((n3 = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n3);
            }
            fileOutputStream.flush();
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }
}

