/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;
import com.ucloudrtclib.sdkengine.define.UCloudRtcSdkRecordType;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRtcAudioResample;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.webrtc.ucloud.record.FileUtils;
import org.webrtc.ucloud.record.MediaRecorderBase;
import org.webrtc.ucloud.record.URTCRecordManager;
import org.webrtc.ucloud.record.model.LocalMediaConfig;
import org.webrtc.ucloud.record.model.MediaObject;
import org.webrtc.ucloud.record.model.OnlyCompressOverBean;

public class LocalMediaCompress
extends MediaRecorderBase {
    private final String mNeedCompressVideo;
    private final OnlyCompressOverBean mOnlyCompressOverBean;
    private final LocalMediaConfig localMediaConfig;
    protected String scaleWH = "";

    public LocalMediaCompress(LocalMediaConfig localMediaConfig) {
        this.localMediaConfig = localMediaConfig;
        this.compressConfig = localMediaConfig.getCompressConfig();
        CAPTURE_THUMBNAILS_TIME = localMediaConfig.getCaptureThumbnailsTime();
        if (localMediaConfig.getFrameRate() > 0) {
            this.setTranscodingFrameRate(localMediaConfig.getFrameRate());
        }
        this.mNeedCompressVideo = localMediaConfig.getVideoPath();
        this.mOnlyCompressOverBean = new OnlyCompressOverBean();
        this.mOnlyCompressOverBean.setVideoPath(this.mNeedCompressVideo);
    }

    private String getScaleWH(String string, float f2) {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(string);
        String string2 = mediaMetadataRetriever.extractMetadata(24);
        String string3 = mediaMetadataRetriever.extractMetadata(18);
        String string4 = mediaMetadataRetriever.extractMetadata(19);
        int n2 = Integer.valueOf(string3);
        int n3 = Integer.valueOf(string4);
        int n4 = (int)((float)n2 / f2);
        int n5 = (int)((float)n3 / f2);
        if (n5 % 2 != 0) {
            ++n5;
        }
        if (n4 % 2 != 0) {
            ++n4;
        }
        if (string2.equals("90") || string2.equals("270")) {
            return String.format("%dx%d", n5, n4);
        }
        if (string2.equals("0") || string2.equals("180") || string2.equals("360")) {
            return String.format("%dx%d", n4, n5);
        }
        return "";
    }

    private void correcAttribute(String string, String string2) {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(string);
        String string3 = mediaMetadataRetriever.extractMetadata(24);
        String string4 = mediaMetadataRetriever.extractMetadata(18);
        String string5 = mediaMetadataRetriever.extractMetadata(19);
        if (string3.equals("90") || string3.equals("270")) {
            SMALL_VIDEO_WIDTH = Integer.valueOf(string4);
            SMALL_VIDEO_HEIGHT = Integer.valueOf(string5);
            String string6 = this.checkPicRotaing(Integer.valueOf(string3), string2);
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                this.mOnlyCompressOverBean.setPicPath(string6);
            }
        } else if (string3.equals("0") || string3.equals("180") || string3.equals("360")) {
            SMALL_VIDEO_HEIGHT = Integer.valueOf(string4);
            SMALL_VIDEO_WIDTH = Integer.valueOf(string5);
        }
    }

    @Override
    public String getScaleWH() {
        return this.scaleWH;
    }

    private String checkPicRotaing(int n2, String string) {
        Bitmap bitmap = this.rotaingImageView(n2, BitmapFactory.decodeFile((String)string));
        return this.savePhoto(bitmap);
    }

    private Bitmap rotaingImageView(int n2, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)n2);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String savePhoto(Bitmap bitmap) {
        FileOutputStream fileOutputStream = null;
        String string = UUID.randomUUID().toString() + ".jpg";
        File file = new File(this.mMediaObject.getOutputDirectory(), string);
        try {
            fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            String string2 = null;
            return string2;
        }
        finally {
            try {
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return file.toString();
    }

    public OnlyCompressOverBean startCompress() {
        if (TextUtils.isEmpty((CharSequence)this.mNeedCompressVideo)) {
            return this.mOnlyCompressOverBean;
        }
        File file = new File(URTCRecordManager.getVideoCachePath());
        if (!FileUtils.checkFile(file)) {
            file.mkdirs();
        }
        String string = String.valueOf(System.currentTimeMillis());
        this.mMediaObject = this.setOutputDirectory(URTCRecordManager.getVideoCachePath());
        this.mMediaObject.setOutputTempVideoPath(this.mNeedCompressVideo);
        float f2 = this.localMediaConfig.getScale();
        if (f2 > 1.0f) {
            this.scaleWH = this.getScaleWH(this.mNeedCompressVideo, f2);
        }
        boolean bl = this.doCompress(true);
        this.mOnlyCompressOverBean.setSucceed(bl);
        if (bl) {
            this.mOnlyCompressOverBean.setVideoPath(this.mMediaObject.getOutputTempTranscodingVideoPath());
            this.mOnlyCompressOverBean.setPicPath(this.mMediaObject.getOutputVideoThumbPath());
            this.correcAttribute(this.mMediaObject.getOutputTempTranscodingVideoPath(), this.mMediaObject.getOutputVideoThumbPath());
        }
        return this.mOnlyCompressOverBean;
    }

    @Override
    public MediaObject.MediaPart startRecord(UCloudRtcSdkRecordType uCloudRtcSdkRecordType, String string, long l2) {
        return null;
    }

    @Override
    public void startAudioResample(UCloudRtcAudioResample uCloudRtcAudioResample, FileOutputStream fileOutputStream) {
    }

    @Override
    public void stopAudioResample() {
    }
}

