/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.hardware.Camera;
import android.os.Build;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.Log;
import android.view.SurfaceHolder;
import com.ucloudrtclib.sdkengine.listener.UCloudRtcRecordListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.webrtc.URTCFFmpegBridge;
import org.webrtc.ucloud.record.AudioRecorder;
import org.webrtc.ucloud.record.DeviceUtils;
import org.webrtc.ucloud.record.FFMpegUtils;
import org.webrtc.ucloud.record.FileUtils;
import org.webrtc.ucloud.record.IMediaRecorder;
import org.webrtc.ucloud.record.StringUtils;
import org.webrtc.ucloud.record.model.BaseMediaBitrateConfig;
import org.webrtc.ucloud.record.model.MediaObject;

public abstract class MediaRecorderBase
implements Camera.PreviewCallback,
SurfaceHolder.Callback,
IMediaRecorder {
    public static boolean NEED_FULL_SCREEN = false;
    public static int SMALL_VIDEO_HEIGHT = 480;
    public static int SMALL_VIDEO_WIDTH = 360;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_CAMERA_SET_PREVIEW_DISPLAY = 101;
    public static final int MEDIA_ERROR_CAMERA_PREVIEW = 102;
    public static final int MEDIA_ERROR_CAMERA_AUTO_FOCUS = 103;
    public static final int AUDIO_RECORD_ERROR_UNKNOWN = 0;
    public static final int AUDIO_RECORD_ERROR_SAMPLERATE_NOT_SUPPORT = 1;
    public static final int AUDIO_RECORD_ERROR_GET_MIN_BUFFER_SIZE_NOT_SUPPORT = 2;
    public static final int AUDIO_RECORD_ERROR_CREATE_FAILED = 3;
    public static final int VIDEO_BITRATE_NORMAL = 1024;
    public static final int VIDEO_BITRATE_MEDIUM = 1536;
    public static final int VIDEO_BITRATE_HIGH = 2048;
    protected static final int MESSAGE_ENCODE_START = 0;
    protected static final int MESSAGE_ENCODE_PROGRESS = 1;
    protected static final int MESSAGE_ENCODE_COMPLETE = 2;
    protected static final int MESSAGE_ENCODE_ERROR = 3;
    protected static int MAX_FRAME_RATE = 20;
    protected static int MIN_FRAME_RATE = 8;
    protected static int CAPTURE_THUMBNAILS_TIME = 1;
    protected BaseMediaBitrateConfig compressConfig;
    protected Camera camera;
    protected Camera.Parameters mParameters = null;
    protected List<Camera.Size> mSupportedPreviewSizes;
    protected SurfaceHolder mSurfaceHolder;
    protected AudioRecorder mAudioRecorder;
    protected MediaObject mMediaObject;
    protected OnEncodeListener mOnEncodeListener;
    protected OnErrorListener mOnErrorListener;
    protected OnPreparedListener mOnPreparedListener;
    protected UCloudRtcRecordListener mUCloudRtcRecordListener;
    protected int mFrameRate = MAX_FRAME_RATE;
    protected int mCameraId = 0;
    protected static int mVideoBitrate;
    public static int mSupportedPreviewWidth;
    protected boolean mPrepared;
    protected boolean mStartPreview;
    protected boolean mSurfaceCreated;
    protected volatile boolean mRecording;
    protected volatile long mPreviewFrameCallCount = 0L;
    private String mFrameRateCmd = "";

    public void setSurfaceHolder(SurfaceHolder surfaceHolder) {
        if (surfaceHolder != null) {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            if (!DeviceUtils.hasHoneycomb()) {
                surfaceHolder.setType(3);
            }
        }
    }

    public void setRecordState(boolean bl) {
        this.mRecording = bl;
    }

    public boolean getRecordState() {
        return this.mRecording;
    }

    public void setOnEncodeListener(OnEncodeListener onEncodeListener) {
        this.mOnEncodeListener = onEncodeListener;
    }

    public void setOnPreparedListener(OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setUCloudRtcRecordListener(UCloudRtcRecordListener uCloudRtcRecordListener) {
        this.mUCloudRtcRecordListener = uCloudRtcRecordListener;
    }

    public boolean isFrontCamera() {
        return this.mCameraId == 1;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=9)
    public static boolean isSupportFrontCamera() {
        if (!DeviceUtils.hasGingerbread()) {
            return false;
        }
        int n2 = Camera.getNumberOfCameras();
        return 2 == n2;
    }

    public void switchCamera(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.mCameraId = n2;
                this.stopPreview();
                this.startPreview();
            }
        }
    }

    public void switchCamera() {
        if (this.mCameraId == 0) {
            this.switchCamera(1);
        } else {
            this.switchCamera(0);
        }
    }

    public boolean autoFocus(Camera.AutoFocusCallback autoFocusCallback) {
        block5: {
            if (this.camera != null) {
                try {
                    String string;
                    this.camera.cancelAutoFocus();
                    if (this.mParameters != null && StringUtils.isNotEmpty(string = this.getAutoFocusMode())) {
                        this.mParameters.setFocusMode(string);
                        this.camera.setParameters(this.mParameters);
                    }
                    this.camera.autoFocus(autoFocusCallback);
                    return true;
                }
                catch (Exception exception) {
                    if (this.mOnErrorListener != null) {
                        this.mOnErrorListener.onVideoError(103, 0);
                    }
                    if (exception == null) break block5;
                    Log.e((String)"jianxi", (String)"autoFocus", (Throwable)exception);
                }
            }
        }
        return false;
    }

    private String getAutoFocusMode() {
        if (this.mParameters != null) {
            List list = this.mParameters.getSupportedFocusModes();
            if ((Build.MODEL.startsWith("GT-I950") || Build.MODEL.endsWith("SCH-I959") || Build.MODEL.endsWith("MEIZU MX3")) && this.isSupported(list, "continuous-picture")) {
                return "continuous-picture";
            }
            if (this.isSupported(list, "continuous-video")) {
                return "continuous-video";
            }
            if (this.isSupported(list, "auto")) {
                return "auto";
            }
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=14)
    public boolean manualFocus(Camera.AutoFocusCallback autoFocusCallback, List<Camera.Area> list) {
        block6: {
            if (this.camera != null && list != null && this.mParameters != null && DeviceUtils.hasICS()) {
                try {
                    this.camera.cancelAutoFocus();
                    if (this.mParameters.getMaxNumFocusAreas() > 0) {
                        this.mParameters.setFocusAreas(list);
                    }
                    if (this.mParameters.getMaxNumMeteringAreas() > 0) {
                        this.mParameters.setMeteringAreas(list);
                    }
                    this.mParameters.setFocusMode("macro");
                    this.camera.setParameters(this.mParameters);
                    this.camera.autoFocus(autoFocusCallback);
                    return true;
                }
                catch (Exception exception) {
                    if (this.mOnErrorListener != null) {
                        this.mOnErrorListener.onVideoError(103, 0);
                    }
                    if (exception == null) break block6;
                    Log.e((String)"jianxi", (String)"autoFocus", (Throwable)exception);
                }
            }
        }
        return false;
    }

    public boolean toggleFlashMode() {
        if (this.mParameters != null) {
            try {
                String string = this.mParameters.getFlashMode();
                if (TextUtils.isEmpty((CharSequence)string) || "off".equals(string)) {
                    this.setFlashMode("torch");
                } else {
                    this.setFlashMode("off");
                }
                return true;
            }
            catch (Exception exception) {
                Log.e((String)"jianxi", (String)"toggleFlashMode", (Throwable)exception);
            }
        }
        return false;
    }

    private boolean setFlashMode(String string) {
        if (this.mParameters != null && this.camera != null) {
            try {
                if ("torch".equals(string) || "off".equals(string)) {
                    this.mParameters.setFlashMode(string);
                    this.camera.setParameters(this.mParameters);
                }
                return true;
            }
            catch (Exception exception) {
                Log.e((String)"jianxi", (String)"setFlashMode", (Throwable)exception);
            }
        }
        return false;
    }

    public void setVideoBitRate(int n2) {
        if (n2 > 0) {
            mVideoBitrate = n2;
        }
    }

    public void prepare() {
        this.mPrepared = true;
        if (this.mSurfaceCreated) {
            this.startPreview();
        }
    }

    public MediaObject setOutputDirectory(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            File file = new File(string);
            if (file != null) {
                if (!file.exists() && file.isDirectory()) {
                    file.mkdirs();
                }
                if (file.exists()) {
                    this.mMediaObject = new MediaObject(string, mVideoBitrate);
                }
            }
        } else {
            this.mMediaObject = new MediaObject("", mVideoBitrate);
        }
        return this.mMediaObject;
    }

    public void setMediaObject(MediaObject mediaObject) {
        this.mMediaObject = mediaObject;
    }

    @Override
    public void stopRecord() {
        this.mRecording = false;
        this.setStopDate();
    }

    public void setStopDate() {
        MediaObject.MediaPart mediaPart;
        if (this.mMediaObject != null && (mediaPart = this.mMediaObject.getCurrentPart()) != null && mediaPart.recording) {
            mediaPart.recording = false;
            mediaPart.endTime = System.currentTimeMillis();
            mediaPart.duration = (int)(mediaPart.endTime - mediaPart.startTime);
            mediaPart.cutStartTime = 0;
            mediaPart.cutEndTime = mediaPart.duration;
        }
    }

    private void stopAllRecord() {
        this.mRecording = false;
        if (this.mMediaObject != null && this.mMediaObject.getMedaParts() != null) {
            for (MediaObject.MediaPart mediaPart : this.mMediaObject.getMedaParts()) {
                if (mediaPart == null || !mediaPart.recording) continue;
                mediaPart.recording = false;
                mediaPart.endTime = System.currentTimeMillis();
                mediaPart.duration = (int)(mediaPart.endTime - mediaPart.startTime);
                mediaPart.cutStartTime = 0;
                mediaPart.cutEndTime = mediaPart.duration;
                File file = new File(mediaPart.mediaPath);
                if (file == null || file.length() >= 1L) continue;
                this.mMediaObject.removePart(mediaPart, true);
            }
        }
    }

    private boolean isSupported(List<String> list, String string) {
        return list != null && list.contains(string);
    }

    protected void prepareCameraParaments() {
        int n2;
        boolean bl;
        if (this.mParameters == null) {
            return;
        }
        List list = this.mParameters.getSupportedPreviewFrameRates();
        if (list != null) {
            if (list.contains(MAX_FRAME_RATE)) {
                this.mFrameRate = MAX_FRAME_RATE;
            } else {
                bl = false;
                Collections.sort(list);
                for (n2 = list.size() - 1; n2 >= 0; --n2) {
                    if ((Integer)list.get(n2) > MAX_FRAME_RATE) continue;
                    this.mFrameRate = (Integer)list.get(n2);
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.mFrameRate = (Integer)list.get(0);
                }
            }
        }
        this.mParameters.setPreviewFrameRate(this.mFrameRate);
        bl = false;
        for (n2 = this.mSupportedPreviewSizes.size() - 1; n2 >= 0; --n2) {
            Camera.Size size = this.mSupportedPreviewSizes.get(n2);
            if (size.height != SMALL_VIDEO_HEIGHT) continue;
            mSupportedPreviewWidth = size.width;
            this.checkFullWidth(mSupportedPreviewWidth, SMALL_VIDEO_WIDTH);
            bl = true;
            break;
        }
        if (!bl) {
            Log.e((String)this.getClass().getSimpleName(), (String)"\u4f20\u5165\u9ad8\u5ea6\u4e0d\u652f\u6301\u6216\u672a\u627e\u5230\u5bf9\u5e94\u5bbd\u5ea6,\u8bf7\u6309\u7167\u8981\u6c42\u91cd\u65b0\u8bbe\u7f6e\uff0c\u5426\u5219\u4f1a\u51fa\u73b0\u4e00\u4e9b\u4e25\u91cd\u95ee\u9898");
            mSupportedPreviewWidth = 640;
            this.checkFullWidth(640, 360);
            SMALL_VIDEO_HEIGHT = 480;
        }
        this.mParameters.setPreviewSize(mSupportedPreviewWidth, SMALL_VIDEO_HEIGHT);
        this.mParameters.setPreviewFormat(842094169);
        String string = this.getAutoFocusMode();
        if (StringUtils.isNotEmpty(string)) {
            this.mParameters.setFocusMode(string);
        }
        if (this.isSupported(this.mParameters.getSupportedWhiteBalance(), "auto")) {
            this.mParameters.setWhiteBalance("auto");
        }
        if ("true".equals(this.mParameters.get("video-stabilization-supported"))) {
            this.mParameters.set("video-stabilization", "true");
        }
        if (!DeviceUtils.isDevice("GT-N7100", "GT-I9308", "GT-I9300")) {
            this.mParameters.set("cam_mode", 1);
            this.mParameters.set("cam-mode", 1);
        }
    }

    private void checkFullWidth(int n2, int n3) {
        SMALL_VIDEO_WIDTH = NEED_FULL_SCREEN ? n2 : n3;
    }

    public void startPreview() {
        if (this.mStartPreview || this.mSurfaceHolder == null || !this.mPrepared) {
            return;
        }
        this.mStartPreview = true;
        try {
            this.camera = this.mCameraId == 0 ? Camera.open() : Camera.open((int)this.mCameraId);
            this.camera.setDisplayOrientation(90);
            try {
                this.camera.setPreviewDisplay(this.mSurfaceHolder);
            }
            catch (IOException iOException) {
                if (this.mOnErrorListener != null) {
                    this.mOnErrorListener.onVideoError(101, 0);
                }
                Log.e((String)"jianxi", (String)("setPreviewDisplay fail " + iOException.getMessage()));
            }
            this.mParameters = this.camera.getParameters();
            this.mSupportedPreviewSizes = this.mParameters.getSupportedPreviewSizes();
            this.prepareCameraParaments();
            this.camera.setParameters(this.mParameters);
            this.setPreviewCallback();
            this.camera.startPreview();
            this.onStartPreviewSuccess();
            if (this.mOnPreparedListener != null) {
                this.mOnPreparedListener.onPrepared();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.mOnErrorListener != null) {
                this.mOnErrorListener.onVideoError(102, 0);
            }
            Log.e((String)"jianxi", (String)("startPreview fail :" + exception.getMessage()));
        }
    }

    protected void onStartPreviewSuccess() {
    }

    protected void setPreviewCallback() {
        Camera.Size size = this.mParameters.getPreviewSize();
        if (size != null) {
            int n2 = size.width * size.height * 3 / 2;
            try {
                this.camera.addCallbackBuffer(new byte[n2]);
                this.camera.addCallbackBuffer(new byte[n2]);
                this.camera.addCallbackBuffer(new byte[n2]);
                this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.e((String)"jianxi", (String)"startPreview...setPreviewCallback...", (Throwable)outOfMemoryError);
            }
            Log.e((String)"jianxi", (String)("startPreview...setPreviewCallbackWithBuffer...width:" + size.width + " height:" + size.height));
        } else {
            this.camera.setPreviewCallback((Camera.PreviewCallback)this);
        }
    }

    public void stopPreview() {
        if (this.camera != null) {
            try {
                this.camera.stopPreview();
                this.camera.setPreviewCallback(null);
                this.camera.release();
            }
            catch (Exception exception) {
                Log.e((String)"jianxi", (String)"stopPreview...");
            }
            this.camera = null;
        }
        this.mStartPreview = false;
    }

    public void release() {
        URTCFFmpegBridge.nativeRelease();
        this.stopAllRecord();
        this.stopPreview();
        if (this.mAudioRecorder != null) {
            this.mAudioRecorder.interrupt();
            this.mAudioRecorder = null;
        }
        this.mSurfaceHolder = null;
        this.mPrepared = false;
        this.mSurfaceCreated = false;
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mSurfaceHolder = surfaceHolder;
        this.mSurfaceCreated = true;
        if (this.mPrepared && !this.mStartPreview) {
            this.startPreview();
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
        this.mSurfaceHolder = surfaceHolder;
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceHolder = null;
        this.mSurfaceCreated = false;
    }

    @Override
    public void onAudioError(int n2, String string) {
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onAudioError(n2, string);
        }
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        camera.addCallbackBuffer(byArray);
    }

    public void testPreviewFrameCallCount() {
        new CountDownTimer(60000L, 1000L){

            public void onTick(long l2) {
                Log.e((String)"[Vitamio Recorder]", (String)("testFrameRate..." + MediaRecorderBase.this.mPreviewFrameCallCount));
                MediaRecorderBase.this.mPreviewFrameCallCount = 0L;
            }

            public void onFinish() {
            }
        }.start();
    }

    @Override
    public void receiveAudioData(byte[] byArray, int n2) {
    }

    protected String getScaleWH() {
        return "";
    }

    protected Boolean doCompress(boolean bl) {
        if (this.compressConfig != null) {
            String string;
            String string2 = " -vbr 4 ";
            if (this.compressConfig != null && this.compressConfig.getMode() == 2) {
                string2 = "";
            }
            string = !TextUtils.isEmpty((CharSequence)(string = this.getScaleWH())) ? "-s " + string : "";
            String string3 = String.format("ffmpeg -threads 16 -i %s -c:v libx264 %s %s %s -c:a libfdk_aac %s %s %s %s", this.mMediaObject.getOutputTempVideoPath(), this.getBitrateModeCommand(this.compressConfig, "", false), this.getBitrateCrfSize(this.compressConfig, "-crf 28", false), this.getBitrateVelocity(this.compressConfig, "-preset:v ultrafast", false), string2, this.getFrameRateCmd(), string, this.mMediaObject.getOutputTempTranscodingVideoPath());
            boolean bl2 = false;
            boolean bl3 = FFMpegUtils.captureThumbnails(this.mMediaObject.getOutputTempTranscodingVideoPath(), this.mMediaObject.getOutputVideoThumbPath(), String.valueOf(CAPTURE_THUMBNAILS_TIME));
            FileUtils.deleteCacheFile(this.mMediaObject.getOutputDirectory());
            boolean bl4 = bl && bl3 && bl2;
            return bl4;
        }
        boolean bl5 = FFMpegUtils.captureThumbnails(this.mMediaObject.getOutputTempVideoPath(), this.mMediaObject.getOutputVideoThumbPath(), String.valueOf(CAPTURE_THUMBNAILS_TIME));
        FileUtils.deleteCacheFile2TS(this.mMediaObject.getOutputDirectory());
        boolean bl6 = bl5 && bl;
        return bl6;
    }

    protected String getFrameRateCmd() {
        return this.mFrameRateCmd;
    }

    protected void setTranscodingFrameRate(int n2) {
        this.mFrameRateCmd = String.format(" -r %d", n2);
    }

    protected String getBitrateModeCommand(BaseMediaBitrateConfig baseMediaBitrateConfig, String string, boolean bl) {
        String string2 = "";
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "";
        }
        if (baseMediaBitrateConfig != null) {
            if (baseMediaBitrateConfig.getMode() == 1) {
                string2 = bl ? String.format(" -x264opts \"bitrate=%d:vbv-maxrate=%d\" ", baseMediaBitrateConfig.getBitrate(), baseMediaBitrateConfig.getMaxBitrate()) : String.format(" -x264opts bitrate=%d:vbv-maxrate=%d ", baseMediaBitrateConfig.getBitrate(), baseMediaBitrateConfig.getMaxBitrate());
                return string2;
            }
            if (baseMediaBitrateConfig.getMode() == 2) {
                string2 = bl ? String.format(" -x264opts \"bitrate=%d:vbv-bufsize=%d:nal_hrd=cbr\" ", baseMediaBitrateConfig.getBitrate(), baseMediaBitrateConfig.getBufSize()) : String.format(" -x264opts bitrate=%d:vbv-bufsize=%d:nal_hrd=cbr ", baseMediaBitrateConfig.getBitrate(), baseMediaBitrateConfig.getBufSize());
                return string2;
            }
        }
        return string;
    }

    protected String getBitrateCrfSize(BaseMediaBitrateConfig baseMediaBitrateConfig, String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "";
        }
        String string2 = "";
        if (baseMediaBitrateConfig != null && baseMediaBitrateConfig.getMode() == 3 && baseMediaBitrateConfig.getCrfSize() > 0) {
            string2 = bl ? String.format("-crf \"%d\" ", baseMediaBitrateConfig.getCrfSize()) : String.format("-crf %d ", baseMediaBitrateConfig.getCrfSize());
        } else {
            return string;
        }
        return string2;
    }

    protected String getBitrateVelocity(BaseMediaBitrateConfig baseMediaBitrateConfig, String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "";
        }
        String string2 = "";
        if (baseMediaBitrateConfig != null && !TextUtils.isEmpty((CharSequence)baseMediaBitrateConfig.getVelocity())) {
            string2 = bl ? String.format("-preset \"%s\" ", baseMediaBitrateConfig.getVelocity()) : String.format("-preset %s ", baseMediaBitrateConfig.getVelocity());
        } else {
            return string;
        }
        return string2;
    }

    static {
        mSupportedPreviewWidth = 0;
    }

    public static interface OnEncodeListener {
        public void onEncodeStart();

        public void onEncodeProgress(int var1);

        public void onEncodeComplete();

        public void onEncodeError();
    }

    public static interface OnErrorListener {
        public void onVideoError(int var1, int var2);

        public void onAudioError(int var1, String var2);
    }

    public static interface OnPreparedListener {
        public void onPrepared();
    }
}

