/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record;

import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.sdkengine.define.UCloudRtcSdkRecordType;
import com.ucloudrtclib.sdkengine.listener.UCloudRtcRecordListener;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRtcAudioResample;
import java.io.File;
import java.io.FileOutputStream;
import org.webrtc.URTCFFmpegBridge;
import org.webrtc.ucloud.record.FFMpegUtils;
import org.webrtc.ucloud.record.MediaRecorderBase;
import org.webrtc.ucloud.record.model.CameraParamObserver;
import org.webrtc.ucloud.record.model.MediaObject;

public class MediaRecorderNative
extends MediaRecorderBase
implements MediaRecorder.OnErrorListener,
URTCFFmpegBridge.FFmpegStateListener {
    private static final String TAG = "MediaRecorderNative";
    private static int out_width;
    private static int out_height;
    private static int out_fps;
    private static int device_orientation;
    public static CameraParamObserver cameraParamObserver;
    private static final String VIDEO_SUFFIX = ".mp4";

    @Override
    public void setUCloudRtcRecordListener(UCloudRtcRecordListener uCloudRtcRecordListener) {
        super.setUCloudRtcRecordListener(uCloudRtcRecordListener);
        URTCFFmpegBridge.registURTCRecordListener(uCloudRtcRecordListener);
    }

    @Override
    public MediaObject.MediaPart startRecord(UCloudRtcSdkRecordType uCloudRtcSdkRecordType, String string, long l2) {
        String string2;
        try {
            i.d(TAG, "mMediaObject: " + this.mMediaObject + "key: " + string);
            if (this.mMediaObject != null && out_height != 0 && out_width != 0 && out_fps != 0) {
                int n2 = 500000;
                if (out_width * out_height > 307200) {
                    n2 = 1000000;
                }
                URTCFFmpegBridge.period = l2;
                string2 = VIDEO_SUFFIX;
                String string3 = string;
                File file = new File(string3);
                String string4 = file.getParentFile().getPath();
                String string5 = this.mMediaObject.getOutputDirectory();
                if (uCloudRtcSdkRecordType == UCloudRtcSdkRecordType.U_CLOUD_RTC_SDK_RECORD_TYPE_MP4) {
                    if (string.endsWith(VIDEO_SUFFIX)) {
                        string3 = string.substring(string.lastIndexOf("/") + 1, string.indexOf(string2));
                    }
                    this.mMediaObject.setKey(string3);
                    if (TextUtils.isEmpty((CharSequence)string5) && !TextUtils.isEmpty((CharSequence)string3)) {
                        if (!file.getParentFile().exists()) {
                            if (file.getParentFile().mkdirs()) {
                                this.mMediaObject.setOutputVideoPath(file.getParentFile().getPath());
                                this.mMediaObject.setOutputDirectory(file.getParentFile().getPath());
                            }
                        } else {
                            this.mMediaObject.setOutputVideoPath(file.getParentFile().getPath());
                            this.mMediaObject.setOutputDirectory(file.getParentFile().getPath());
                        }
                    } else if (!TextUtils.isEmpty((CharSequence)string5) && !string4.equals(string5)) {
                        File file2 = new File(string4);
                        if (!file2.exists()) {
                            if (file2.mkdirs()) {
                                this.mMediaObject.setOutputVideoPath(file2.getPath());
                                this.mMediaObject.setOutputDirectory(file2.getPath());
                            }
                        } else {
                            this.mMediaObject.setOutputVideoPath(file2.getPath());
                            this.mMediaObject.setOutputDirectory(file2.getPath());
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.mMediaObject.getOutputDirectory()) && !TextUtils.isEmpty((CharSequence)this.mMediaObject.getKeyName())) {
                        i.d(TAG, "MediaRecorderNative startRecord path: " + this.mMediaObject.getOutputDirectory() + " name: " + this.mMediaObject.getKeyName() + " width : " + out_width + " height: " + out_height + " fps: " + out_fps);
                        URTCFFmpegBridge.nativePrepareFFmpegEncoder(this.mMediaObject.getOutputDirectory(), this.mMediaObject.getKeyName(), device_orientation, out_width, out_height, out_width, out_height, out_fps, n2);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        MediaObject.MediaPart mediaPart = null;
        if (this.mMediaObject != null) {
            mediaPart = this.mMediaObject.buildMediaPart(this.mCameraId, VIDEO_SUFFIX);
            string2 = String.format("filename = \"%s\"; ", mediaPart.mediaPath);
            this.mRecording = true;
        }
        return mediaPart;
    }

    @Override
    public void stopRecord() {
        super.stopRecord();
        if (this.mOnEncodeListener != null) {
            this.mOnEncodeListener.onEncodeStart();
        }
        i.d(TAG, " sdk stop local record: ");
        URTCFFmpegBridge.nativeRecordEnd();
    }

    @Override
    public void startAudioResample(UCloudRtcAudioResample uCloudRtcAudioResample, FileOutputStream fileOutputStream) {
        if (uCloudRtcAudioResample != null) {
            URTCFFmpegBridge.nativeSwitchAudioResample(true);
            URTCFFmpegBridge.setPcmOutputStream(fileOutputStream);
            URTCFFmpegBridge.registURTCAudioResampleListener(uCloudRtcAudioResample);
        }
    }

    @Override
    public void stopAudioResample() {
        URTCFFmpegBridge.clearURTCAudioResampleListener();
        URTCFFmpegBridge.flushPcmFileAndClearStream();
        URTCFFmpegBridge.nativeSwitchAudioResample(false);
    }

    @Override
    public void onPreviewFrame(byte[] byArray, Camera camera) {
        if (this.mRecording) {
            URTCFFmpegBridge.nativeEncodeFrame2H264(byArray);
            ++this.mPreviewFrameCallCount;
        }
        super.onPreviewFrame(byArray, camera);
    }

    @Override
    protected void onStartPreviewSuccess() {
    }

    public void onError(MediaRecorder mediaRecorder, int n2, int n3) {
        try {
            if (mediaRecorder != null) {
                mediaRecorder.reset();
            }
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)"jianxi", (String)"stopRecord", (Throwable)illegalStateException);
        }
        catch (Exception exception) {
            Log.w((String)"jianxi", (String)"stopRecord", (Throwable)exception);
        }
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onVideoError(n2, n3);
        }
    }

    @Override
    public void receiveAudioData(byte[] byArray, int n2) {
        if (this.mRecording && n2 > 0) {
            URTCFFmpegBridge.nativeEncodeFrame2AAC(byArray);
        }
    }

    @Override
    public void allRecordEnd() {
        final boolean bl = FFMpegUtils.captureThumbnails(this.mMediaObject.getOutputTempTranscodingVideoPath(), this.mMediaObject.getOutputVideoThumbPath(), String.valueOf(CAPTURE_THUMBNAILS_TIME));
        if (this.mOnEncodeListener != null) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        MediaRecorderNative.this.mOnEncodeListener.onEncodeComplete();
                    } else {
                        MediaRecorderNative.this.mOnEncodeListener.onEncodeError();
                    }
                }
            }, 0L);
        }
    }

    public void activityStop() {
        URTCFFmpegBridge.unRegistFFmpegStateListener(this);
    }

    static {
        cameraParamObserver = new CameraParamObserver(){
            private int mCameraWidth;
            private int mCameraHeight;
            private int mFps;
            private int mDeviceOrientation;
            private boolean mIsFrontCamera;

            @Override
            public void reportCameraOpenParam(int n2, int n3, int n4, int n5) {
                this.mCameraWidth = n2;
                this.mCameraHeight = n3;
                this.mFps = n5;
                this.mDeviceOrientation = n4;
                out_width = n2;
                out_height = n3;
                out_fps = n5;
                device_orientation = n4;
                i.d(MediaRecorderNative.TAG, "MediaRecorderNative report cameraOpen");
            }

            @Override
            public void reportCameraClosed() {
                out_width = 0;
                out_height = 0;
                out_fps = 0;
                device_orientation = 0;
                this.mIsFrontCamera = true;
                i.d(MediaRecorderNative.TAG, "MediaRecorderNative report cameraClosed set all value to 0");
            }

            @Override
            public int getWidth() {
                return this.mCameraWidth;
            }

            @Override
            public int getHeight() {
                return this.mCameraHeight;
            }

            @Override
            public int getFps() {
                return this.mFps;
            }

            @Override
            public int getDirection() {
                return this.mDeviceOrientation;
            }

            @Override
            public boolean isFrontCamera() {
                return this.mIsFrontCamera;
            }
        };
    }
}

