/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record;

import android.text.TextPaint;
import android.text.TextUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class StringUtils {
    public static final String EMPTY = "";
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd hh:mm:ss";
    private static final String DEFAULT_FILE_PATTERN = "yyyy-MM-dd-HH-mm-ss";
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    public static final SimpleDateFormat DATE_FORMAT_PART = new SimpleDateFormat("HH:mm");

    public static String currentTimeString() {
        return DATE_FORMAT_PART.format(Calendar.getInstance().getTime());
    }

    public static char chatAt(String string, int n2) {
        if (string != null && string.length() > 0) {
            return string.charAt(n2);
        }
        return ' ';
    }

    public static float GetTextWidth(String string, float f2) {
        if (StringUtils.isEmpty(string)) {
            return 0.0f;
        }
        TextPaint textPaint = new TextPaint();
        textPaint.setTextSize(f2);
        return textPaint.measureText(string.trim()) + (float)((int)((double)f2 * 0.1));
    }

    public static String formatDate(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static String formatDate(long l2, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(new Date(l2));
    }

    public static String formatDate(Date date) {
        return StringUtils.formatDate(date, DEFAULT_DATE_PATTERN);
    }

    public static String formatDate(long l2) {
        return StringUtils.formatDate(new Date(l2), DEFAULT_DATE_PATTERN);
    }

    public static String getDate() {
        return StringUtils.formatDate(new Date(), DEFAULT_DATE_PATTERN);
    }

    public static String createFileName() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_FILE_PATTERN);
        return simpleDateFormat.format(date);
    }

    public static String getDateTime() {
        return StringUtils.formatDate(new Date(), DEFAULT_DATETIME_PATTERN);
    }

    public static String formatDateTime(Date date) {
        return StringUtils.formatDate(date, DEFAULT_DATETIME_PATTERN);
    }

    public static String formatDateTime(long l2) {
        return StringUtils.formatDate(new Date(l2), DEFAULT_DATETIME_PATTERN);
    }

    public static String formatGMTDate(String string) {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        return StringUtils.formatDate(Calendar.getInstance(timeZone).getTimeInMillis());
    }

    public static String join(ArrayList<String> arrayList, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList != null && arrayList.size() > 0) {
            for (String string2 : arrayList) {
                stringBuffer.append(string2);
                stringBuffer.append(string);
            }
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        return stringBuffer.toString();
    }

    public static String join(Iterator<String> iterator, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                stringBuffer.append(string2);
                stringBuffer.append(string);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
            }
        }
        return stringBuffer.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0 || string.equalsIgnoreCase("null");
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static String trim(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String generateTime(long l2) {
        int n2 = (int)(l2 / 1000L);
        int n3 = n2 % 60;
        int n4 = n2 / 60 % 60;
        int n5 = n2 / 3600;
        return n5 > 0 ? String.format("%02d:%02d:%02d", n5, n4, n3) : String.format("%02d:%02d", n4, n3);
    }

    public static boolean isBlank(String string) {
        return TextUtils.isEmpty((CharSequence)string);
    }

    public static String gennerTime(int n2) {
        int n3 = n2 % 60;
        int n4 = n2 / 60 % 60;
        return String.format("%02d:%02d", n4, n3);
    }

    public static String generateFileSize(long l2) {
        String string = (double)l2 < 1024.0 ? l2 + "B" : ((double)l2 < 1048576.0 ? String.format("%.1f", (double)l2 / 1024.0) + "KB" : ((double)l2 < 1.073741824E9 ? String.format("%.1f", (double)l2 / 1048576.0) + "MB" : String.format("%.1f", (double)l2 / 1.073741824E9) + "GB"));
        return string;
    }

    public static String findString(String string, String string2, String string3) {
        int n2;
        int n3 = string2.length();
        int n4 = n2 = StringUtils.isEmpty(string2) ? 0 : string.indexOf(string2);
        if (n2 > -1) {
            int n5;
            int n6 = n5 = StringUtils.isEmpty(string3) ? -1 : string.indexOf(string3, n2 + n3);
            if (n5 > -1) {
                return string.substring(n2 + string2.length(), n5);
            }
        }
        return EMPTY;
    }

    public static String substring(String string, String string2, String string3, String string4) {
        int n2;
        int n3 = string2.length();
        int n4 = n2 = StringUtils.isEmpty(string2) ? 0 : string.indexOf(string2);
        if (n2 > -1) {
            int n5;
            int n6 = n5 = StringUtils.isEmpty(string3) ? -1 : string.indexOf(string3, n2 + n3);
            if (n5 > -1) {
                return string.substring(n2 + string2.length(), n5);
            }
            return string.substring(n2 + string2.length());
        }
        return string4;
    }

    public static String substring(String string, String string2, String string3) {
        return StringUtils.substring(string, string2, string3, EMPTY);
    }

    public static String concat(String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static String makeSafe(String string) {
        return string == null ? EMPTY : string;
    }
}

