/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record;

import android.text.TextUtils;
import com.ucloudrtclib.a.i;
import com.ucloudrtclib.sdkengine.define.UCloudRtcSdkRecordType;
import com.ucloudrtclib.sdkengine.listener.UCloudRtcRecordListener;
import com.ucloudrtclib.sdkengine.openinterface.UCloudRtcAudioResample;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.webrtc.URTCFFmpegBridge;
import org.webrtc.ucloud.record.MediaRecorderBase;
import org.webrtc.ucloud.record.MediaRecorderNative;
import org.webrtc.ucloud.record.model.MediaObject;

public class URTCRecordManager {
    private static final String TAG = "URTCRecordManager";
    private static String mPackageName;
    private static String mAppVersionName;
    private static int mAppVersionCode;
    private static String mVideoCachePath;
    private MediaRecorderBase mMediaRecorder;
    private MediaObject mMediaObject;
    private boolean mDebug;
    private String mLogPath;
    private String mPcmPath;
    private static URTCRecordManager instance;
    public static final String FFMPEG_LOG_FILENAME_TEMP = "jx_ffmpeg.log";

    public URTCRecordManager(boolean bl, String string, String string2) {
        this.mDebug = bl;
        this.mLogPath = string;
        this.initialize(bl, string, string2);
    }

    public static synchronized void init(String string) {
        if (instance == null) {
            instance = new URTCRecordManager(false, "", string);
        }
    }

    public static URTCRecordManager getInstance() {
        return instance;
    }

    public void startRecord(UCloudRtcSdkRecordType uCloudRtcSdkRecordType, String string, UCloudRtcRecordListener uCloudRtcRecordListener, long l2) {
        this.mMediaRecorder.setUCloudRtcRecordListener(uCloudRtcRecordListener);
        this.mMediaRecorder.startRecord(uCloudRtcSdkRecordType, string, l2);
    }

    public void stopRecord() {
        this.mMediaRecorder.stopRecord();
    }

    public void startAudioResample(UCloudRtcAudioResample uCloudRtcAudioResample, String string) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mPcmPath = string;
            File file = new File(this.mPcmPath);
            if (!file.exists()) {
                try {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdir();
                    }
                    bl = file.createNewFile();
                    i.d(TAG, "audioPcm create: " + bl);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            try {
                fileOutputStream = new FileOutputStream(this.mPcmPath);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        this.mMediaRecorder.startAudioResample(uCloudRtcAudioResample, fileOutputStream);
    }

    public void stopAudioResample() {
        this.mPcmPath = null;
        this.mMediaRecorder.stopAudioResample();
    }

    public void initialize(boolean bl, String string, String string2) {
        this.mMediaRecorder = new MediaRecorderNative();
        URTCRecordManager.setVideoCachePath(string2);
        this.mMediaObject = this.mMediaRecorder.setOutputDirectory(string2);
        i.d(TAG, "mediaObeject create: " + this.mMediaObject);
        URTCFFmpegBridge.nativeInitFFmpeg(this.mDebug, this.mLogPath);
    }

    public void changeDirectory(String string) {
        URTCRecordManager.setVideoCachePath(string);
        this.mMediaObject = this.mMediaRecorder.setOutputDirectory(string);
        i.d(TAG, "mediaObeject create: " + this.mMediaObject);
    }

    public static String getVideoCachePath() {
        return mVideoCachePath;
    }

    public static void setVideoCachePath(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            mVideoCachePath = string;
        } else {
            mVideoCachePath = "";
        }
    }
}

