/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record.model;

import android.os.Parcel;
import android.os.Parcelable;
import org.webrtc.ucloud.record.model.BaseMediaBitrateConfig;

public final class LocalMediaConfig
implements Parcelable {
    private final int FRAME_RATE;
    private final int captureThumbnailsTime;
    private final boolean GO_HOME;
    private final BaseMediaBitrateConfig compressConfig;
    private final String videoAddress;
    private final float scale;
    public static final Parcelable.Creator<LocalMediaConfig> CREATOR = new Parcelable.Creator<LocalMediaConfig>(){

        public LocalMediaConfig createFromParcel(Parcel parcel) {
            return new LocalMediaConfig(parcel);
        }

        public LocalMediaConfig[] newArray(int n2) {
            return new LocalMediaConfig[n2];
        }
    };

    private LocalMediaConfig(Buidler buidler) {
        this.captureThumbnailsTime = buidler.captureThumbnailsTime;
        this.FRAME_RATE = buidler.FRAME_RATE;
        this.compressConfig = buidler.compressConfig;
        this.videoAddress = buidler.videoPath;
        this.scale = buidler.scale;
        this.GO_HOME = buidler.GO_HOME;
    }

    protected LocalMediaConfig(Parcel parcel) {
        this.FRAME_RATE = parcel.readInt();
        this.captureThumbnailsTime = parcel.readInt();
        this.GO_HOME = parcel.readByte() != 0;
        this.compressConfig = (BaseMediaBitrateConfig)parcel.readParcelable(BaseMediaBitrateConfig.class.getClassLoader());
        this.videoAddress = parcel.readString();
        this.scale = parcel.readFloat();
    }

    public boolean isGO_HOME() {
        return this.GO_HOME;
    }

    public int getCaptureThumbnailsTime() {
        return this.captureThumbnailsTime;
    }

    public int getFrameRate() {
        return this.FRAME_RATE;
    }

    public BaseMediaBitrateConfig getCompressConfig() {
        return this.compressConfig;
    }

    public String getVideoPath() {
        return this.videoAddress;
    }

    public float getScale() {
        return this.scale;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.FRAME_RATE);
        parcel.writeInt(this.captureThumbnailsTime);
        parcel.writeByte((byte)(this.GO_HOME ? 1 : 0));
        parcel.writeParcelable((Parcelable)this.compressConfig, n2);
        parcel.writeString(this.videoAddress);
        parcel.writeFloat(this.scale);
    }

    public static class Buidler {
        private int captureThumbnailsTime = 1;
        private boolean GO_HOME = false;
        private BaseMediaBitrateConfig compressConfig;
        private int FRAME_RATE;
        private String videoPath;
        private float scale;

        public LocalMediaConfig build() {
            return new LocalMediaConfig(this);
        }

        public Buidler captureThumbnailsTime(int n2) {
            this.captureThumbnailsTime = n2;
            return this;
        }

        public Buidler doH264Compress(BaseMediaBitrateConfig baseMediaBitrateConfig) {
            this.compressConfig = baseMediaBitrateConfig;
            return this;
        }

        public Buidler goHome(boolean bl) {
            this.GO_HOME = bl;
            return this;
        }

        public Buidler setFramerate(int n2) {
            this.FRAME_RATE = n2;
            return this;
        }

        public Buidler setVideoPath(String string) {
            this.videoPath = string;
            return this;
        }

        public Buidler setScale(float f2) {
            this.scale = f2 <= 1.0f ? 1.0f : f2;
            return this;
        }
    }
}

