/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import org.webrtc.ucloud.record.FileUtils;
import org.webrtc.ucloud.record.StringUtils;
import org.webrtc.ucloud.record.model.MediaThemeObject;

public class MediaObject
implements Serializable {
    public static final int MEDIA_PART_TYPE_RECORD = 0;
    public static final int MEDIA_PART_TYPE_IMPORT_VIDEO = 1;
    public static final int MEDIA_PART_TYPE_IMPORT_IMAGE = 2;
    public static final int MEDIA_PART_TYPE_RECORD_MP4 = 3;
    public static final int DEFAULT_MAX_DURATION = 10000;
    public static final int DEFAULT_VIDEO_BITRATE = 800;
    private int mMaxDuration;
    private String mOutputDirectory;
    private String mOutputObjectPath;
    private int mVideoBitrate;
    private String mOutputVideoPath;
    private String mOutputVideoThumbPath;
    private String mKey;
    private volatile transient MediaPart mCurrentPart;
    private LinkedList<MediaPart> mMediaList = new LinkedList();
    public MediaThemeObject mThemeObject;
    private String outputTempVideoPath;

    public MediaObject(String string) {
        this(string, 800);
    }

    public MediaObject(String string, int n2) {
        this.mOutputDirectory = string;
        this.mVideoBitrate = n2;
        this.mOutputObjectPath = this.mOutputDirectory + File.separator + this.mKey + ".obj";
        this.mOutputVideoPath = this.mOutputDirectory + ".mp4";
        this.mOutputVideoThumbPath = this.mOutputDirectory + File.separator + this.mKey + ".jpg";
        this.mMaxDuration = 10000;
        this.outputTempVideoPath = this.mOutputDirectory + File.separator + this.mKey + "_temp.mp4";
    }

    public void setKey(String string) {
        this.mKey = string;
    }

    public String getKeyName() {
        return this.mKey;
    }

    public int getVideoBitrate() {
        return this.mVideoBitrate;
    }

    public int getMaxDuration() {
        return this.mMaxDuration;
    }

    public void setMaxDuration(int n2) {
        if (n2 >= 1000) {
            this.mMaxDuration = n2;
        }
    }

    public void setOutputVideoPath(String string) {
        this.mOutputVideoPath = string;
    }

    public void setOutputDirectory(String string) {
        this.mOutputDirectory = string;
    }

    public String getOutputDirectory() {
        return this.mOutputDirectory;
    }

    public String getOutputTempVideoPath() {
        return this.outputTempVideoPath;
    }

    public void setOutputTempVideoPath(String string) {
        this.outputTempVideoPath = string;
    }

    public String getOutputTempTranscodingVideoPath() {
        return this.mOutputDirectory + File.separator + this.mKey + ".mp4";
    }

    public void cleanTheme() {
        this.mThemeObject = null;
        if (this.mMediaList != null) {
            for (MediaPart mediaPart : this.mMediaList) {
                mediaPart.cutStartTime = 0;
                mediaPart.cutEndTime = mediaPart.duration;
            }
        }
    }

    public String getObjectFilePath() {
        if (StringUtils.isEmpty(this.mOutputObjectPath)) {
            String string;
            File file = new File(this.mOutputVideoPath);
            this.mOutputObjectPath = string = this.mOutputDirectory + File.separator + file.getName() + ".obj";
        }
        return this.mOutputObjectPath;
    }

    public String getOutputVideoPath() {
        return this.mOutputVideoPath;
    }

    public String getOutputVideoThumbPath() {
        return this.mOutputVideoThumbPath;
    }

    public int getDuration() {
        int n2 = 0;
        if (this.mMediaList != null) {
            for (MediaPart mediaPart : this.mMediaList) {
                n2 += mediaPart.getDuration();
            }
        }
        return n2;
    }

    public int getCutDuration() {
        int n2 = 0;
        if (this.mMediaList != null) {
            for (MediaPart mediaPart : this.mMediaList) {
                int n3 = mediaPart.cutEndTime - mediaPart.cutStartTime;
                if (mediaPart.speed != 10) {
                    n3 = (int)((float)n3 * (10.0f / (float)mediaPart.speed));
                }
                n2 += n3;
            }
        }
        return n2;
    }

    public void removePart(MediaPart mediaPart, boolean bl) {
        if (this.mMediaList != null) {
            this.mMediaList.remove(mediaPart);
        }
        if (mediaPart != null) {
            mediaPart.stop();
            if (bl) {
                mediaPart.delete();
            }
            this.mMediaList.remove(mediaPart);
            if (this.mCurrentPart != null && mediaPart.equals(this.mCurrentPart)) {
                this.mCurrentPart = null;
            }
        }
    }

    public MediaPart buildMediaPart(int n2) {
        this.mCurrentPart = new MediaPart();
        this.mCurrentPart.position = this.getDuration();
        this.mCurrentPart.index = this.mMediaList.size();
        this.mCurrentPart.mediaPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".v";
        this.mCurrentPart.audioPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".a";
        this.mCurrentPart.thumbPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".jpg";
        this.mCurrentPart.cameraId = n2;
        this.mCurrentPart.prepare();
        this.mCurrentPart.recording = true;
        this.mCurrentPart.startTime = System.currentTimeMillis();
        this.mCurrentPart.type = 1;
        this.mMediaList.add(this.mCurrentPart);
        return this.mCurrentPart;
    }

    public MediaPart buildMediaPart(int n2, String string) {
        this.mCurrentPart = new MediaPart();
        this.mCurrentPart.position = this.getDuration();
        this.mCurrentPart.index = this.mMediaList.size();
        this.mCurrentPart.mediaPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + string;
        this.mCurrentPart.audioPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".a";
        this.mCurrentPart.thumbPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".jpg";
        this.mCurrentPart.recording = true;
        this.mCurrentPart.cameraId = n2;
        this.mCurrentPart.startTime = System.currentTimeMillis();
        this.mCurrentPart.type = 1;
        this.mMediaList.add(this.mCurrentPart);
        return this.mCurrentPart;
    }

    public MediaPart buildMediaPart(String string, int n2, int n3) {
        this.mCurrentPart = new MediaPart();
        this.mCurrentPart.position = this.getDuration();
        this.mCurrentPart.index = this.mMediaList.size();
        this.mCurrentPart.mediaPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".v";
        this.mCurrentPart.audioPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".a";
        this.mCurrentPart.thumbPath = this.mOutputDirectory + File.separator + this.mCurrentPart.index + ".jpg";
        this.mCurrentPart.duration = n2;
        this.mCurrentPart.startTime = 0L;
        this.mCurrentPart.endTime = n2;
        this.mCurrentPart.cutStartTime = 0;
        this.mCurrentPart.cutEndTime = n2;
        this.mCurrentPart.tempPath = string;
        this.mCurrentPart.type = n3;
        this.mMediaList.add(this.mCurrentPart);
        return this.mCurrentPart;
    }

    public String getConcatYUV() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mMediaList != null && this.mMediaList.size() > 0) {
            if (this.mMediaList.size() == 1) {
                if (StringUtils.isEmpty(this.mMediaList.get((int)0).tempMediaPath)) {
                    stringBuilder.append(this.mMediaList.get((int)0).mediaPath);
                } else {
                    stringBuilder.append(this.mMediaList.get((int)0).tempMediaPath);
                }
            } else {
                stringBuilder.append("concat:");
                int n2 = this.mMediaList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    MediaPart mediaPart = this.mMediaList.get(i2);
                    if (StringUtils.isEmpty(mediaPart.tempMediaPath)) {
                        stringBuilder.append(mediaPart.mediaPath);
                    } else {
                        stringBuilder.append(mediaPart.tempMediaPath);
                    }
                    if (i2 + 1 >= n2) continue;
                    stringBuilder.append("|");
                }
            }
        }
        return stringBuilder.toString();
    }

    public String getConcatPCM() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mMediaList != null && this.mMediaList.size() > 0) {
            if (this.mMediaList.size() == 1) {
                if (StringUtils.isEmpty(this.mMediaList.get((int)0).tempAudioPath)) {
                    stringBuilder.append(this.mMediaList.get((int)0).audioPath);
                } else {
                    stringBuilder.append(this.mMediaList.get((int)0).tempAudioPath);
                }
            } else {
                stringBuilder.append("concat:");
                int n2 = this.mMediaList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    MediaPart mediaPart = this.mMediaList.get(i2);
                    if (StringUtils.isEmpty(mediaPart.tempAudioPath)) {
                        stringBuilder.append(mediaPart.audioPath);
                    } else {
                        stringBuilder.append(mediaPart.tempAudioPath);
                    }
                    if (i2 + 1 >= n2) continue;
                    stringBuilder.append("|");
                }
            }
        }
        return stringBuilder.toString();
    }

    public MediaPart getCurrentPart() {
        if (this.mCurrentPart != null) {
            return this.mCurrentPart;
        }
        if (this.mMediaList != null && this.mMediaList.size() > 0) {
            this.mCurrentPart = this.mMediaList.get(this.mMediaList.size() - 1);
        }
        return this.mCurrentPart;
    }

    public int getCurrentIndex() {
        MediaPart mediaPart = this.getCurrentPart();
        if (mediaPart != null) {
            return mediaPart.index;
        }
        return 0;
    }

    public MediaPart getPart(int n2) {
        if (this.mCurrentPart != null && n2 < this.mMediaList.size()) {
            return this.mMediaList.get(n2);
        }
        return null;
    }

    public void delete() {
        if (this.mMediaList != null) {
            for (MediaPart mediaPart : this.mMediaList) {
                mediaPart.stop();
            }
        }
        FileUtils.deleteDir(this.mOutputDirectory);
    }

    public LinkedList<MediaPart> getMedaParts() {
        return this.mMediaList;
    }

    public static void preparedMediaObject(MediaObject mediaObject) {
        if (mediaObject != null && mediaObject.mMediaList != null) {
            int n2 = 0;
            for (MediaPart mediaPart : mediaObject.mMediaList) {
                mediaPart.startTime = n2;
                mediaPart.endTime = mediaPart.startTime + (long)mediaPart.duration;
                n2 += mediaPart.duration;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mMediaList != null) {
            stringBuffer.append("[" + this.mMediaList.size() + "]");
            for (MediaPart mediaPart : this.mMediaList) {
                stringBuffer.append(mediaPart.mediaPath + ":" + mediaPart.duration + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public static class MediaPart
    implements Serializable {
        public int index;
        public String mediaPath;
        public String audioPath;
        public String tempMediaPath;
        public String tempAudioPath;
        public String thumbPath;
        public String tempPath;
        public int type = 0;
        public int cutStartTime;
        public int cutEndTime;
        public int duration;
        public int position;
        public int speed = 10;
        public int cameraId;
        public int yuvWidth;
        public int yuvHeight;
        public transient boolean remove;
        public transient long startTime;
        public transient long endTime;
        public transient FileOutputStream mCurrentOutputVideo;
        public transient FileOutputStream mCurrentOutputAudio;
        public volatile transient boolean recording;

        public void delete() {
            FileUtils.deleteFile(this.mediaPath);
            FileUtils.deleteFile(this.audioPath);
            FileUtils.deleteFile(this.thumbPath);
            FileUtils.deleteFile(this.tempMediaPath);
            FileUtils.deleteFile(this.tempAudioPath);
        }

        public void writeAudioData(byte[] byArray) {
            if (this.mCurrentOutputAudio != null) {
                this.mCurrentOutputAudio.write(byArray);
            }
        }

        public void writeVideoData(byte[] byArray) {
            if (this.mCurrentOutputVideo != null) {
                this.mCurrentOutputVideo.write(byArray);
            }
        }

        public void prepare() {
            try {
                this.mCurrentOutputVideo = new FileOutputStream(this.mediaPath);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.prepareAudio();
        }

        public void prepareAudio() {
            try {
                this.mCurrentOutputAudio = new FileOutputStream(this.audioPath);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public int getDuration() {
            return this.duration > 0 ? this.duration : (int)(System.currentTimeMillis() - this.startTime);
        }

        public void stop() {
            if (this.mCurrentOutputVideo != null) {
                try {
                    this.mCurrentOutputVideo.flush();
                    this.mCurrentOutputVideo.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.mCurrentOutputVideo = null;
            }
            if (this.mCurrentOutputAudio != null) {
                try {
                    this.mCurrentOutputAudio.flush();
                    this.mCurrentOutputAudio.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.mCurrentOutputAudio = null;
            }
        }
    }
}

