/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.ucloud.record.model;

import android.os.Parcel;
import android.os.Parcelable;

public final class MediaRecorderConfig
implements Parcelable {
    private final boolean FULL_SCREEN;
    private final int RECORD_TIME_MAX;
    private final int RECORD_TIME_MIN;
    private final int SMALL_VIDEO_HEIGHT;
    private final int SMALL_VIDEO_WIDTH;
    private final int MAX_FRAME_RATE;
    private final int MIN_FRAME_RATE;
    private final int VIDEO_BITRATE;
    private final int captureThumbnailsTime;
    private final boolean GO_HOME;
    public static final Parcelable.Creator<MediaRecorderConfig> CREATOR = new Parcelable.Creator<MediaRecorderConfig>(){

        public MediaRecorderConfig createFromParcel(Parcel parcel) {
            return new MediaRecorderConfig(parcel);
        }

        public MediaRecorderConfig[] newArray(int n2) {
            return new MediaRecorderConfig[n2];
        }
    };

    private MediaRecorderConfig(Buidler buidler) {
        this.FULL_SCREEN = buidler.FULL_SCREEN;
        this.RECORD_TIME_MAX = buidler.RECORD_TIME_MAX;
        this.RECORD_TIME_MIN = buidler.RECORD_TIME_MIN;
        this.MAX_FRAME_RATE = buidler.MAX_FRAME_RATE;
        this.captureThumbnailsTime = buidler.captureThumbnailsTime;
        this.MIN_FRAME_RATE = buidler.MIN_FRAME_RATE;
        this.SMALL_VIDEO_HEIGHT = buidler.SMALL_VIDEO_HEIGHT;
        this.SMALL_VIDEO_WIDTH = buidler.SMALL_VIDEO_WIDTH;
        this.VIDEO_BITRATE = buidler.VIDEO_BITRATE;
        this.GO_HOME = buidler.GO_HOME;
    }

    protected MediaRecorderConfig(Parcel parcel) {
        this.FULL_SCREEN = parcel.readByte() != 0;
        this.RECORD_TIME_MAX = parcel.readInt();
        this.RECORD_TIME_MIN = parcel.readInt();
        this.SMALL_VIDEO_HEIGHT = parcel.readInt();
        this.SMALL_VIDEO_WIDTH = parcel.readInt();
        this.MAX_FRAME_RATE = parcel.readInt();
        this.MIN_FRAME_RATE = parcel.readInt();
        this.VIDEO_BITRATE = parcel.readInt();
        this.captureThumbnailsTime = parcel.readInt();
        this.GO_HOME = parcel.readByte() != 0;
    }

    public boolean isGO_HOME() {
        return this.GO_HOME;
    }

    public boolean getFullScreen() {
        return this.FULL_SCREEN;
    }

    public int getCaptureThumbnailsTime() {
        return this.captureThumbnailsTime;
    }

    public int getMaxFrameRate() {
        return this.MAX_FRAME_RATE;
    }

    public int getMinFrameRate() {
        return this.MIN_FRAME_RATE;
    }

    public int getRecordTimeMax() {
        return this.RECORD_TIME_MAX;
    }

    public int getRecordTimeMin() {
        return this.RECORD_TIME_MIN;
    }

    public int getSmallVideoHeight() {
        return this.SMALL_VIDEO_HEIGHT;
    }

    public int getSmallVideoWidth() {
        return this.SMALL_VIDEO_WIDTH;
    }

    public int getVideoBitrate() {
        return this.VIDEO_BITRATE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeByte((byte)(this.FULL_SCREEN ? 1 : 0));
        parcel.writeInt(this.RECORD_TIME_MAX);
        parcel.writeInt(this.RECORD_TIME_MIN);
        parcel.writeInt(this.SMALL_VIDEO_HEIGHT);
        parcel.writeInt(this.SMALL_VIDEO_WIDTH);
        parcel.writeInt(this.MAX_FRAME_RATE);
        parcel.writeInt(this.MIN_FRAME_RATE);
        parcel.writeInt(this.VIDEO_BITRATE);
        parcel.writeInt(this.captureThumbnailsTime);
        parcel.writeByte((byte)(this.GO_HOME ? 1 : 0));
    }

    public static class Buidler {
        private int RECORD_TIME_MAX = 6000;
        private int SMALL_VIDEO_HEIGHT = 480;
        private int SMALL_VIDEO_WIDTH = 360;
        private int MAX_FRAME_RATE = 20;
        private int MIN_FRAME_RATE = 8;
        private int VIDEO_BITRATE;
        private int captureThumbnailsTime = 1;
        private boolean GO_HOME = false;
        public int RECORD_TIME_MIN = 1500;
        private boolean FULL_SCREEN = false;

        public MediaRecorderConfig build() {
            return new MediaRecorderConfig(this);
        }

        public Buidler captureThumbnailsTime(int n2) {
            this.captureThumbnailsTime = n2;
            return this;
        }

        public Buidler maxFrameRate(int n2) {
            this.MAX_FRAME_RATE = n2;
            return this;
        }

        public Buidler minFrameRate(int n2) {
            this.MIN_FRAME_RATE = n2;
            return this;
        }

        public Buidler recordTimeMax(int n2) {
            this.RECORD_TIME_MAX = n2;
            return this;
        }

        public Buidler recordTimeMin(int n2) {
            this.RECORD_TIME_MIN = n2;
            return this;
        }

        public Buidler smallVideoHeight(int n2) {
            this.SMALL_VIDEO_HEIGHT = n2;
            return this;
        }

        public Buidler smallVideoWidth(int n2) {
            this.SMALL_VIDEO_WIDTH = n2;
            return this;
        }

        public Buidler videoBitrate(int n2) {
            this.VIDEO_BITRATE = n2;
            return this;
        }

        public Buidler goHome(boolean bl) {
            this.GO_HOME = bl;
            return this;
        }

        public Buidler fullScreen(boolean bl) {
            this.FULL_SCREEN = bl;
            return this;
        }
    }
}

