/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.annotation.TargetApi;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import java.util.List;
import java.util.UUID;
import org.webrtc.Logging;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioEffects {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioEffects";
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    private static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    private static AudioEffect.Descriptor[] cachedEffects = null;
    private AcousticEchoCanceler aec = null;
    private NoiseSuppressor ns = null;
    private boolean shouldEnableAec = false;
    private boolean shouldEnableNs = false;

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.isAcousticEchoCancelerEffectAvailable();
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.isNoiseSuppressorEffectAvailable();
    }

    public static boolean isAcousticEchoCancelerBlacklisted() {
        List<String> list = WebRtcAudioUtils.getBlackListedModelsForAecUsage();
        boolean bl = list.contains(Build.MODEL);
        if (bl) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW AEC usage!");
        }
        return bl;
    }

    public static boolean isNoiseSuppressorBlacklisted() {
        List<String> list = WebRtcAudioUtils.getBlackListedModelsForNsUsage();
        boolean bl = list.contains(Build.MODEL);
        if (bl) {
            Logging.w(TAG, Build.MODEL + " is blacklisted for HW NS usage!");
        }
        return bl;
    }

    @TargetApi(value=18)
    private static boolean isAcousticEchoCancelerExcludedByUUID() {
        for (AudioEffect.Descriptor descriptor : WebRtcAudioEffects.getAvailableEffects()) {
            if (!descriptor.type.equals(AudioEffect.EFFECT_TYPE_AEC) || !descriptor.uuid.equals(AOSP_ACOUSTIC_ECHO_CANCELER)) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=18)
    private static boolean isNoiseSuppressorExcludedByUUID() {
        for (AudioEffect.Descriptor descriptor : WebRtcAudioEffects.getAvailableEffects()) {
            if (!descriptor.type.equals(AudioEffect.EFFECT_TYPE_NS) || !descriptor.uuid.equals(AOSP_NOISE_SUPPRESSOR)) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=18)
    private static boolean isAcousticEchoCancelerEffectAvailable() {
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AEC);
    }

    @TargetApi(value=18)
    private static boolean isNoiseSuppressorEffectAvailable() {
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_NS);
    }

    public static boolean canUseAcousticEchoCanceler() {
        boolean bl = WebRtcAudioEffects.isAcousticEchoCancelerSupported() && !WebRtcAudioUtils.useWebRtcBasedAcousticEchoCanceler() && !WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted() && !WebRtcAudioEffects.isAcousticEchoCancelerExcludedByUUID();
        Logging.d(TAG, "canUseAcousticEchoCanceler: " + bl);
        return bl;
    }

    public static boolean canUseNoiseSuppressor() {
        boolean bl = WebRtcAudioEffects.isNoiseSuppressorSupported() && !WebRtcAudioUtils.useWebRtcBasedNoiseSuppressor() && !WebRtcAudioEffects.isNoiseSuppressorBlacklisted() && !WebRtcAudioEffects.isNoiseSuppressorExcludedByUUID();
        Logging.d(TAG, "canUseNoiseSuppressor: " + bl);
        return bl;
    }

    public static WebRtcAudioEffects create() {
        return new WebRtcAudioEffects();
    }

    private WebRtcAudioEffects() {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
    }

    public boolean setAEC(boolean bl) {
        Logging.d(TAG, "setAEC(" + bl + ")");
        if (!WebRtcAudioEffects.canUseAcousticEchoCanceler()) {
            Logging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && bl != this.shouldEnableAec) {
            Logging.e(TAG, "Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = bl;
        return true;
    }

    public boolean setNS(boolean bl) {
        Logging.d(TAG, "setNS(" + bl + ")");
        if (!WebRtcAudioEffects.canUseNoiseSuppressor()) {
            Logging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && bl != this.shouldEnableNs) {
            Logging.e(TAG, "Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = bl;
        return true;
    }

    public void enable(int n2) {
        boolean bl;
        boolean bl2;
        Logging.d(TAG, "enable(audioSession=" + n2 + ")");
        WebRtcAudioEffects.assertTrue(this.aec == null);
        WebRtcAudioEffects.assertTrue(this.ns == null);
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            this.aec = AcousticEchoCanceler.create((int)n2);
            if (this.aec != null) {
                bl2 = this.aec.getEnabled();
                boolean bl3 = bl = this.shouldEnableAec && WebRtcAudioEffects.canUseAcousticEchoCanceler();
                if (this.aec.setEnabled(bl) != 0) {
                    Logging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                }
                Logging.d(TAG, "AcousticEchoCanceler: was " + (bl2 ? "enabled" : "disabled") + ", enable: " + bl + ", is now: " + (this.aec.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            this.ns = NoiseSuppressor.create((int)n2);
            if (this.ns != null) {
                bl2 = this.ns.getEnabled();
                boolean bl4 = bl = this.shouldEnableNs && WebRtcAudioEffects.canUseNoiseSuppressor();
                if (this.ns.setEnabled(bl) != 0) {
                    Logging.e(TAG, "Failed to set the NoiseSuppressor state");
                }
                Logging.d(TAG, "NoiseSuppressor: was " + (bl2 ? "enabled" : "disabled") + ", enable: " + bl + ", is now: " + (this.ns.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the NoiseSuppressor instance");
            }
        }
    }

    public void release() {
        Logging.d(TAG, "release");
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        if (this.ns != null) {
            this.ns.release();
            this.ns = null;
        }
    }

    @TargetApi(value=18)
    private boolean effectTypeIsVoIP(UUID uUID) {
        if (!WebRtcAudioUtils.runningOnJellyBeanMR2OrHigher()) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(uUID) && WebRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_NS.equals(uUID) && WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private static AudioEffect.Descriptor[] getAvailableEffects() {
        if (cachedEffects != null) {
            return cachedEffects;
        }
        cachedEffects = AudioEffect.queryEffects();
        return cachedEffects;
    }

    private static boolean isEffectTypeAvailable(UUID uUID) {
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        if (descriptorArray == null) {
            return false;
        }
        for (AudioEffect.Descriptor descriptor : descriptorArray) {
            if (!descriptor.type.equals(uUID)) continue;
            return true;
        }
        return false;
    }
}

