/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.iat;

import cn.xfyun.api.IatClient;
import cn.xfyun.model.request.iat.IatBusiness;
import cn.xfyun.model.request.iat.IatRequest;
import cn.xfyun.model.request.iat.IatRequestData;
import cn.xfyun.service.common.AbstractTimedTask;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.util.Base64;

public class IatSendTask
extends AbstractTimedTask {
    private static final int STATUS_FIRST_FRAME = 0;
    private static final int STATUS_CONTINUED_FRAME = 1;
    private static final int STATUS_LAST_FRAME = 2;
    private int status = 0;
    private IatClient iatClient = null;

    @Override
    public String businessDataProcess(byte[] contents, boolean isEnd) {
        if (isEnd) {
            this.status = 2;
        }
        switch (this.status) {
            case 0: {
                IatRequest frame = new IatRequest();
                JsonObject common = new JsonObject();
                common.addProperty("app_id", this.getIatClient().getAppId());
                IatBusiness business = new IatBusiness(this.getIatClient());
                IatRequestData data = new IatRequestData(this.getIatClient());
                data.setStatus(0);
                data.setAudio(Base64.getEncoder().encodeToString(contents));
                frame.setCommon(common);
                frame.setBusiness(business);
                frame.setData(data);
                this.status = 1;
                return StringUtils.gson.toJson((Object)frame);
            }
            case 1: {
                IatRequest continueFrame = new IatRequest();
                IatRequestData continueDate = new IatRequestData(this.getIatClient());
                continueDate.setStatus(1);
                continueDate.setAudio(Base64.getEncoder().encodeToString(contents));
                continueFrame.setData(continueDate);
                return StringUtils.gson.toJson((Object)continueFrame);
            }
            case 2: {
                IatRequest lastFrame = new IatRequest();
                IatRequestData lastData = new IatRequestData(this.getIatClient());
                lastData.setStatus(2);
                lastData.setAudio("");
                lastFrame.setData(lastData);
                return StringUtils.gson.toJson((Object)lastFrame);
            }
        }
        return null;
    }

    private IatClient getIatClient() {
        if (this.iatClient == null) {
            this.iatClient = (IatClient)this.webSocketClient;
            return this.iatClient;
        }
        return this.iatClient;
    }
}

