/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.lfasr;

import cn.xfyun.model.response.lfasr.LfasrMessage;
import cn.xfyun.service.lfasr.task.Task;
import cn.xfyun.util.HttpConnector;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfasrExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(LfasrExecutorService.class);
    private ExecutorService executor;
    private HttpConnector connector;
    private int thresholdTimeout = 60000;

    private LfasrExecutorService() {
    }

    public static LfasrExecutorService build(int coreThreads, int maxThreads, int maxConnections, int connTimeout, int soTimeout) {
        LfasrExecutorService processor = ProcessorBuilder.PROCESSOR;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Lfasr-pool-%d").build();
        processor.executor = new ThreadPoolExecutor(coreThreads, maxThreads, 5L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024), namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        processor.connector = HttpConnector.build((int)maxConnections, (int)connTimeout, (int)soTimeout, (int)3);
        processor.thresholdTimeout = connTimeout + soTimeout + 10000;
        return processor;
    }

    public LfasrMessage exec(Task task) {
        task.setConnector(this.connector);
        Future<LfasrMessage> future = this.executor.submit(task);
        return this.getFuture(future, task);
    }

    private LfasrMessage getFuture(Future<LfasrMessage> future, Task task) {
        LfasrMessage message;
        try {
            message = future.get(this.thresholdTimeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            logger.warn(task.getIntro() + ", " + e.getMessage());
            message = new LfasrMessage("\u670d\u52a1\u8c03\u7528\u5f02\u5e38");
        }
        catch (TimeoutException e) {
            logger.warn(task.getIntro() + ", " + e.getMessage());
            message = new LfasrMessage("\u8fde\u63a5\u8d85\u65f6! \u8bf7\u68c0\u67e5\u60a8\u7684\u7f51\u7edc");
        }
        catch (InterruptedException e) {
            logger.warn(task.getIntro() + ", " + e.getMessage());
            message = new LfasrMessage("\u670d\u52a1\u8c03\u7528\u5f02\u5e38");
            Thread.currentThread().interrupt();
        }
        return message;
    }

    private static class ProcessorBuilder {
        private static final LfasrExecutorService PROCESSOR = new LfasrExecutorService();

        private ProcessorBuilder() {
        }
    }
}

