/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.lfasr.task;

import cn.xfyun.config.LfasrTaskStatusEnum;
import cn.xfyun.model.response.lfasr.LfasrMessage;
import cn.xfyun.model.sign.LfasrSignature;
import cn.xfyun.service.lfasr.task.AbstractTask;
import java.security.SignatureException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger(PrepareTask.class);
    private final String fileName;

    public PrepareTask(LfasrSignature signature, Map<String, String> param) throws SignatureException {
        super(signature);
        this.param.putAll(param);
        this.fileName = param.get("file_name");
    }

    @Override
    public LfasrMessage call() {
        LfasrMessage message = new LfasrMessage();
        try {
            message = this.resolveMessage(this.connector.post("https://raasr.xfyun.cn/api/prepare", this.param));
            if (message.getOk() == LfasrTaskStatusEnum.STATUS_FAILED.getKey().intValue()) {
                message.setOk(LfasrTaskStatusEnum.STATUS_1.getKey());
            }
        }
        catch (Exception e) {
            logger.warn(this.getIntro() + " \u5904\u7406\u5931\u8d25", (Throwable)e);
            message.setOk(LfasrTaskStatusEnum.STATUS_1.getKey());
        }
        return message;
    }

    @Override
    public String getIntro() {
        return "prepare task: " + this.fileName;
    }
}

