/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.rta;

import cn.xfyun.util.IOCloseUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import okhttp3.WebSocket;
import okio.ByteString;

public class RtasrSendTask
implements Runnable {
    protected WebSocket webSocket;
    private Integer waitMillis = 40;
    private byte[] bytes;
    private InputStream inputStream;
    private Closeable closeable;
    private Integer frameSize = 1280;

    public RtasrSendTask build(Builder builder) {
        this.waitMillis = builder.waitMillis;
        this.bytes = builder.bytes;
        this.closeable = builder.closeable;
        this.inputStream = builder.inputStream;
        this.frameSize = builder.frameSize;
        this.webSocket = builder.webSocket;
        return this;
    }

    @Override
    public void run() {
        try {
            if (this.inputStream != null) {
                this.sendByInputStream(this.inputStream);
            } else {
                this.sendByBytes(this.bytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOCloseUtil.close((Closeable)this.closeable);
            IOCloseUtil.close((Closeable)this.inputStream);
            this.webSocket.send("{\"end\": true}");
        }
    }

    private void sendByBytes(byte[] bytes) throws InterruptedException {
        if (bytes != null && bytes.length > 0) {
            for (int i = 0; i < bytes.length; i += this.frameSize.intValue()) {
                int len = i + this.frameSize < bytes.length ? i + this.frameSize : bytes.length;
                byte[] cur = Arrays.copyOfRange(bytes, i, len);
                this.webSocket.send(ByteString.of((byte[])cur));
                Thread.sleep(this.waitMillis.intValue());
            }
        }
    }

    private void sendByInputStream(InputStream inputStream) throws IOException, InterruptedException {
        byte[] buffer = new byte[this.frameSize.intValue()];
        if (inputStream != null) {
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                if (len < this.frameSize) {
                    this.webSocket.send(ByteString.of((byte[])Arrays.copyOfRange(buffer, 0, len)));
                    break;
                }
                this.webSocket.send(ByteString.of((byte[])buffer));
                Thread.sleep(this.waitMillis.intValue());
            }
        }
    }

    public static final class Builder {
        private Integer waitMillis = 40;
        private WebSocket webSocket;
        private byte[] bytes;
        private Closeable closeable;
        private InputStream inputStream;
        private Integer frameSize = 1280;

        public Builder waitMillis(Integer waitMills) {
            this.waitMillis = waitMills;
            return this;
        }

        public Builder webSocket(WebSocket webSocket) {
            this.webSocket = webSocket;
            return this;
        }

        public Builder bytes(byte[] bytes) {
            this.bytes = bytes;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder closeable(Closeable closeable) {
            this.closeable = closeable;
            return this;
        }

        public Builder frameSize(Integer frameSize) {
            this.frameSize = frameSize;
            return this;
        }

        public void build(RtasrSendTask task) {
            task.build(this);
        }
    }
}

