/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangsw.generator.config;

import cn.zhangsw.generator.config.GlobalConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class AutoCodeConfig {
    private static GlobalConfig globalConfig;
    private static Configuration configuration;

    public static GlobalConfig getGlobalConfig() {
        return globalConfig;
    }

    public static void setGlobalConfig(GlobalConfig globalConfig) {
        if (StringUtils.isNotBlank((String)globalConfig.getBeanNameSuffix())) {
            globalConfig.setBeanNameSuffix(StringUtils.capitalize((String)globalConfig.getBeanNameSuffix()));
        }
        if (StringUtils.isNotBlank((String)globalConfig.getControllerNameSuffix())) {
            globalConfig.setControllerNameSuffix(StringUtils.capitalize((String)globalConfig.getControllerNameSuffix()));
        }
        if (StringUtils.isNotBlank((String)globalConfig.getDaoNameSuffix())) {
            globalConfig.setDaoNameSuffix(StringUtils.capitalize((String)globalConfig.getDaoNameSuffix()));
        }
        if (StringUtils.isNotBlank((String)globalConfig.getServiceNameSuffix())) {
            globalConfig.setServiceNameSuffix(StringUtils.capitalize((String)globalConfig.getServiceNameSuffix()));
        }
        AutoCodeConfig.globalConfig = globalConfig;
    }

    public static Configuration getConfig() {
        try {
            return new PropertiesConfiguration("auto_code/auto_code_config.properties");
        }
        catch (ConfigurationException e) {
            System.out.println("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
            return null;
        }
    }

    public static String getConfigkey(String key) {
        return configuration.getString("tablePrefix");
    }

    public static String columnToJava(String columnName) {
        return WordUtils.capitalizeFully((String)columnName, (char[])new char[]{'_'}).replace("_", "");
    }

    public static String tableToJava(String tableName) {
        if (StringUtils.isNotBlank((String)globalConfig.getTablePrefix())) {
            tableName = tableName.replaceFirst(globalConfig.getTablePrefix(), "");
        }
        return AutoCodeConfig.columnToJava(tableName);
    }

    static {
        configuration = AutoCodeConfig.getConfig();
        globalConfig = new GlobalConfig(null, configuration.getString("parentPack"), configuration.getString("parentPath"), configuration.getBoolean("cover"), configuration.getBoolean("swagger"), configuration.getString("javaSource"), configuration.getString("resources"), configuration.getString("xmlPath"), configuration.getString("beanPackageName"), configuration.getString("daoPackageName"), configuration.getString("controllerPackageName"), configuration.getString("servicePackageName"), StringUtils.capitalize((String)configuration.getString("beanNameSuffix")), StringUtils.capitalize((String)configuration.getString("daoNameSuffix")), StringUtils.capitalize((String)configuration.getString("controllerNameSuffix")), StringUtils.capitalize((String)configuration.getString("serviceNameSuffix")), configuration.getString("tablePrefix"), configuration.getBoolean("autoCode"), configuration.getString("author"));
    }
}

