/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangsw.generator.util;

import cn.hutool.core.util.StrUtil;
import cn.zhangsw.generator.util.StringUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

public class ConvertUtil {
    public static String toStr(Object value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static Integer[] toIntArray(String str) {
        return ConvertUtil.toIntArray(",", str);
    }

    public static Integer[] toIntArray(String split, String str) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return new Integer[0];
        }
        String[] strings = str.split(split);
        Integer[] ints = new Integer[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            Integer v;
            ints[i] = v = ConvertUtil.toInt(strings[i], 0);
        }
        return ints;
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String valueStr = ConvertUtil.toStr(value, null);
        if (StringUtils.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static List<String> toListStrArray(String str) {
        String[] stringArray = ConvertUtil.toStrArray(str);
        List<String> stringB = Arrays.asList(stringArray);
        return stringB;
    }

    public static String[] toStrArray(String str) {
        return ConvertUtil.toStrArray(",", str);
    }

    public static String[] toStrArray(String split, String str) {
        return str.split(split);
    }

    public static Long[] toLongArray(String str) {
        return ConvertUtil.toLongArray(",", str);
    }

    public static Long[] toLongArray(String split, String str) {
        if (StringUtils.isEmpty(str)) {
            return new Long[0];
        }
        String[] arr = str.split(split);
        Long[] longs = new Long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Long v;
            longs[i] = v = ConvertUtil.toLong(arr[i], null);
        }
        return longs;
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        String valueStr = ConvertUtil.toStr(value, null);
        if (StringUtils.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        String valueStr = ConvertUtil.toStr(value, null);
        if (StringUtils.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

