/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.http;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;

public final class Request {
    @NonNull
    private final Method method;
    @NonNull
    private final String url;
    @Nullable
    private final Map<String, String> headers;
    @Nullable
    private final String body;

    @NonNull
    Method getMethod() {
        return this.method;
    }

    @NonNull
    String getUrl() {
        return this.url;
    }

    @Nullable
    Map<String, String> getHeaders() {
        return this.headers;
    }

    @Nullable
    String getBody() {
        return this.body;
    }

    private Request(@NonNull Method method, @NonNull String url, @Nullable Map<String, String> headers, @Nullable String body) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.body = body;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static class Builder {
        private Method method = Method.GET;
        private String url;
        private Map<String, String> headers;
        private String body;

        public Builder(String url) {
            assert (url != null);
            this.url = url;
        }

        public Builder method(Method method) {
            assert (method != null);
            this.method = method;
            return this;
        }

        public Builder header(String name, String value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(name, value);
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Request build() {
            return new Request(this.method, this.url, this.headers, this.body);
        }
    }
}

