package co.datadome.api.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.util.*;

public class EnrichedHttpServletRequest extends HttpServletRequestWrapper {

    /**
     * construct a wrapper for this request
     */
    public EnrichedHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    private Map<String, String> headerMap = new HashMap<>();

    /**
     * add a header with given name and value
     * !!! possible issue: header should be case insensitive in the servlet, this is not enforce here
     */
    public void addHeader(String name, String value) {
        headerMap.put(name, value);
    }

    @Override
    public String getHeader(String name) {
        if (headerMap.containsKey(name)) {
            return headerMap.get(name);
        }
        return super.getHeader(name);
    }

    /**
     * get the Header names
     */
    @Override
    public Enumeration<String> getHeaderNames() {
        // servlet container doesn't allow servlets to use this method
        if (super.getHeaderNames() == null) {
            return null;
        }
        List<String> names = Collections.list(super.getHeaderNames());
        names.addAll(headerMap.keySet());
        return Collections.enumeration(names);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        Enumeration<String> headers = super.getHeaders(name);

        // servlet container doesn't allow servlets to use this method
        if (headers == null) {
            return null;
        }
        List<String> values = Collections.list(headers);
        if (headerMap.containsKey(name)) {
            values.add(headerMap.get(name));
        }
        return Collections.enumeration(values);
    }

}

