/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import analysis.EdaAnalysisResults;
import analysis.ExploitString;
import analysis.IdaAnalysisResults;
import java.util.LinkedList;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;

public interface NFAAnalyserInterface {
    public AnalysisResultsType containsEDA(NFAGraph var1);

    public EdaAnalysisResults getEdaAnalysisResults(NFAGraph var1);

    public ExploitString findEDAExploitString(NFAGraph var1) throws InterruptedException;

    public AnalysisResultsType containsIDA(NFAGraph var1);

    public IdaAnalysisResults getIdaAnalysisResults(NFAGraph var1);

    public ExploitString findIDAExploitString(NFAGraph var1) throws InterruptedException;

    public static final class IdaAnalysisResultsIda
    extends IdaAnalysisResults {
        private final int degree;
        private final LinkedList<NFAEdge> maxPath;

        public int getDegree() {
            return this.degree;
        }

        public LinkedList<NFAEdge> getMaxPath() {
            return this.maxPath;
        }

        IdaAnalysisResultsIda(NFAGraph originalGraph, int degree, LinkedList<NFAEdge> maxPath) {
            super(originalGraph, IdaAnalysisResults.IdaCases.IDA);
            this.degree = degree;
            this.maxPath = maxPath;
        }
    }

    public static final class IdaAnalysisResultsNoIda
    extends IdaAnalysisResults {
        IdaAnalysisResultsNoIda(NFAGraph originalGraph) {
            super(originalGraph, IdaAnalysisResults.IdaCases.NO_IDA);
        }
    }

    public static final class EdaAnalysisResultsFilter
    extends EdaAnalysisResults {
        private final NFAGraph pcScc;
        private final NFAVertexND startState;
        private final NFAVertexND endState;

        public NFAGraph getPcScc() {
            return this.pcScc;
        }

        public NFAVertexND getStartState() {
            return this.startState;
        }

        public NFAVertexND getEndState() {
            return this.endState;
        }

        EdaAnalysisResultsFilter(NFAGraph originalGraph, NFAGraph pcScc, NFAVertexND startState, NFAVertexND endState) {
            super(originalGraph, EdaAnalysisResults.EdaCases.FILTER);
            this.pcScc = pcScc;
            this.startState = startState;
            this.endState = endState;
        }
    }

    public static final class EdaAnalysisResultsESCC
    extends EdaAnalysisResults {
        private final NFAGraph originalScc;
        private final NFAEdge entranceEdge;
        private final NFAEdge exitEdge;

        public NFAGraph getOriginalScc() {
            return this.originalScc;
        }

        public NFAEdge getEntranceEdge() {
            return this.entranceEdge;
        }

        public NFAEdge getExitEdge() {
            return this.exitEdge;
        }

        EdaAnalysisResultsESCC(NFAGraph originalGraph, NFAGraph originalScc, NFAEdge startEdge, NFAEdge endEdge) {
            super(originalGraph, EdaAnalysisResults.EdaCases.ESCC);
            this.originalScc = originalScc;
            this.entranceEdge = startEdge;
            this.exitEdge = endEdge;
        }
    }

    public static final class EdaAnalysisResultsParallel
    extends EdaAnalysisResults {
        private final NFAGraph mergedScc;
        private final NFAVertexND sourceVertex;
        private final NFAEdge parallelEdge;

        public NFAGraph getMergedScc() {
            return this.mergedScc;
        }

        public NFAVertexND getSourceVertex() {
            return this.sourceVertex;
        }

        public NFAEdge getParallelEdge() {
            return this.parallelEdge;
        }

        EdaAnalysisResultsParallel(NFAGraph originalGraph, NFAGraph mergedScc, NFAVertexND sourceVertex, NFAEdge parallelEdge) {
            super(originalGraph, EdaAnalysisResults.EdaCases.PARALLEL);
            this.mergedScc = mergedScc;
            this.sourceVertex = sourceVertex;
            this.parallelEdge = parallelEdge;
        }
    }

    public static final class EdaAnalysisResultsNoEda
    extends EdaAnalysisResults {
        EdaAnalysisResultsNoEda(NFAGraph originalGraph) {
            super(originalGraph, EdaAnalysisResults.EdaCases.NO_EDA);
        }
    }

    public static enum AnalysisResultsType {
        EDA,
        NO_EDA,
        IDA,
        NO_IDA,
        TIMEOUT_IN_EDA,
        TIMEOUT_IN_IDA,
        ANALYSIS_FAILED;

    }
}

