/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import analysis.AnalysisSettings;
import analysis.EdaAnalysisResults;
import analysis.IdaAnalysisResults;
import analysis.NFAAnalyser;
import analysis.NFAAnalyserInterface;
import analysis.NFAAnalysisTools;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;

public class NFAAnalyserMerging
extends NFAAnalyser {
    public NFAAnalyserMerging(AnalysisSettings.PriorityRemovalStrategy priorityRemovalStrategy) {
        super(priorityRemovalStrategy);
    }

    private EdaAnalysisResults testCaseESCC(NFAGraph originalM, LinkedList<NFAGraph> sccsInOriginal, Map<NFAVertexND, NFAGraph> esccs) throws InterruptedException {
        HashMap<NFAGraph, LinkedList> sccToMergedESCCStatesMap = new HashMap<NFAGraph, LinkedList>();
        for (NFAGraph currentSCCInOriginal : sccsInOriginal) {
            for (NFAVertexND currentVertex : currentSCCInOriginal.vertexSet()) {
                if (!esccs.containsKey(currentVertex)) continue;
                LinkedList newList = sccToMergedESCCStatesMap.containsKey(currentVertex) ? (LinkedList)sccToMergedESCCStatesMap.get(currentVertex) : new LinkedList();
                newList.add(currentVertex);
                sccToMergedESCCStatesMap.put(currentSCCInOriginal, newList);
            }
        }
        for (NFAGraph currentSCCInOriginal : sccsInOriginal) {
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            LinkedList esscsInCurrentSCC = sccToMergedESCCStatesMap.containsKey((Object)currentSCCInOriginal) ? (LinkedList)sccToMergedESCCStatesMap.get((Object)currentSCCInOriginal) : new LinkedList();
            for (NFAVertexND mergedESCCInSCC : esscsInCurrentSCC) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                NFAGraph currentESCC = esccs.get(mergedESCCInSCC);
                HashMap<NFAVertexND, NFAEdge> entranceStates = new HashMap<NFAVertexND, NFAEdge>();
                HashMap<NFAVertexND, NFAEdge> exitStates = new HashMap<NFAVertexND, NFAEdge>();
                for (NFAVertexND v : currentESCC.vertexSet()) {
                    if (this.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    for (NFAEdge e : currentSCCInOriginal.incomingEdgesOf(v)) {
                        if (currentESCC.containsEdge(e) || entranceStates.containsKey(v)) continue;
                        entranceStates.put(v, e);
                    }
                    for (NFAEdge e : currentSCCInOriginal.outgoingEdgesOf(v)) {
                        if (currentESCC.containsEdge(e) || exitStates.containsKey(v)) continue;
                        exitStates.put(v, e);
                    }
                }
                for (NFAVertexND start : entranceStates.keySet()) {
                    if (this.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    HashMap<NFAVertexND, Integer> pathsToOtherVertices = NFAAnalysisTools.numWalksFrom(currentESCC, start);
                    for (Map.Entry<NFAVertexND, Integer> kv : pathsToOtherVertices.entrySet()) {
                        if (this.isInterrupted()) {
                            throw new InterruptedException();
                        }
                        NFAVertexND p = kv.getKey();
                        if (!exitStates.containsKey(p) || kv.getValue() <= 1) continue;
                        NFAEdge entranceEdge = (NFAEdge)entranceStates.get(start);
                        NFAEdge exitEdge = (NFAEdge)exitStates.get(p);
                        NFAAnalyserInterface.EdaAnalysisResultsESCC resultsObject = new NFAAnalyserInterface.EdaAnalysisResultsESCC(originalM, currentSCCInOriginal, entranceEdge, exitEdge);
                        return resultsObject;
                    }
                }
            }
        }
        return new NFAAnalyserInterface.EdaAnalysisResultsNoEda(originalM);
    }

    @Override
    protected EdaAnalysisResults calculateEdaAnalysisResults(NFAGraph originalM) throws InterruptedException {
        NFAGraph merged = originalM.copy();
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        LinkedList<NFAGraph> sccsInOriginal = NFAAnalysisTools.getStronglyConnectedComponents(originalM);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        Map<NFAVertexND, NFAGraph> esccs = NFAAnalysisTools.mergeStronglyConnectedComponents(merged, true);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        LinkedList<NFAGraph> sccsInMerged = NFAAnalysisTools.getStronglyConnectedComponents(merged);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        EdaAnalysisResults toReturn = new NFAAnalyserInterface.EdaAnalysisResultsNoEda(originalM);
        toReturn = this.edaTestCaseParallel(originalM, sccsInMerged);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (toReturn.edaCase != EdaAnalysisResults.EdaCases.NO_EDA) {
            return toReturn;
        }
        toReturn = this.testCaseESCC(originalM, sccsInOriginal, esccs);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (toReturn.edaCase != EdaAnalysisResults.EdaCases.NO_EDA) {
            return toReturn;
        }
        toReturn = this.edaTestCaseFilter(originalM, merged);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        return toReturn;
    }

    @Override
    protected EdaAnalysisResults calculateEdaUnprioritisedAnalysisResults(NFAGraph originalM) throws InterruptedException {
        NFAGraph merged = originalM.copy();
        NFAAnalysisTools.mergeStronglyConnectedComponents(merged, true);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        EdaAnalysisResults toReturn = new NFAAnalyserInterface.EdaAnalysisResultsNoEda(originalM);
        toReturn = this.edaUnprioritisedAnalysis(merged);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.UNPRIORITISE);
        return toReturn;
    }

    @Override
    protected IdaAnalysisResults calculateIdaAnalysisResults(NFAGraph originalM) throws InterruptedException {
        NFAGraph merged = originalM.copy();
        NFAAnalysisTools.mergeStronglyConnectedComponents(merged, true);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        IdaAnalysisResults toReturn = new NFAAnalyserInterface.IdaAnalysisResultsNoIda(originalM);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        toReturn = this.idaTestCaseFilter(originalM, merged);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        return toReturn;
    }

    @Override
    protected IdaAnalysisResults calculateIdaUnprioritisedAnalysisResults(NFAGraph originalM) throws InterruptedException {
        NFAGraph merged = originalM.copy();
        NFAAnalysisTools.mergeStronglyConnectedComponents(merged, true);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        IdaAnalysisResults toReturn = new NFAAnalyserInterface.IdaAnalysisResultsNoIda(originalM);
        toReturn = this.idaUnprioritisedAnalysis(merged);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.UNPRIORITISE);
        return toReturn;
    }
}

