/*
 * Decompiled with CFR 0.152.
 */
package preprocessor;

import preprocessor.OperatorExpansionRule;
import preprocessor.ParsingPreprocessor;

public class NonpreciseCountClosureOperatorExpansion
extends OperatorExpansionRule {
    private final int CONSTANT_CUTOFF = 32;
    private final int BOUND_DIFF_CUTOFF = Integer.MAX_VALUE;

    @Override
    protected void expandOperator(StringBuilder resultBuilder, ParsingPreprocessor.RegexToken factor, ParsingPreprocessor.RegexToken operator) {
        ParsingPreprocessor.CountClosureOperator cco = (ParsingPreprocessor.CountClosureOperator)operator;
        int low = cco.getLow();
        int high = cco.getHigh();
        if (low > 32) {
            StringBuilder expansionBuilder = new StringBuilder("(");
            expansionBuilder.append(factor.getRepresentation());
            expansionBuilder.append(factor.getRepresentation() + "*");
            expansionBuilder.append(")");
            resultBuilder.append((CharSequence)expansionBuilder);
        } else if (high - low >= Integer.MAX_VALUE) {
            this.expandUnbounded(resultBuilder, factor, cco);
        } else {
            switch (cco.getBoundsType()) {
                case CONSTANT_REPETITION: {
                    this.expandConstantRepitition(resultBuilder, factor, cco);
                    break;
                }
                case BOUNDED: {
                    this.expandBounded(resultBuilder, factor, cco);
                    break;
                }
                case UNBOUNDED: {
                    this.expandUnbounded(resultBuilder, factor, cco);
                }
            }
        }
    }

    private void expandBounded(StringBuilder resultBuilder, ParsingPreprocessor.RegexToken factor, ParsingPreprocessor.CountClosureOperator cco) {
        int i;
        int low = cco.getLow();
        int high = cco.getHigh();
        StringBuilder expansionBuilder = new StringBuilder("(");
        StringBuilder options = new StringBuilder();
        for (i = 0; i < low - 1; ++i) {
            expansionBuilder.append(factor.getRepresentation());
        }
        expansionBuilder.append("(");
        for (i = low; i <= high; ++i) {
            if (low == 0 && i == 0) {
                expansionBuilder.append("\\l");
            } else {
                options.append(factor.getRepresentation());
                expansionBuilder.append((CharSequence)options);
            }
            if (i >= high) continue;
            expansionBuilder.append("|");
        }
        expansionBuilder.append(")");
        expansionBuilder.append(")");
        resultBuilder.append((CharSequence)expansionBuilder);
    }

    private void expandUnbounded(StringBuilder resultBuilder, ParsingPreprocessor.RegexToken factor, ParsingPreprocessor.CountClosureOperator cco) {
        int low = cco.getLow();
        StringBuilder expansionBuilder = new StringBuilder("(");
        for (int i = 0; i < low; ++i) {
            expansionBuilder.append(factor.getRepresentation());
        }
        expansionBuilder.append(factor.getRepresentation() + "*");
        expansionBuilder.append(")");
        resultBuilder.append((CharSequence)expansionBuilder);
    }

    private void expandConstantRepitition(StringBuilder resultBuilder, ParsingPreprocessor.RegexToken factor, ParsingPreprocessor.CountClosureOperator cco) {
        int low = cco.getLow();
        StringBuilder expansionBuilder = new StringBuilder("(");
        for (int i = 0; i < low; ++i) {
            expansionBuilder.append(factor.getRepresentation());
        }
        expansionBuilder.append(")");
        resultBuilder.append((CharSequence)expansionBuilder);
    }

    @Override
    protected ParsingPreprocessor.RegexOperator getOperator() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ParsingPreprocessor.RegexOperator.OperatorType getOperatorType() {
        return ParsingPreprocessor.RegexOperator.OperatorType.COUNT;
    }
}

