/*
 * Decompiled with CFR 0.152.
 */
package preprocessor;

import java.util.List;
import preprocessor.ParsingPreprocessor;
import preprocessor.PreprocessorRule;

public class WildCardExpansionRule
implements PreprocessorRule {
    private final boolean MATCH_NEWLINE = true;

    @Override
    public String process(List<ParsingPreprocessor.RegexToken> tokenStream) {
        StringBuilder regexBuilder = new StringBuilder();
        ParsingPreprocessor.RegexToken[] tokens = new ParsingPreprocessor.RegexToken[tokenStream.size()];
        tokens = tokenStream.toArray(tokens);
        int numTokens = tokens.length;
        for (int i = 0; i < numTokens; ++i) {
            if (tokens[i].getTokenType() == ParsingPreprocessor.RegexToken.TokenType.REGEX_FACTOR) {
                ParsingPreprocessor.RegexFactor factorToken = (ParsingPreprocessor.RegexFactor)tokens[i];
                if (factorToken.getFactorType() == ParsingPreprocessor.RegexFactor.FactorType.WILD_CARD) {
                    int low = 0;
                    int high = 65535;
                    int nl = 10;
                    String expandTo = String.format("\\x%02x", low) + "-" + String.format("\\x{%02x}", high);
                    regexBuilder.append("[" + expandTo + "]");
                    continue;
                }
                if (factorToken.getFactorType() == ParsingPreprocessor.RegexFactor.FactorType.GROUP) {
                    ParsingPreprocessor.GroupFactor groupFactorToken = (ParsingPreprocessor.GroupFactor)factorToken;
                    ParsingPreprocessor.GroupFactor.GroupType type = groupFactorToken.getGroupType();
                    StringBuilder groupBuilder = new StringBuilder();
                    groupBuilder.append(this.process((List)groupFactorToken.factorContent));
                    switch (type) {
                        case NORMAL: {
                            regexBuilder.append("(" + groupBuilder.toString() + ")");
                            break;
                        }
                        case NEGLOOKAHEAD: {
                            regexBuilder.append("(?!" + groupBuilder.toString() + ")");
                            break;
                        }
                        case NEGLOOKBEHIND: {
                            regexBuilder.append("(?<!" + groupBuilder.toString() + ")");
                            break;
                        }
                        case POSLOOKAHEAD: {
                            regexBuilder.append("(?=" + groupBuilder.toString() + ")");
                            break;
                        }
                        case POSLOOKBEHIND: {
                            regexBuilder.append("(?<=" + groupBuilder.toString() + ")");
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    continue;
                }
                regexBuilder.append(factorToken.getRepresentation());
                continue;
            }
            regexBuilder.append(tokens[i].getRepresentation());
        }
        return regexBuilder.toString();
    }
}

