/*
 * Decompiled with CFR 0.152.
 */
package regexcompiler;

import analysis.AnalysisSettings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import matcher.MyMatcher;
import matcher.NFAMatcher;
import nfa.NFAGraph;
import regexcompiler.JavaParseTreeToNFAConverter;
import regexcompiler.ParseTree;
import regexcompiler.ParseTreeToNFAConverter;
import regexcompiler.RegexAnchor;
import regexcompiler.RegexCharacterClass;
import regexcompiler.RegexCountClosureOperator;
import regexcompiler.RegexEscapedSymbol;
import regexcompiler.RegexGroup;
import regexcompiler.RegexOperator;
import regexcompiler.RegexQuantifiableOperator;
import regexcompiler.RegexSubexpression;
import regexcompiler.RegexSymbol;
import regexcompiler.RegexToken;
import regexcompiler.ThompsonParseTreeToNFAConverter;
import regexcompiler.UnimplementedFunctionalityException;

public class MyPattern {
    private NFAGraph nfaGraph;
    private static final int MAX_REPETITION = Integer.MAX_VALUE;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Pattern should be specified as a command line argument (and possibly give an input string).");
        }
        if (args.length < 2) {
            String pattern = args[0];
            Tokeniser t = new Tokeniser(pattern);
            List tokenList = t.tokenise();
            Parser p = new Parser(pattern, tokenList);
            ParseTree parseTree = p.parse();
            System.out.println(parseTree);
            NFAGraph resultGraph = MyPattern.toNFAGraph(pattern, AnalysisSettings.NFAConstruction.JAVA);
            System.out.println((Object)resultGraph);
        } else {
            String pattern = args[0];
            String inputString = args[1];
            MyPattern myPattern = MyPattern.compile(pattern, AnalysisSettings.NFAConstruction.JAVA);
            MyMatcher myMatcher = myPattern.matcher(inputString);
            boolean matches = myMatcher.matches();
            System.out.println(pattern + " matches " + inputString + ": " + matches);
        }
    }

    private MyPattern(NFAGraph nfaGraph) {
        this.nfaGraph = nfaGraph;
    }

    public static MyPattern compile(String pattern, AnalysisSettings.NFAConstruction construction) {
        NFAGraph nfaGraph = MyPattern.toNFAGraph(pattern, construction);
        return new MyPattern(nfaGraph);
    }

    public MyMatcher matcher(String inputString) {
        if (this.nfaGraph == null) {
            throw new IllegalStateException("Pattern has not yet been compiled!");
        }
        return new RegexNFAMatcher(this.nfaGraph, inputString);
    }

    public static NFAGraph toNFAGraph(String pattern, AnalysisSettings.NFAConstruction construction) {
        ParseTreeToNFAConverter pttnc;
        Tokeniser t = new Tokeniser(pattern);
        List tokenList = t.tokenise();
        Parser p = new Parser(pattern, tokenList);
        ParseTree parseTree = p.parse();
        switch (construction) {
            case THOMPSON: {
                pttnc = new ThompsonParseTreeToNFAConverter();
                break;
            }
            case JAVA: {
                pttnc = new JavaParseTreeToNFAConverter();
                break;
            }
            default: {
                throw new RuntimeException("Unknown regex flavour");
            }
        }
        NFAGraph resultNFA = pttnc.convertParseTree(parseTree);
        return resultNFA;
    }

    static class RegexNFAMatcher
    extends NFAMatcher {
        private RegexNFAMatcher(NFAGraph nfaGraph, String inputString) {
            super(nfaGraph, inputString);
        }
    }

    private static class Parser {
        private final String pattern;
        private final List<RegexToken> tokenList;
        private Iterator<RegexToken> tokenIterator;
        private RegexToken currentToken;
        private int index;
        private boolean endOfStream;
        private boolean isNested;

        private boolean nextToken() {
            if (this.tokenIterator.hasNext()) {
                this.currentToken = this.tokenIterator.next();
                this.index = this.currentToken.getIndex();
                return true;
            }
            this.currentToken = null;
            this.endOfStream = true;
            return false;
        }

        public Parser(String pattern, List<RegexToken> tokenList) {
            this.isNested = false;
            this.pattern = pattern;
            this.tokenList = tokenList;
        }

        private Parser(boolean isNested, String pattern, List<RegexToken> tokenList) {
            this.isNested = true;
            this.pattern = pattern;
            this.tokenList = tokenList;
        }

        public ParseTree parse() {
            this.tokenIterator = this.tokenList.iterator();
            this.endOfStream = false;
            this.nextToken();
            ParseTree.TreeNode root = this.parseRegex();
            ParseTree pt = new ParseTree();
            pt.newRoot(root);
            return pt;
        }

        public ParseTree.TreeNode parseRegex() {
            if (this.currentToken.getTokenType() == RegexToken.TokenType.ANCHOR) {
                this.nextToken();
            }
            ParseTree.TreeNode root = this.parseTerm();
            while (this.checkEndOfTerm()) {
                ParseTree.TreeNode operatorNode = new ParseTree.TreeNode(this.currentToken);
                operatorNode.addChild(root);
                if (!this.nextToken()) continue;
                ParseTree.TreeNode nextTermNode = this.parseTerm();
                operatorNode.addChild(nextTermNode);
                root = operatorNode;
            }
            if (!this.endOfStream && this.currentToken.getTokenType() == RegexToken.TokenType.ANCHOR) {
                this.nextToken();
            }
            return root;
        }

        public ParseTree.TreeNode parseTerm() {
            ParseTree.TreeNode root;
            if (this.currentToken == null) {
                return new ParseTree.TreeNode(new RegexSymbol("", this.index));
            }
            if (this.currentToken.getTokenType() == RegexToken.TokenType.SUBEXPRESSION) {
                root = this.parseFactor();
            } else {
                if (this.currentToken.getTokenType() == RegexToken.TokenType.OPERATOR) {
                    RegexOperator operatorToken = (RegexOperator)this.currentToken;
                    if (operatorToken.getIsBinaryOperator()) {
                        return new ParseTree.TreeNode(new RegexSymbol("", this.index));
                    }
                    throw new PatternSyntaxException("Dangling meta character '" + operatorToken + "'", this.pattern, operatorToken.getIndex());
                }
                if (this.currentToken.getTokenType() == RegexToken.TokenType.ANCHOR) {
                    return new ParseTree.TreeNode(new RegexSymbol("", this.index));
                }
                throw new RuntimeException("Unknown token type: " + (Object)((Object)this.currentToken.getTokenType()));
            }
            while (!this.endOfStream && this.currentToken.getTokenType() == RegexToken.TokenType.SUBEXPRESSION) {
                ParseTree.TreeNode subexpressionNode = this.parseFactor();
                ParseTree.TreeNode joinOperatorNode = new ParseTree.TreeNode(new RegexOperator.RegexJoinOperator(this.index));
                joinOperatorNode.addChild(root);
                joinOperatorNode.addChild(subexpressionNode);
                root = joinOperatorNode;
            }
            return root;
        }

        public ParseTree.TreeNode parseFactor() {
            ParseTree.TreeNode root;
            if (this.currentToken.getTokenType() == RegexToken.TokenType.SUBEXPRESSION) {
                RegexOperator currentOperator;
                RegexSubexpression subexpressionToken = (RegexSubexpression)this.currentToken;
                if (subexpressionToken.getSubexpressionType() == RegexSubexpression.SubexpressionType.GROUP) {
                    RegexGroup groupToken = (RegexGroup)subexpressionToken;
                    RegexGroup.RegexGroupType groupTokenType = groupToken.getGroupType();
                    switch (groupTokenType) {
                        case NEGLOOKAHEAD: {
                            Parser p = new Parser(true, this.pattern, (List)groupToken.getSubexpressionContent());
                            ParseTree pt = p.parse();
                            ParseTree.TreeNode groupNode = new ParseTree.TreeNode(groupToken);
                            groupNode.addChild(pt.getRoot());
                            root = groupNode;
                            break;
                        }
                        case NEGLOOKBEHIND: {
                            Parser p = new Parser(true, this.pattern, (List)groupToken.getSubexpressionContent());
                            ParseTree pt = p.parse();
                            ParseTree.TreeNode groupNode = new ParseTree.TreeNode(groupToken);
                            groupNode.addChild(pt.getRoot());
                            root = groupNode;
                            break;
                        }
                        case NONCAPTURING: {
                            Parser p = new Parser(true, this.pattern, (List)groupToken.getSubexpressionContent());
                            ParseTree pt = p.parse();
                            ParseTree.TreeNode groupNode = new ParseTree.TreeNode(groupToken);
                            groupNode.addChild(pt.getRoot());
                            root = groupNode;
                            break;
                        }
                        case NORMAL: {
                            Parser p = new Parser(true, this.pattern, (List)groupToken.getSubexpressionContent());
                            ParseTree pt = p.parse();
                            ParseTree.TreeNode groupNode = new ParseTree.TreeNode(groupToken);
                            groupNode.addChild(pt.getRoot());
                            root = groupNode;
                            break;
                        }
                        case POSLOOKAHEAD: {
                            Parser p = new Parser(true, this.pattern, (List)groupToken.getSubexpressionContent());
                            ParseTree pt = p.parse();
                            ParseTree.TreeNode groupNode = new ParseTree.TreeNode(groupToken);
                            groupNode.addChild(pt.getRoot());
                            root = groupNode;
                            break;
                        }
                        case POSLOOKBEHIND: {
                            Parser p = new Parser(true, this.pattern, (List)groupToken.getSubexpressionContent());
                            ParseTree pt = p.parse();
                            ParseTree.TreeNode groupNode = new ParseTree.TreeNode(groupToken);
                            groupNode.addChild(pt.getRoot());
                            root = groupNode;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown group type: " + (Object)((Object)groupTokenType));
                        }
                    }
                } else {
                    ParseTree.TreeNode subexpressionNode;
                    root = subexpressionNode = new ParseTree.TreeNode(this.currentToken);
                }
                if (this.nextToken() && this.currentToken.getTokenType() == RegexToken.TokenType.OPERATOR && !(currentOperator = (RegexOperator)this.currentToken).getIsBinaryOperator()) {
                    ParseTree.TreeNode unaryOperatorNode = new ParseTree.TreeNode(currentOperator);
                    unaryOperatorNode.addChild(root);
                    root = unaryOperatorNode;
                    this.nextToken();
                }
            } else {
                if (this.currentToken.getTokenType() == RegexToken.TokenType.ANCHOR) {
                    RegexAnchor regexAnchorToken = (RegexAnchor)this.currentToken;
                    throw new UnimplementedFunctionalityException("Anchor at invalid position: " + (Object)((Object)regexAnchorToken.getAnchorType()) + " at " + regexAnchorToken.getIndex());
                }
                if (this.checkEndOfTerm()) {
                    return new ParseTree.TreeNode(new RegexSymbol("", this.index));
                }
                throw new PatternSyntaxException("Dangling meta character", this.pattern, this.index);
            }
            return root;
        }

        private boolean checkEndOfTerm() {
            return !this.endOfStream && this.currentToken.getTokenType() == RegexToken.TokenType.OPERATOR && ((RegexOperator)this.currentToken).getIsBinaryOperator();
        }
    }

    private static class Tokeniser {
        private final String pattern;
        private final char[] patternArr;
        private final int length;
        private int i;
        private List<RegexToken> tokenList;
        private Stack<List<RegexToken>> tokenListStack;
        private Stack<RegexGroup.RegexGroupType> groupTypeStack;
        private boolean verbatimMode;

        private Tokeniser(String pattern) {
            this.pattern = pattern;
            this.patternArr = pattern.toCharArray();
            this.length = this.patternArr.length;
            this.verbatimMode = false;
        }

        private List<RegexToken> tokenise() {
            this.tokenList = new ArrayList<RegexToken>();
            this.tokenListStack = new Stack();
            this.groupTypeStack = new Stack();
            this.i = 0;
            do {
                RegexSymbol rs;
                if (!this.verbatimMode) {
                    block1 : switch (this.patternArr[this.i]) {
                        case '^': {
                            RegexAnchor lineStartAnchor = new RegexAnchor(RegexAnchor.RegexAnchorType.LINESTART, this.i);
                            this.tokenList.add(lineStartAnchor);
                            ++this.i;
                            break;
                        }
                        case '$': {
                            RegexAnchor lineEndAnchor = new RegexAnchor(RegexAnchor.RegexAnchorType.LINEEND, this.i);
                            this.tokenList.add(lineEndAnchor);
                            ++this.i;
                            break;
                        }
                        case '[': {
                            RegexCharacterClass rcc = this.createTokenCharacterClass();
                            this.tokenList.add(rcc);
                            ++this.i;
                            break;
                        }
                        case '(': {
                            RegexGroup.RegexGroupType newGroupType = this.findGroupType();
                            this.groupTypeStack.push(newGroupType);
                            this.tokenListStack.push(this.tokenList);
                            this.tokenList = new ArrayList<RegexToken>();
                            break;
                        }
                        case ')': {
                            RegexGroup.RegexGroupType currentGroupType = this.groupTypeStack.pop();
                            RegexGroup rg = new RegexGroup(this.tokenList, currentGroupType, this.i);
                            this.tokenList = this.tokenListStack.pop();
                            this.tokenList.add(rg);
                            ++this.i;
                            break;
                        }
                        case '\\': {
                            ++this.i;
                            switch (this.patternArr[this.i]) {
                                case 'Q': {
                                    this.verbatimMode = true;
                                    ++this.i;
                                    break block1;
                                }
                            }
                            RegexEscapedSymbol res = this.createTokenEscapedSymbol();
                            this.tokenList.add(res);
                            break;
                        }
                        case '|': {
                            RegexOperator.RegexUnionOperator unionOperator = new RegexOperator.RegexUnionOperator(this.i);
                            this.tokenList.add(unionOperator);
                            ++this.i;
                            break;
                        }
                        case '*': {
                            RegexQuantifiableOperator.RegexStarOperator starOperator = (RegexQuantifiableOperator.RegexStarOperator)this.createQuantifiableOperator(RegexOperator.OperatorType.STAR);
                            this.tokenList.add(starOperator);
                            break;
                        }
                        case '+': {
                            RegexQuantifiableOperator.RegexPlusOperator plusOperator = (RegexQuantifiableOperator.RegexPlusOperator)this.createQuantifiableOperator(RegexOperator.OperatorType.PLUS);
                            this.tokenList.add(plusOperator);
                            break;
                        }
                        case '?': {
                            RegexQuantifiableOperator.RegexQuestionMarkOperator questionMarkOperator = (RegexQuantifiableOperator.RegexQuestionMarkOperator)this.createQuantifiableOperator(RegexOperator.OperatorType.QUESTION_MARK);
                            this.tokenList.add(questionMarkOperator);
                            break;
                        }
                        case '{': {
                            RegexCountClosureOperator countedClosureOperator;
                            int high;
                            int low;
                            String lowStr;
                            RegexQuantifiableOperator.QuantifierType countedClosureQuantifier;
                            StringBuilder countClosureOperatorBuilder = new StringBuilder();
                            try {
                                ++this.i;
                                while (this.patternArr[this.i] != '}') {
                                    countClosureOperatorBuilder.append(this.patternArr[this.i]);
                                    ++this.i;
                                }
                                ++this.i;
                                if (this.i < this.length && this.patternArr[this.i] == '?') {
                                    countedClosureQuantifier = RegexQuantifiableOperator.QuantifierType.RELUCTANT;
                                    ++this.i;
                                } else if (this.i < this.length && this.patternArr[this.i] == '+') {
                                    countedClosureQuantifier = RegexQuantifiableOperator.QuantifierType.POSSESSIVE;
                                    ++this.i;
                                } else {
                                    countedClosureQuantifier = RegexQuantifiableOperator.QuantifierType.GREEDY;
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException aiooe) {
                                throw new PatternSyntaxException("Unclosed counted closure", this.pattern, this.i);
                            }
                            String bounds = countClosureOperatorBuilder.toString();
                            Pattern boundedPattern = Pattern.compile("(\\d+),(\\d+)");
                            Pattern unboundedPattern = Pattern.compile("(\\d+),");
                            Pattern constantRepititionPattern = Pattern.compile("(\\d+)");
                            Matcher boundedMatcher = boundedPattern.matcher(bounds);
                            Matcher unboundedMatcher = unboundedPattern.matcher(bounds);
                            Matcher constantRepititionMatcher = constantRepititionPattern.matcher(bounds);
                            if (boundedMatcher.find()) {
                                lowStr = boundedMatcher.group(1);
                                low = Integer.parseInt(lowStr);
                                String highStr = boundedMatcher.group(2);
                                high = Integer.parseInt(highStr);
                                if (high < low || low < 0 || high > Integer.MAX_VALUE) {
                                    throw new PatternSyntaxException("Illegal repetition range", this.pattern, this.i);
                                }
                                countedClosureOperator = new RegexCountClosureOperator(low, high, countedClosureQuantifier, this.i);
                                this.tokenList.add(countedClosureOperator);
                                break;
                            }
                            if (unboundedMatcher.find()) {
                                lowStr = unboundedMatcher.group(1);
                                low = Integer.parseInt(lowStr);
                                if (low < 0 || low > Integer.MAX_VALUE) {
                                    throw new PatternSyntaxException("Illegal repetition range", this.pattern, this.i);
                                }
                                high = Integer.MAX_VALUE;
                                countedClosureOperator = new RegexCountClosureOperator(low, high, countedClosureQuantifier, this.i);
                                this.tokenList.add(countedClosureOperator);
                                break;
                            }
                            if (constantRepititionMatcher.find()) {
                                lowStr = constantRepititionMatcher.group(1);
                                low = Integer.parseInt(lowStr);
                                if (low < 0 || low > Integer.MAX_VALUE) {
                                    throw new PatternSyntaxException("Illegal repetition range", this.pattern, this.i);
                                }
                                high = low;
                                countedClosureOperator = new RegexCountClosureOperator(low, high, countedClosureQuantifier, this.i);
                                this.tokenList.add(countedClosureOperator);
                                break;
                            }
                            throw new PatternSyntaxException("Illegal repetition range", this.pattern, this.i);
                        }
                        default: {
                            RegexSymbol rs2 = new RegexSymbol("" + this.patternArr[this.i], this.i);
                            this.tokenList.add(rs2);
                            ++this.i;
                        }
                    }
                    continue;
                }
                if (this.patternArr[this.i] == '\\') {
                    ++this.i;
                    if (this.i < this.length && this.patternArr[this.i] == 'E') {
                        ++this.i;
                        this.verbatimMode = false;
                        continue;
                    }
                    rs = new RegexSymbol("\\", this.i);
                    this.tokenList.add(rs);
                    rs = new RegexSymbol("" + this.patternArr[this.i], this.i);
                    this.tokenList.add(rs);
                    ++this.i;
                    continue;
                }
                rs = new RegexSymbol("" + this.patternArr[this.i], this.i);
                this.tokenList.add(rs);
                ++this.i;
            } while (this.i < this.length);
            return this.tokenList;
        }

        private RegexCharacterClass createTokenCharacterClass() {
            StringBuilder characterClassBuilder = new StringBuilder();
            try {
                ++this.i;
                int depthCounter = 1;
                while (true) {
                    if (this.patternArr[this.i] == '[') {
                        ++depthCounter;
                    } else if (this.patternArr[this.i] == ']' && --depthCounter == 0) break;
                    if (this.patternArr[this.i] == '\\') {
                        ++this.i;
                        characterClassBuilder.append("\\" + this.patternArr[this.i]);
                    } else {
                        characterClassBuilder.append(this.patternArr[this.i]);
                    }
                    ++this.i;
                }
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new PatternSyntaxException("Unclosed character class", this.pattern, this.i);
            }
            return new RegexCharacterClass(characterClassBuilder.toString(), this.i);
        }

        private RegexEscapedSymbol createTokenEscapedSymbol() {
            RegexEscapedSymbol res;
            switch (this.patternArr[this.i]) {
                case 'x': {
                    StringBuilder hexStringBuilder = new StringBuilder();
                    try {
                        ++this.i;
                        if (this.patternArr[this.i] == '{') {
                            ++this.i;
                            while (this.patternArr[this.i] != '}') {
                                hexStringBuilder.append(this.patternArr[this.i]);
                                ++this.i;
                            }
                            ++this.i;
                        } else {
                            hexStringBuilder.append(this.patternArr[this.i]);
                            ++this.i;
                            hexStringBuilder.append(this.patternArr[this.i]);
                            ++this.i;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        throw new PatternSyntaxException("Unclosed hexadecimal escape sequence", this.pattern, this.i);
                    }
                    res = new RegexEscapedSymbol(hexStringBuilder.toString(), RegexEscapedSymbol.RegexEscapedSymbolType.HEX, this.i);
                    break;
                }
                case '0': {
                    StringBuilder octStringBuilder = new StringBuilder();
                    try {
                        int tmpNum = 0;
                        int octalDigitCounter = 0;
                        ++this.i;
                        if ('0' > this.patternArr[this.i] || this.patternArr[this.i] > '7') {
                            throw new PatternSyntaxException("Illegal octal escape sequence", this.pattern, this.i);
                        }
                        while (this.i < this.length && tmpNum < 255 && '0' <= this.patternArr[this.i] && this.patternArr[this.i] <= '7' && octalDigitCounter < 3) {
                            octStringBuilder.append(this.patternArr[this.i]);
                            tmpNum = Integer.parseInt(octStringBuilder.toString(), 8);
                            ++octalDigitCounter;
                            ++this.i;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new PatternSyntaxException("Illegal octal escape sequence", this.pattern, this.i);
                    }
                    res = new RegexEscapedSymbol(octStringBuilder.toString(), RegexEscapedSymbol.RegexEscapedSymbolType.OCTAL, this.i);
                    break;
                }
                case 'u': {
                    StringBuilder unicodeStringBuilder = new StringBuilder();
                    try {
                        ++this.i;
                        for (int j = 0; j < 4; ++j) {
                            unicodeStringBuilder.append(this.patternArr[this.i]);
                            ++this.i;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        throw new PatternSyntaxException("Illegal unicode escape sequence", this.pattern, this.i);
                    }
                    res = new RegexEscapedSymbol(unicodeStringBuilder.toString(), RegexEscapedSymbol.RegexEscapedSymbolType.UNICODE, this.i);
                    break;
                }
                case 'p': {
                    StringBuilder characterPropertyBuilder = new StringBuilder();
                    try {
                        ++this.i;
                        if (this.patternArr[this.i] == '{') {
                            ++this.i;
                            while (this.patternArr[this.i] != '}') {
                                characterPropertyBuilder.append(this.patternArr[this.i]);
                                ++this.i;
                            }
                            ++this.i;
                        } else {
                            characterPropertyBuilder.append(this.patternArr[this.i]);
                            ++this.i;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        throw new PatternSyntaxException("Unclosed character family escape sequence", this.pattern, this.i);
                    }
                    res = new RegexEscapedSymbol(characterPropertyBuilder.toString(), RegexEscapedSymbol.RegexEscapedSymbolType.CHARACTER_PROPERTY, this.i);
                    break;
                }
                default: {
                    String escapedChar;
                    try {
                        escapedChar = "" + this.patternArr[this.i];
                        ++this.i;
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        throw new PatternSyntaxException("Unexpected internal error", this.pattern, this.i);
                    }
                    res = new RegexEscapedSymbol(escapedChar, RegexEscapedSymbol.RegexEscapedSymbolType.CHARACTER, this.i);
                }
            }
            return res;
        }

        private RegexQuantifiableOperator createQuantifiableOperator(RegexOperator.OperatorType ot) {
            RegexQuantifiableOperator.QuantifierType quantifierType;
            ++this.i;
            if (this.i < this.length) {
                if (this.patternArr[this.i] == '?') {
                    ++this.i;
                    quantifierType = RegexQuantifiableOperator.QuantifierType.RELUCTANT;
                } else if (this.patternArr[this.i] == '+') {
                    ++this.i;
                    quantifierType = RegexQuantifiableOperator.QuantifierType.POSSESSIVE;
                } else {
                    quantifierType = RegexQuantifiableOperator.QuantifierType.GREEDY;
                }
            } else {
                quantifierType = RegexQuantifiableOperator.QuantifierType.GREEDY;
            }
            switch (ot) {
                case PLUS: {
                    return new RegexQuantifiableOperator.RegexPlusOperator(quantifierType, this.i);
                }
                case QUESTION_MARK: {
                    return new RegexQuantifiableOperator.RegexQuestionMarkOperator(quantifierType, this.i);
                }
                case STAR: {
                    return new RegexQuantifiableOperator.RegexStarOperator(quantifierType, this.i);
                }
            }
            throw new RuntimeException("Unknown operator: " + (Object)((Object)ot));
        }

        private RegexGroup.RegexGroupType findGroupType() {
            RegexGroup.RegexGroupType groupType;
            block13: {
                block9: {
                    block10: {
                        block12: {
                            block11: {
                                groupType = RegexGroup.RegexGroupType.NORMAL;
                                if (this.i >= this.length - 2 || this.patternArr[this.i + 1] != '?') break block9;
                                if (this.patternArr[this.i + 2] != '<') break block10;
                                if (this.i >= this.length - 3) break block11;
                                switch (this.patternArr[this.i + 3]) {
                                    case '=': {
                                        groupType = RegexGroup.RegexGroupType.POSLOOKBEHIND;
                                        break block12;
                                    }
                                    case '!': {
                                        groupType = RegexGroup.RegexGroupType.NEGLOOKBEHIND;
                                        break block12;
                                    }
                                    default: {
                                        throw new PatternSyntaxException("Unknown look-behind group", this.pattern, this.i);
                                    }
                                }
                            }
                            throw new PatternSyntaxException("Unknown look-behind group", this.pattern, this.i);
                        }
                        this.i += 4;
                        break block13;
                    }
                    switch (this.patternArr[this.i + 2]) {
                        case ':': {
                            groupType = RegexGroup.RegexGroupType.NONCAPTURING;
                            break;
                        }
                        case '=': {
                            groupType = RegexGroup.RegexGroupType.POSLOOKAHEAD;
                            break;
                        }
                        case '!': {
                            groupType = RegexGroup.RegexGroupType.NEGLOOKAHEAD;
                            break;
                        }
                        default: {
                            throw new PatternSyntaxException("Unknown inline modifier", this.pattern, this.i);
                        }
                    }
                    this.i += 3;
                    break block13;
                }
                ++this.i;
            }
            return groupType;
        }
    }
}

