/*
 * Decompiled with CFR 0.152.
 */
package regexcompiler;

import analysis.NFAAnalyserFlattening;
import analysis.NFAAnalysisTools;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;
import regexcompiler.NFACreator;
import regexcompiler.ParseTree;
import regexcompiler.RegexCharacterClass;
import regexcompiler.RegexCountClosureOperator;
import regexcompiler.RegexEscapedSymbol;
import regexcompiler.RegexGroup;
import regexcompiler.RegexOperator;
import regexcompiler.RegexQuantifiableOperator;
import regexcompiler.RegexSubexpression;
import regexcompiler.RegexSymbol;
import regexcompiler.RegexToken;

public abstract class ParseTreeToNFAConverter
implements NFACreator {
    private HashMap<NFAVertexND, NFAGraph> posLookAheadStates;
    private HashMap<NFAVertexND, NFAGraph> posLookBehindStates;
    private HashMap<NFAVertexND, NFAGraph> negLookAheadStates = new HashMap();
    private HashMap<NFAVertexND, NFAGraph> negLookBehindStates = new HashMap();
    private int stateCounter = 0;
    private int lookAroundStateCounter = 0;
    protected static final int MAX_REPETITION = Integer.MAX_VALUE;

    protected NFAVertexND nextState() {
        NFAVertexND newState = new NFAVertexND("q" + this.stateCounter);
        ++this.stateCounter;
        return newState;
    }

    protected NFAVertexND nextLookAroundState() {
        NFAVertexND newLookAroundState = new NFAVertexND("l" + this.lookAroundStateCounter);
        ++this.lookAroundStateCounter;
        return newLookAroundState;
    }

    protected ParseTreeToNFAConverter() {
        this.posLookAheadStates = new HashMap();
        this.posLookBehindStates = new HashMap();
    }

    public NFAGraph convertParseTree(ParseTree parseTree) {
        ParseTree.TreeNode root = parseTree.getRoot();
        NFAGraph nfaGraph = this.dfsBuild(root);
        nfaGraph = this.performLookAroundIntersection(nfaGraph);
        nfaGraph = this.renameNFAStates(nfaGraph);
        return nfaGraph;
    }

    private NFAGraph dfsBuild(ParseTree.TreeNode currentNode) {
        NFAGraph newNfaGraph;
        RegexToken regexToken = currentNode.getRegexToken();
        Iterator<ParseTree.TreeNode> childIterator = currentNode.getChildren().iterator();
        block0 : switch (regexToken.getTokenType()) {
            case OPERATOR: {
                RegexOperator regexOperator = (RegexOperator)regexToken;
                switch (regexOperator.getOperatorType()) {
                    case STAR: {
                        RegexQuantifiableOperator.RegexStarOperator starOperator = (RegexQuantifiableOperator.RegexStarOperator)regexOperator;
                        ParseTree.TreeNode operandNode = childIterator.next();
                        NFAGraph subgraph = this.dfsBuild(operandNode);
                        newNfaGraph = this.starNFA(subgraph, starOperator);
                        break block0;
                    }
                    case PLUS: {
                        RegexQuantifiableOperator.RegexPlusOperator plusOperator = (RegexQuantifiableOperator.RegexPlusOperator)regexOperator;
                        ParseTree.TreeNode operandNode = childIterator.next();
                        NFAGraph subgraph = this.dfsBuild(operandNode);
                        newNfaGraph = this.plusNFA(subgraph, plusOperator);
                        break block0;
                    }
                    case COUNT_CLOSURE: {
                        RegexCountClosureOperator countClosureOperator = (RegexCountClosureOperator)regexOperator;
                        ParseTree.TreeNode operandNode = childIterator.next();
                        NFAGraph subgraph = this.dfsBuild(operandNode);
                        newNfaGraph = this.countClosureNFA(subgraph, countClosureOperator);
                        break block0;
                    }
                    case QUESTION_MARK: {
                        RegexQuantifiableOperator.RegexQuestionMarkOperator questionMarkOperator = (RegexQuantifiableOperator.RegexQuestionMarkOperator)regexOperator;
                        ParseTree.TreeNode operandNode = childIterator.next();
                        NFAGraph subgraph = this.dfsBuild(operandNode);
                        newNfaGraph = this.questionMarkNFA(subgraph, questionMarkOperator);
                        break block0;
                    }
                    case UNION: {
                        ParseTree.TreeNode operandNode1 = childIterator.next();
                        ParseTree.TreeNode operandNode2 = childIterator.next();
                        NFAGraph subgraph1 = this.dfsBuild(operandNode1);
                        NFAGraph subgraph2 = this.dfsBuild(operandNode2);
                        newNfaGraph = this.unionNFAs(subgraph1, subgraph2);
                        break block0;
                    }
                    case JOIN: {
                        ParseTree.TreeNode operandNode1 = childIterator.next();
                        ParseTree.TreeNode operandNode2 = childIterator.next();
                        NFAGraph subgraph1 = this.dfsBuild(operandNode1);
                        NFAGraph subgraph2 = this.dfsBuild(operandNode2);
                        newNfaGraph = this.joinNFAs(subgraph1, subgraph2);
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown operator type.");
            }
            case SUBEXPRESSION: {
                RegexSubexpression regexSubexpression = (RegexSubexpression)regexToken;
                switch (regexSubexpression.getSubexpressionType()) {
                    case CHARACTER_CLASS: {
                        RegexCharacterClass regexCharacterClass = (RegexCharacterClass)regexSubexpression;
                        newNfaGraph = this.createBaseCaseSymbol(regexCharacterClass.toString());
                        break block0;
                    }
                    case ESCAPED_SYMBOL: {
                        RegexEscapedSymbol regexEscapedSymbol = (RegexEscapedSymbol)regexSubexpression;
                        newNfaGraph = this.createBaseCaseSymbol(regexEscapedSymbol.toString());
                        break block0;
                    }
                    case GROUP: {
                        RegexGroup regexGroup = (RegexGroup)regexSubexpression;
                        switch (regexGroup.getGroupType()) {
                            case NORMAL: {
                                ParseTree.TreeNode child = childIterator.next();
                                newNfaGraph = this.dfsBuild(child);
                                break block0;
                            }
                            case NEGLOOKAHEAD: {
                                throw new UnsupportedOperationException("Negative Look ahead symbols not supported");
                            }
                            case NONCAPTURING: {
                                ParseTree.TreeNode child = childIterator.next();
                                newNfaGraph = this.dfsBuild(child);
                                break block0;
                            }
                            case NEGLOOKBEHIND: {
                                throw new UnsupportedOperationException("Negative Look behind symbols not supported");
                            }
                            case POSLOOKAHEAD: {
                                throw new UnsupportedOperationException("Positive Look ahead symbols not supported");
                            }
                            case POSLOOKBEHIND: {
                                throw new UnsupportedOperationException("Positive Look behind symbols not supported");
                            }
                        }
                        throw new RuntimeException("Unknown Group type.");
                    }
                    case SYMBOL: {
                        RegexSymbol regexSymbol = (RegexSymbol)regexSubexpression;
                        String content = (String)regexSymbol.getSubexpressionContent();
                        newNfaGraph = this.createBaseCaseSymbol(content);
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown Subexpression type.");
            }
            default: {
                throw new RuntimeException("Unknown Token type.");
            }
        }
        return newNfaGraph;
    }

    protected NFAVertexND deriveVertex(NFAGraph m, NFAVertexND v) {
        String newName = "" + v.getStateNumberByDimension(1).charAt(0);
        int i = 0;
        while (m.containsVertex(v)) {
            v = new NFAVertexND(newName + i);
            ++i;
        }
        return v;
    }

    private NFAGraph createWildCardStarNFA(int index) {
        NFAGraph wildCardStar = this.createBaseCaseSymbol(".");
        return this.starNFA(wildCardStar, new RegexQuantifiableOperator.RegexStarOperator(RegexQuantifiableOperator.QuantifierType.GREEDY, index));
    }

    private NFAGraph performLookAroundIntersection(NFAGraph nfaGraph) {
        NFAGraph intersectedGraph = nfaGraph.copy();
        for (Map.Entry<NFAVertexND, NFAGraph> kv : this.posLookAheadStates.entrySet()) {
            NFAVertexND lookAroundState = kv.getKey();
            NFAGraph lookAroundNFA = kv.getValue();
            intersectedGraph = this.performPositiveLookAheadIntersection(intersectedGraph, lookAroundState, lookAroundNFA);
        }
        return intersectedGraph;
    }

    private NFAGraph performPositiveLookAheadIntersection(NFAGraph nfa, NFAVertexND lookAroundState, NFAGraph lookAroundNFA) {
        NFAGraph intersectedNFA = nfa.copy();
        try {
            NFAVertexND oldInitialState = intersectedNFA.getInitialState();
            intersectedNFA.setInitialState(lookAroundState);
            HashSet<NFAVertexND> trimmedStates = new HashSet<NFAVertexND>();
            intersectedNFA = NFAAnalysisTools.makeTrimFromStart(intersectedNFA);
            for (NFAVertexND v : nfa.vertexSet()) {
                if (intersectedNFA.containsVertex(v)) continue;
                trimmedStates.add(v);
            }
            intersectedNFA = NFAAnalysisTools.productConstructionAFB(intersectedNFA, lookAroundNFA);
            intersectedNFA = NFAAnalyserFlattening.flattenNFA(intersectedNFA);
            Set intersectionVertices = intersectedNFA.vertexSet();
            for (NFAVertexND v : trimmedStates) {
                intersectedNFA.addVertex(v);
            }
            for (NFAVertexND v : trimmedStates) {
                for (NFAEdge e : nfa.outgoingEdgesOf(v)) {
                    NFAVertexND target = e.getTargetVertex();
                    if (trimmedStates.contains(target)) {
                        NFAEdge newEdge = new NFAEdge(v, target, e.getTransitionLabel());
                        intersectedNFA.addEdge(newEdge);
                        continue;
                    }
                    for (NFAVertexND intersectionVertex : intersectionVertices) {
                        if (!intersectionVertex.getStateByDimension(1).equals(target)) continue;
                        NFAEdge newEdge = new NFAEdge(v, intersectionVertex, e.getTransitionLabel());
                        intersectedNFA.addEdge(newEdge);
                    }
                }
            }
            for (NFAVertexND v : intersectedNFA.vertexSet()) {
                if (!v.getStateByDimension(1).equals(oldInitialState)) continue;
                intersectedNFA.setInitialState(v);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            System.exit(0);
        }
        return intersectedNFA;
    }

    private NFAGraph renameNFAStates(NFAGraph nfa) {
        NFAGraph renamedNFA = new NFAGraph();
        HashMap<NFAVertexND, NFAVertexND> renamingMap = new HashMap<NFAVertexND, NFAVertexND>();
        for (NFAVertexND v : nfa.vertexSet()) {
            NFAVertexND renamedState = this.nextState();
            renamingMap.put(v, renamedState);
            renamedNFA.addVertex(renamedState);
        }
        renamedNFA.setInitialState((NFAVertexND)renamingMap.get(nfa.getInitialState()));
        for (NFAVertexND v : nfa.getAcceptingStates()) {
            renamedNFA.addAcceptingState((NFAVertexND)renamingMap.get(v));
        }
        for (NFAEdge e : nfa.edgeSet()) {
            NFAVertexND source = (NFAVertexND)renamingMap.get(e.getSourceVertex());
            NFAVertexND target = (NFAVertexND)renamingMap.get(e.getTargetVertex());
            NFAEdge newEdge = new NFAEdge(source, target, e.getTransitionLabel());
            renamedNFA.addEdge(newEdge);
        }
        return renamedNFA;
    }
}

