/*
 * Decompiled with CFR 0.152.
 */
package regexcompiler;

import regexcompiler.RegexToken;

public abstract class RegexOperator
implements RegexToken {
    private final OperatorType operatorType;
    private final int index;

    @Override
    public RegexToken.TokenType getTokenType() {
        return RegexToken.TokenType.OPERATOR;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public boolean getIsBinaryOperator() {
        return this.operatorType.getIsBinaryOperator();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public RegexOperator(OperatorType operatorType, int index) {
        this.operatorType = operatorType;
        this.index = index;
    }

    public String toString() {
        return this.operatorType.toString();
    }

    public static class RegexJoinOperator
    extends RegexOperator {
        public RegexJoinOperator(int index) {
            super(OperatorType.JOIN, index);
        }
    }

    public static class RegexUnionOperator
    extends RegexOperator {
        public RegexUnionOperator(int index) {
            super(OperatorType.UNION, index);
        }
    }

    public static enum OperatorType {
        STAR("*", false),
        PLUS("+", false),
        COUNT_CLOSURE("{...}", false),
        QUESTION_MARK("?", false),
        UNION("|", true),
        JOIN("\u25cb", true);

        private final String symbol;
        private final boolean isBinaryOperator;

        public boolean getIsBinaryOperator() {
            return this.isBinaryOperator;
        }

        private OperatorType(String symbol, boolean isBinaryOperator) {
            this.symbol = symbol;
            this.isBinaryOperator = isBinaryOperator;
        }

        public String toString() {
            return this.symbol;
        }
    }
}

