/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import analysis.AnalysisResults;
import analysis.AnalysisSettings;
import analysis.EdaAnalysisResults;
import analysis.ExploitString;
import analysis.ExploitStringBuilder;
import analysis.IdaAnalysisResults;
import analysis.NFAAnalyserInterface;
import analysis.NFAAnalysisTools;
import analysis.NoAnalysisFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;
import nfa.UPNFAState;
import nfa.transitionlabel.CharacterClassTransitionLabel;
import nfa.transitionlabel.EpsilonTransitionLabel;
import nfa.transitionlabel.TransitionLabel;

public abstract class NFAAnalyser
implements NFAAnalyserInterface {
    private final int MAX_IDA_DEGREE = Integer.MAX_VALUE;
    private final int MAX_CACHE_SIZE = 5;
    protected final ExploitStringBuilder exploitStringBuilder;
    protected final AnalysisSettings.PriorityRemovalStrategy priorityRemovalStrategy;
    protected Map<NFAGraph, EdaAnalysisResults> edaResultsCache = new HashMap<NFAGraph, EdaAnalysisResults>();
    protected Map<NFAGraph, IdaAnalysisResults> idaResultsCache = new HashMap<NFAGraph, IdaAnalysisResults>();

    public NFAAnalyser(AnalysisSettings.PriorityRemovalStrategy priorityRemovalStrategy) {
        this.exploitStringBuilder = new ExploitStringBuilder();
        this.priorityRemovalStrategy = priorityRemovalStrategy;
    }

    protected abstract EdaAnalysisResults calculateEdaAnalysisResults(NFAGraph var1) throws InterruptedException;

    protected abstract EdaAnalysisResults calculateEdaUnprioritisedAnalysisResults(NFAGraph var1) throws InterruptedException;

    protected abstract IdaAnalysisResults calculateIdaAnalysisResults(NFAGraph var1) throws InterruptedException;

    protected abstract IdaAnalysisResults calculateIdaUnprioritisedAnalysisResults(NFAGraph var1) throws InterruptedException;

    @Override
    public NFAAnalyserInterface.AnalysisResultsType containsIDA(NFAGraph originalM) {
        try {
            IdaAnalysisResults resultsObject = (IdaAnalysisResults)this.searchIdaCache(originalM);
            switch (resultsObject.idaCase) {
                case IDA: {
                    return NFAAnalyserInterface.AnalysisResultsType.IDA;
                }
                case NO_IDA: {
                    return NFAAnalyserInterface.AnalysisResultsType.NO_IDA;
                }
            }
            throw new RuntimeException("Unexpected IDA analysis result: " + (Object)((Object)resultsObject.idaCase));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return NFAAnalyserInterface.AnalysisResultsType.TIMEOUT_IN_IDA;
        }
    }

    @Override
    public IdaAnalysisResults getIdaAnalysisResults(NFAGraph m) {
        if (this.idaResultsCache.containsKey((Object)m)) {
            return this.idaResultsCache.get((Object)m);
        }
        throw new IllegalStateException("No IDA Analysis results found!");
    }

    @Override
    public NFAAnalyserInterface.AnalysisResultsType containsEDA(NFAGraph originalM) {
        try {
            EdaAnalysisResults resultsObject = (EdaAnalysisResults)this.searchEdaCache(originalM);
            switch (resultsObject.edaCase) {
                case ESCC: 
                case FILTER: 
                case PARALLEL: {
                    return NFAAnalyserInterface.AnalysisResultsType.EDA;
                }
                case NO_EDA: {
                    return NFAAnalyserInterface.AnalysisResultsType.NO_EDA;
                }
            }
            throw new RuntimeException("Unexpected EDA analysis result: " + (Object)((Object)resultsObject.edaCase));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return NFAAnalyserInterface.AnalysisResultsType.TIMEOUT_IN_EDA;
        }
    }

    @Override
    public EdaAnalysisResults getEdaAnalysisResults(NFAGraph m) {
        if (this.edaResultsCache.containsKey((Object)m)) {
            return this.edaResultsCache.get((Object)m);
        }
        throw new IllegalStateException("No EDA Analysis results found!");
    }

    protected AnalysisResults searchEdaCache(NFAGraph originalM) throws InterruptedException {
        EdaAnalysisResults resultsObject;
        if (!this.edaResultsCache.containsKey((Object)originalM)) {
            resultsObject = this.calculateEdaAnalysisResults(originalM);
            if (resultsObject.edaCase != EdaAnalysisResults.EdaCases.NO_EDA) {
                switch (this.priorityRemovalStrategy) {
                    case IGNORE: {
                        break;
                    }
                    case UNPRIORITISE: {
                        resultsObject = this.calculateEdaUnprioritisedAnalysisResults(originalM);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown priority strategy: " + (Object)((Object)this.priorityRemovalStrategy));
                    }
                }
            }
            if (this.edaResultsCache.size() >= 5) {
                this.edaResultsCache.clear();
            }
            this.edaResultsCache.put(originalM, resultsObject);
        } else {
            resultsObject = this.edaResultsCache.get((Object)originalM);
        }
        return resultsObject;
    }

    protected AnalysisResults searchIdaCache(NFAGraph originalM) throws InterruptedException {
        IdaAnalysisResults resultsObject;
        if (!this.edaResultsCache.containsKey((Object)originalM)) {
            throw new IllegalStateException("An NFA must first be checked for EDA, before it can be checked for IDA.");
        }
        EdaAnalysisResults edaResultsObject = this.edaResultsCache.get((Object)originalM);
        if (edaResultsObject.edaCase == EdaAnalysisResults.EdaCases.NO_EDA) {
            if (!this.idaResultsCache.containsKey((Object)originalM)) {
                NFAAnalyserInterface.EdaAnalysisResultsNoEda noEdaResults = (NFAAnalyserInterface.EdaAnalysisResultsNoEda)edaResultsObject;
                AnalysisSettings.PriorityRemovalStrategy noEdaPriorityRemovalStrategy = noEdaResults.getPriorityRemovalStrategy();
                switch (noEdaPriorityRemovalStrategy) {
                    case IGNORE: {
                        resultsObject = this.calculateIdaAnalysisResults(originalM);
                        if (resultsObject.idaCase == IdaAnalysisResults.IdaCases.NO_IDA || this.priorityRemovalStrategy != AnalysisSettings.PriorityRemovalStrategy.UNPRIORITISE) break;
                        resultsObject = this.calculateIdaUnprioritisedAnalysisResults(originalM);
                        break;
                    }
                    case UNPRIORITISE: {
                        resultsObject = this.calculateIdaUnprioritisedAnalysisResults(originalM);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown priority strategy: " + (Object)((Object)noEdaPriorityRemovalStrategy));
                    }
                }
                if (this.idaResultsCache.size() >= 5) {
                    this.idaResultsCache.clear();
                }
                this.idaResultsCache.put(originalM, resultsObject);
            } else {
                resultsObject = this.idaResultsCache.get((Object)originalM);
            }
        } else {
            throw new IllegalArgumentException("NFA contains EDA and cannot be tested for IDA.");
        }
        return resultsObject;
    }

    @Override
    public ExploitString findEDAExploitString(NFAGraph originalM) throws InterruptedException {
        if (this.edaResultsCache.containsKey((Object)originalM)) {
            EdaAnalysisResults resultsObject = this.edaResultsCache.get((Object)originalM);
            return this.exploitStringBuilder.buildEdaExploitString(resultsObject);
        }
        throw new NoAnalysisFoundException();
    }

    @Override
    public ExploitString findIDAExploitString(NFAGraph originalM) throws InterruptedException {
        if (this.idaResultsCache.containsKey((Object)originalM)) {
            IdaAnalysisResults resultsObject = this.idaResultsCache.get((Object)originalM);
            return this.exploitStringBuilder.buildIdaExploitString(resultsObject);
        }
        throw new NoAnalysisFoundException();
    }

    protected EdaAnalysisResults edaTestCaseParallel(NFAGraph originalM, LinkedList<NFAGraph> sccsInFlat) throws InterruptedException {
        for (NFAGraph currentSccInFlat : sccsInFlat) {
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            for (NFAEdge e : currentSccInFlat.edgeSet()) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                if (e.getNumParallel() <= 1) continue;
                NFAVertexND sourceVertex = e.getSourceVertex();
                NFAAnalyserInterface.EdaAnalysisResultsParallel resultsObject = new NFAAnalyserInterface.EdaAnalysisResultsParallel(originalM, currentSccInFlat, sourceVertex, e);
                return resultsObject;
            }
            for (NFAVertexND sourceVertex : currentSccInFlat.vertexSet()) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                HashSet<NFAVertexND> epsilonAdjacentVertices = new HashSet<NFAVertexND>();
                HashSet outgoingEpsilonEdges = (HashSet)currentSccInFlat.outgoingEpsilonEdgesOf(sourceVertex);
                for (NFAEdge e : outgoingEpsilonEdges) {
                    if (this.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    NFAVertexND targetVertex = e.getTargetVertex();
                    if (epsilonAdjacentVertices.contains(targetVertex)) {
                        NFAAnalyserInterface.EdaAnalysisResultsParallel resultsObject = new NFAAnalyserInterface.EdaAnalysisResultsParallel(originalM, currentSccInFlat, sourceVertex, e);
                        return resultsObject;
                    }
                    epsilonAdjacentVertices.add(targetVertex);
                }
            }
        }
        return new NFAAnalyserInterface.EdaAnalysisResultsNoEda(originalM);
    }

    protected EdaAnalysisResults edaTestCaseFilter(NFAGraph originalM, NFAGraph merged) throws InterruptedException {
        NFAGraph pc = NFAAnalysisTools.productConstructionAFA(merged);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        LinkedList<NFAGraph> pcSCCs = NFAAnalysisTools.getStronglyConnectedComponents(pc);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        for (NFAGraph pcSCC : pcSCCs) {
            for (NFAVertexND pfp : pcSCC.vertexSet()) {
                String p2;
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                String p1 = pfp.getStateNumberByDimension(1);
                if (!p1.equals(p2 = pfp.getStateNumberByDimension(3))) continue;
                for (NFAVertexND qfq : pcSCC.vertexSet()) {
                    String q2;
                    if (this.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    String q1 = qfq.getStateNumberByDimension(1);
                    if (q1.equals(q2 = qfq.getStateNumberByDimension(3))) continue;
                    NFAAnalyserInterface.EdaAnalysisResultsFilter resultsObject = new NFAAnalyserInterface.EdaAnalysisResultsFilter(originalM, pcSCC, pfp, qfq);
                    return resultsObject;
                }
            }
        }
        return new NFAAnalyserInterface.EdaAnalysisResultsNoEda(originalM);
    }

    protected IdaAnalysisResults idaTestCaseFilter(NFAGraph originalM, NFAGraph flat) throws InterruptedException {
        NFAGraph pc = NFAAnalysisTools.productConstructionAFAFA(flat);
        String[] filterStates = new String[]{"0", "1", "2"};
        NFAGraph pcWithBackEdges = pc.copy();
        for (NFAVertexND sourcePCV : pc.vertexSet()) {
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            String p1 = sourcePCV.getStateNumberByDimension(1);
            String p2 = sourcePCV.getStateNumberByDimension(3);
            String q = sourcePCV.getStateNumberByDimension(5);
            if (!p1.equals(p2) || p1.equals(q)) continue;
            for (String string : filterStates) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                for (String f2 : filterStates) {
                    if (this.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    NFAVertexND targetPCV = new NFAVertexND(p1, string, q, f2, q);
                    if (!pc.containsVertex(targetPCV)) continue;
                    NFAEdge newSpecialEdge = new NFAEdge(targetPCV, sourcePCV, new IdaSpecialTransitionLabel(null));
                    pcWithBackEdges.addEdge(newSpecialEdge);
                }
            }
        }
        boolean containsIda = false;
        LinkedList<NFAGraph> sccs = NFAAnalysisTools.getStronglyConnectedComponents(pcWithBackEdges);
        LinkedList<NFAVertexND> storedPs = new LinkedList<NFAVertexND>();
        LinkedList<NFAVertexND> storedQs = new LinkedList<NFAVertexND>();
        LinkedList storedSymbols = new LinkedList();
        for (NFAGraph scc : sccs) {
            TransitionLabel tl;
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            boolean containsSymbolTransition = false;
            for (NFAEdge e : scc.edgeSet()) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                tl = e.getTransitionLabel();
                if (tl.getTransitionType() != TransitionLabel.TransitionType.SYMBOL) continue;
                containsSymbolTransition = true;
                break;
            }
            if (!containsSymbolTransition) continue;
            for (NFAEdge e : scc.edgeSet()) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                tl = e.getTransitionLabel();
                if (tl.getTransitionType() != TransitionLabel.TransitionType.OTHER || !(tl instanceof IdaSpecialTransitionLabel)) continue;
                NFAVertexND eSource = e.getSourceVertex();
                NFAVertexND p = eSource.getStateByDimension(1);
                NFAVertexND q = eSource.getStateByDimension(5);
                LinkedList<NFAEdge> pqPath = NFAAnalysisTools.shortestPathBetween(flat, p, q);
                LinkedList<TransitionLabel> pqPathTransitionLabels = new LinkedList<TransitionLabel>();
                for (NFAEdge e2 : pqPath) {
                    TransitionLabel currentTransitionLabel = e2.getTransitionLabel();
                    if (currentTransitionLabel.getTransitionType() == TransitionLabel.TransitionType.EPSILON) continue;
                    pqPathTransitionLabels.add(currentTransitionLabel);
                }
                storedPs.add(p);
                storedQs.add(q);
                storedSymbols.add(pqPathTransitionLabels);
                containsIda = true;
            }
        }
        if (containsIda) {
            NFAGraph degreeGraph = originalM.copy();
            Iterator i0 = storedPs.iterator();
            Iterator i1 = storedQs.iterator();
            Iterator iterator = storedSymbols.iterator();
            while (i0.hasNext()) {
                NFAVertexND p = (NFAVertexND)i0.next();
                NFAVertexND q = (NFAVertexND)i1.next();
                LinkedList tls = (LinkedList)iterator.next();
                degreeGraph.addEdge(new NFAEdge(p, q, new IdaSpecialTransitionLabel(tls)));
            }
            NFAVertexND initialVertex = degreeGraph.getInitialState();
            LinkedList<NFAEdge> maxPath = new LinkedList<NFAEdge>();
            int d = this.calculateD(degreeGraph, initialVertex, maxPath);
            return new NFAAnalyserInterface.IdaAnalysisResultsIda(originalM, d, maxPath);
        }
        return new NFAAnalyserInterface.IdaAnalysisResultsNoIda(originalM);
    }

    private int calculateD(NFAGraph originalM, NFAVertexND initialState, LinkedList<NFAEdge> maxPath) throws InterruptedException {
        return this.calculateDDFS(originalM, initialState, 0, -1, new LinkedList<NFAEdge>(), maxPath, new HashSet<NFAEdge>());
    }

    private int calculateDDFS(NFAGraph m, NFAVertexND currentVertex, int currentD, int maxD, LinkedList<NFAEdge> currentPath, LinkedList<NFAEdge> maxPath, HashSet<NFAEdge> traversed) throws InterruptedException {
        int newMax;
        for (NFAEdge currentE : m.outgoingEdgesOf(currentVertex)) {
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            TransitionLabel tl = currentE.getTransitionLabel();
            if (traversed.contains(currentE)) continue;
            traversed.add(currentE);
            currentPath.add(currentE);
            maxD = tl instanceof IdaSpecialTransitionLabel ? this.calculateDDFS(m, currentE.getTargetVertex(), currentD + 1, maxD, currentPath, maxPath, traversed) : this.calculateDDFS(m, currentE.getTargetVertex(), currentD, maxD, currentPath, maxPath, traversed);
            currentPath.remove(currentE);
            traversed.remove(currentE);
        }
        if (currentD > maxD) {
            maxPath.clear();
            maxPath.addAll(currentPath);
            newMax = currentD;
        } else {
            newMax = maxD;
        }
        return newMax;
    }

    protected EdaAnalysisResults edaUnprioritisedAnalysis(NFAGraph m) throws InterruptedException {
        NFAGraph unprioritisedNFAGraph = this.createUnprioritisedNFAGraph(m);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        NFAGraph trimmedUPNFA = NFAAnalysisTools.makeTrimUPNFA(m, unprioritisedNFAGraph);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        HashMap<NFAVertexND, UPNFAState> statesMap = new HashMap<NFAVertexND, UPNFAState>();
        NFAGraph converted = NFAAnalysisTools.convertUpNFAToNFAGraph(trimmedUPNFA, statesMap);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        LinkedList<NFAGraph> sccsInFlat = NFAAnalysisTools.getStronglyConnectedComponents(converted);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        EdaAnalysisResults resultsObject = new NFAAnalyserInterface.EdaAnalysisResultsNoEda(m);
        resultsObject = this.edaTestCaseParallel(converted, sccsInFlat);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (resultsObject.edaCase == EdaAnalysisResults.EdaCases.NO_EDA) {
            resultsObject = this.edaTestCaseFilter(converted, converted);
        }
        resultsObject.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.UNPRIORITISE);
        return resultsObject;
    }

    protected IdaAnalysisResults idaUnprioritisedAnalysis(NFAGraph m) throws InterruptedException {
        NFAGraph unprioritisedNFAGraph = this.createUnprioritisedNFAGraph(m);
        NFAGraph trimmedUPNFA = NFAAnalysisTools.makeTrimUPNFA(m, unprioritisedNFAGraph);
        trimmedUPNFA = NFAAnalysisTools.makeTrim(trimmedUPNFA);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        HashMap<NFAVertexND, UPNFAState> statesMap = new HashMap<NFAVertexND, UPNFAState>();
        NFAGraph converted = NFAAnalysisTools.convertUpNFAToNFAGraph(trimmedUPNFA, statesMap);
        IdaAnalysisResults resultsObject = new NFAAnalyserInterface.IdaAnalysisResultsNoIda(m);
        resultsObject = this.idaTestCaseFilter(converted, converted);
        resultsObject.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.UNPRIORITISE);
        return resultsObject;
    }

    protected NFAGraph createUnprioritisedNFAGraph(NFAGraph m) throws InterruptedException {
        NFAGraph resultUPNFA = new NFAGraph();
        int i = 0;
        NFAVertexND newNFAInitialState = new NFAVertexND("q" + i);
        while (m.containsVertex(newNFAInitialState)) {
            newNFAInitialState = new NFAVertexND("q" + i);
            ++i;
        }
        UPNFAState newInitialState = new UPNFAState(newNFAInitialState.getStates(), new HashSet<NFAVertexND>());
        resultUPNFA.addVertex(newInitialState);
        resultUPNFA.setInitialState(newInitialState);
        NFAVertexND mInitialState = m.getInitialState();
        HashMap<NFAVertexND, TransitionLabel> stateToSymbolMap = new HashMap<NFAVertexND, TransitionLabel>();
        HashMap<NFAVertexND, Object> stateToEpsilonClosureMap = new HashMap<NFAVertexND, Object>();
        for (NFAEdge e : m.edgeSet()) {
            if (e.getTransitionType() != TransitionLabel.TransitionType.SYMBOL) continue;
            NFAVertexND sourceState = e.getSourceVertex();
            NFAVertexND targetState = e.getTargetVertex();
            TransitionLabel symbol = e.getTransitionLabel();
            LinkedList epsilonClosure = (LinkedList)this.priorityBasedEpsilonClosureDFS(m, targetState);
            stateToSymbolMap.put(sourceState, symbol);
            stateToEpsilonClosureMap.put(sourceState, epsilonClosure);
        }
        LinkedList<UPNFAState> toVisit = new LinkedList<UPNFAState>();
        HashSet<UPNFAState> visited = new HashSet<UPNFAState>();
        LinkedList reachableFromStart = (LinkedList)this.priorityBasedEpsilonClosureDFS(m, mInitialState);
        LinkedList startStatesList = (LinkedList)this.constructUPStates(reachableFromStart);
        int priorityCounter = 1;
        for (UPNFAState state : startStatesList) {
            if (!resultUPNFA.containsVertex(state)) {
                resultUPNFA.addVertex(state);
                if (m.isAcceptingState(new NFAVertexND(state.getStates()))) {
                    resultUPNFA.addAcceptingState(state);
                }
                if (!visited.contains(state)) {
                    toVisit.add(state);
                }
            }
            NFAEdge newEdge = new NFAEdge((NFAVertexND)newInitialState, (NFAVertexND)state, new EpsilonTransitionLabel("\u03b5" + priorityCounter));
            resultUPNFA.addEdge(newEdge);
            ++priorityCounter;
        }
        while (!toVisit.isEmpty()) {
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            UPNFAState currentState = (UPNFAState)toVisit.removeFirst();
            ArrayList<String> q = currentState.getStates();
            Set<NFAVertexND> P = currentState.getP();
            Set outgoingEdges = m.outgoingEdgesOf(new NFAVertexND(q));
            if (outgoingEdges.isEmpty()) continue;
            NFAEdge edge = (NFAEdge)outgoingEdges.iterator().next();
            if (edge.getIsEpsilonTransition()) {
                LinkedList sortedEdges = new LinkedList(outgoingEdges);
                Collections.sort(sortedEdges);
                HashSet<NFAVertexND> s = new HashSet<NFAVertexND>();
                for (NFAEdge currentEdge : sortedEdges) {
                    if (this.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    NFAVertexND targetVertex = currentEdge.getTargetVertex();
                    HashSet<NFAVertexND> newP = new HashSet<NFAVertexND>(P);
                    newP.addAll(s);
                    UPNFAState newUpNfaState = new UPNFAState(targetVertex.getStates(), (Set<NFAVertexND>)newP);
                    if (!resultUPNFA.containsVertex(newUpNfaState)) {
                        resultUPNFA.addVertex(newUpNfaState);
                        if (m.isAcceptingState(new NFAVertexND(targetVertex))) {
                            resultUPNFA.addAcceptingState(newUpNfaState);
                        }
                        if (!visited.contains(newUpNfaState)) {
                            toVisit.add(newUpNfaState);
                            visited.add(newUpNfaState);
                        }
                    }
                    NFAEdge newEdge = new NFAEdge((NFAVertexND)currentState, (NFAVertexND)newUpNfaState, currentEdge.getTransitionLabel());
                    resultUPNFA.addEdge(newEdge);
                    s.add(targetVertex);
                }
                continue;
            }
            NFAVertexND targetVertex = edge.getTargetVertex();
            CharacterClassTransitionLabel symbolTransition = (CharacterClassTransitionLabel)edge.getTransitionLabel();
            CharacterClassTransitionLabel remainingSymbols = (CharacterClassTransitionLabel)symbolTransition.copy();
            HashMap<TransitionLabel, UPNFAState> newTransitionLabelToStateMap = new HashMap<TransitionLabel, UPNFAState>();
            HashMap<Object, Object> labelToReachableStatesMap = new HashMap<Object, Object>();
            for (NFAVertexND p : P) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                if (!stateToSymbolMap.containsKey(p)) continue;
                TransitionLabel pSymbolTransition = (TransitionLabel)stateToSymbolMap.get(p);
                LinkedList epsilonClosure = new LinkedList((Collection)stateToEpsilonClosureMap.get(p));
                if (labelToReachableStatesMap.containsKey(pSymbolTransition)) {
                    LinkedList reachableStates = (LinkedList)labelToReachableStatesMap.get(pSymbolTransition);
                    for (NFAVertexND epsilonClosureState : epsilonClosure) {
                        if (this.isInterrupted()) {
                            throw new InterruptedException();
                        }
                        reachableStates.add(epsilonClosureState);
                    }
                    continue;
                }
                TransitionLabel remainingPSymbols = pSymbolTransition.copy();
                LinkedList<TransitionLabel> transitionLabelsToRemove = new LinkedList<TransitionLabel>();
                LinkedList<TransitionLabel> transitionLabelsToAdd = new LinkedList<TransitionLabel>();
                LinkedList statesToAdd = new LinkedList();
                for (Map.Entry kv : labelToReachableStatesMap.entrySet()) {
                    TransitionLabel tl3;
                    TransitionLabel currentTransitionLabel = (TransitionLabel)kv.getKey();
                    LinkedList currentReachableStates = (LinkedList)kv.getValue();
                    if (remainingPSymbols.intersection(currentTransitionLabel).isEmpty()) continue;
                    transitionLabelsToRemove.add(currentTransitionLabel);
                    TransitionLabel tl1 = currentTransitionLabel.intersection(remainingPSymbols.complement());
                    if (!tl1.isEmpty()) {
                        transitionLabelsToAdd.add(tl1);
                        statesToAdd.add(currentReachableStates);
                    }
                    TransitionLabel intersection = remainingPSymbols.intersection(currentTransitionLabel);
                    LinkedList reachableStatesUnion = new LinkedList(epsilonClosure);
                    reachableStatesUnion.addAll(currentReachableStates);
                    transitionLabelsToAdd.add(intersection);
                    statesToAdd.add(reachableStatesUnion);
                    remainingPSymbols = tl3 = remainingPSymbols.intersection(currentTransitionLabel.complement());
                    if (!tl3.isEmpty()) continue;
                    break;
                }
                for (TransitionLabel tl : transitionLabelsToRemove) {
                    labelToReachableStatesMap.remove(tl);
                }
                Iterator i0 = transitionLabelsToAdd.iterator();
                Iterator i1 = statesToAdd.iterator();
                while (i0.hasNext()) {
                    labelToReachableStatesMap.put(i0.next(), i1.next());
                }
                if (remainingPSymbols.isEmpty()) continue;
                labelToReachableStatesMap.put(remainingPSymbols, epsilonClosure);
            }
            for (Map.Entry kv : labelToReachableStatesMap.entrySet()) {
                UPNFAState newState;
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                TransitionLabel currentTransitionLabel = (TransitionLabel)kv.getKey();
                LinkedList currentReachableStates = (LinkedList)kv.getValue();
                if (currentTransitionLabel.intersection(remainingSymbols).isEmpty()) continue;
                TransitionLabel newTransitionLabel = currentTransitionLabel.intersection(symbolTransition);
                HashSet<NFAVertexND> newP = new HashSet<NFAVertexND>(currentReachableStates);
                if (newTransitionLabelToStateMap.containsKey(newTransitionLabel)) {
                    newState = (UPNFAState)newTransitionLabelToStateMap.get(newTransitionLabel);
                    newState.getP().addAll(newP);
                } else {
                    newState = new UPNFAState(targetVertex.getStates(), newP);
                    newTransitionLabelToStateMap.put(newTransitionLabel, newState);
                }
                remainingSymbols = (CharacterClassTransitionLabel)remainingSymbols.intersection(newTransitionLabel.complement());
            }
            if (!remainingSymbols.isEmpty()) {
                HashSet<NFAVertexND> emptySet = new HashSet<NFAVertexND>();
                UPNFAState newState = new UPNFAState(targetVertex.getStates(), emptySet);
                newTransitionLabelToStateMap.put(remainingSymbols, newState);
            }
            for (Map.Entry kv : newTransitionLabelToStateMap.entrySet()) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                UPNFAState targetState = (UPNFAState)kv.getValue();
                TransitionLabel tl = (TransitionLabel)kv.getKey();
                if (!resultUPNFA.containsVertex(targetState)) {
                    resultUPNFA.addVertex(targetState);
                    if (m.isAcceptingState(new NFAVertexND(targetVertex))) {
                        resultUPNFA.addAcceptingState(targetState);
                    }
                }
                NFAEdge newEdge = new NFAEdge((NFAVertexND)currentState, (NFAVertexND)targetState, tl);
                resultUPNFA.addEdge(newEdge);
                if (visited.contains(targetState)) continue;
                toVisit.add(targetState);
                visited.add(targetState);
            }
        }
        return resultUPNFA;
    }

    protected boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    private List<NFAVertexND> priorityBasedEpsilonClosureDFS(NFAGraph m, NFAVertexND startState) {
        LinkedList<NFAVertexND> terminalStates = new LinkedList<NFAVertexND>();
        Stack<NFAVertexND> toVisit = new Stack<NFAVertexND>();
        toVisit.push(startState);
        while (!toVisit.isEmpty()) {
            NFAVertexND currentState = (NFAVertexND)toVisit.pop();
            LinkedList outgoingTransitions = new LinkedList(m.outgoingEdgesOf(currentState));
            if (!outgoingTransitions.isEmpty()) {
                NFAEdge edge = (NFAEdge)outgoingTransitions.iterator().next();
                NFAVertexND targetState = edge.getTargetVertex();
                if (edge.getIsEpsilonTransition()) {
                    Collections.sort(outgoingTransitions, Collections.reverseOrder());
                    for (NFAEdge e : outgoingTransitions) {
                        targetState = e.getTargetVertex();
                        toVisit.push(targetState);
                    }
                    continue;
                }
                if (edge.getTransitionType() != TransitionLabel.TransitionType.SYMBOL) continue;
                terminalStates.add(currentState);
                continue;
            }
            if (!m.isAcceptingState(currentState)) continue;
            terminalStates.add(currentState);
        }
        return terminalStates;
    }

    private List<UPNFAState> constructUPStates(List<NFAVertexND> stateList) {
        HashSet<NFAVertexND> currentP = new HashSet<NFAVertexND>();
        LinkedList<UPNFAState> unprioritisedStatesList = new LinkedList<UPNFAState>();
        for (NFAVertexND q : stateList) {
            UPNFAState newUnprioritisedState = new UPNFAState(q.getStates(), currentP);
            unprioritisedStatesList.add(newUnprioritisedState);
            if (currentP.contains(q)) continue;
            currentP.add(q);
        }
        return unprioritisedStatesList;
    }

    public static class IdaSpecialTransitionLabel
    implements TransitionLabel {
        private final LinkedList<TransitionLabel> transitionLabels;

        @Override
        public boolean matches(String word) {
            return false;
        }

        @Override
        public boolean matches(TransitionLabel tl) {
            return false;
        }

        @Override
        public TransitionLabel intersection(TransitionLabel tl) {
            throw new UnsupportedOperationException("The intersection operation is invalid for special transitions.");
        }

        @Override
        public TransitionLabel union(TransitionLabel tl) {
            throw new UnsupportedOperationException("The union operation is invalid for special transitions.");
        }

        @Override
        public TransitionLabel complement() {
            throw new UnsupportedOperationException("The complement operation is invalid for special transitions.");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public String getSymbol() {
            throw new UnsupportedOperationException("Special transitions contain multiple symbols");
        }

        public String toString() {
            return "#(" + this.transitionLabels + ")";
        }

        @Override
        public TransitionLabel copy() {
            return new IdaSpecialTransitionLabel(this.transitionLabels);
        }

        @Override
        public TransitionLabel.TransitionType getTransitionType() {
            return TransitionLabel.TransitionType.OTHER;
        }

        public LinkedList<TransitionLabel> getTransitionLabels() {
            return this.transitionLabels;
        }

        public IdaSpecialTransitionLabel(LinkedList<TransitionLabel> transitionLabels) {
            this.transitionLabels = transitionLabels;
        }
    }
}

