/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import analysis.AnalysisSettings;
import analysis.EdaAnalysisResults;
import analysis.IdaAnalysisResults;
import analysis.NFAAnalyser;
import analysis.NFAAnalyserInterface;
import analysis.NFAAnalysisTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;
import nfa.transitionlabel.EmptyTransitionLabelException;
import nfa.transitionlabel.EpsilonTransitionLabel;

public class NFAAnalyserFlattening
extends NFAAnalyser {
    public NFAAnalyserFlattening(AnalysisSettings.PriorityRemovalStrategy priorityRemovalStrategy) {
        super(priorityRemovalStrategy);
    }

    @Override
    protected EdaAnalysisResults calculateEdaAnalysisResults(NFAGraph originalM) throws InterruptedException {
        NFAGraph flatGraph = NFAAnalyserFlattening.flattenNFA(originalM);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        LinkedList<NFAGraph> sccsInFlat = NFAAnalysisTools.getStronglyConnectedComponents(flatGraph);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        EdaAnalysisResults toReturn = new NFAAnalyserInterface.EdaAnalysisResultsNoEda(originalM);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        toReturn = this.edaTestCaseParallel(originalM, sccsInFlat);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (toReturn.edaCase != EdaAnalysisResults.EdaCases.NO_EDA) {
            return toReturn;
        }
        toReturn = this.edaTestCaseFilter(originalM, flatGraph);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        return toReturn;
    }

    @Override
    protected EdaAnalysisResults calculateEdaUnprioritisedAnalysisResults(NFAGraph originalM) throws InterruptedException {
        NFAGraph flatGraph = NFAAnalyserFlattening.flattenNFA(originalM);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        EdaAnalysisResults toReturn = new NFAAnalyserInterface.EdaAnalysisResultsNoEda(originalM);
        toReturn = this.edaUnprioritisedAnalysis(flatGraph);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.UNPRIORITISE);
        return toReturn;
    }

    @Override
    protected IdaAnalysisResults calculateIdaAnalysisResults(NFAGraph originalM) throws InterruptedException {
        NFAGraph flatGraph = NFAAnalyserFlattening.flattenNFA(originalM);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        IdaAnalysisResults toReturn = new NFAAnalyserInterface.IdaAnalysisResultsNoIda(originalM);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        toReturn = this.idaTestCaseFilter(originalM, flatGraph);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        return toReturn;
    }

    @Override
    protected IdaAnalysisResults calculateIdaUnprioritisedAnalysisResults(NFAGraph originalM) throws InterruptedException {
        NFAGraph flatGraph = NFAAnalyserFlattening.flattenNFA(originalM);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        IdaAnalysisResults toReturn = new NFAAnalyserInterface.IdaAnalysisResultsNoIda(originalM);
        toReturn = this.idaUnprioritisedAnalysis(flatGraph);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.UNPRIORITISE);
        return toReturn;
    }

    public static NFAGraph flattenNFA2(NFAGraph m) throws InterruptedException {
        NFAGraph flatGraph = new NFAGraph();
        for (NFAVertexND v : m.vertexSet()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            flatGraph.addVertex(v);
        }
        flatGraph.setInitialState(m.getInitialState());
        for (NFAVertexND v : m.getAcceptingStates()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            flatGraph.addAcceptingState(v);
        }
        for (NFAEdge e : m.edgeSet()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (e.getIsEpsilonTransition()) continue;
            flatGraph.addEdge(e);
        }
        for (NFAVertexND source : m.vertexSet()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            HashMap<NFAVertexND, Integer> numWalksMap = NFAAnalyserFlattening.numWalksFrom(m, source);
            for (Map.Entry<NFAVertexND, Integer> kv : numWalksMap.entrySet()) {
                NFAEdge newEdge;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                NFAVertexND destination = kv.getKey();
                int weight = kv.getValue();
                if (weight <= 0) continue;
                try {
                    newEdge = new NFAEdge(source, destination, "\u03b50");
                }
                catch (EmptyTransitionLabelException e1) {
                    throw new RuntimeException("Empty transition label");
                }
                newEdge.setNumParallel(weight);
                flatGraph.addEdge(newEdge);
            }
        }
        return flatGraph;
    }

    public static NFAGraph flattenNFA(NFAGraph m) throws InterruptedException {
        NFAGraph flatGraph = new NFAGraph();
        NFAVertexND mInitialState = m.getInitialState();
        HashSet<NFAVertexND> searchFromVertices = new HashSet<NFAVertexND>();
        searchFromVertices.add(mInitialState);
        for (NFAEdge e : m.edgeSet()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (e.getIsEpsilonTransition()) continue;
            NFAVertexND sourceVertex = e.getSourceVertex();
            NFAVertexND targetVertex = e.getTargetVertex();
            if (!flatGraph.containsVertex(sourceVertex)) {
                flatGraph.addVertex(sourceVertex);
            }
            if (!flatGraph.containsVertex(targetVertex)) {
                flatGraph.addVertex(targetVertex);
            }
            flatGraph.addEdge(e);
            if (searchFromVertices.contains(targetVertex)) continue;
            searchFromVertices.add(targetVertex);
        }
        if (!flatGraph.containsVertex(mInitialState)) {
            flatGraph.addVertex(mInitialState);
        }
        flatGraph.setInitialState(mInitialState);
        for (NFAVertexND v : m.getAcceptingStates()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (!flatGraph.containsVertex(v)) {
                flatGraph.addVertex(v);
            }
            flatGraph.addAcceptingState(v);
        }
        for (NFAVertexND sourceState : searchFromVertices) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            LinkedList<NFAVertexND> reachableFromSource = NFAAnalyserFlattening.dfsFlatten(m, sourceState);
            int priorityCounter = 1;
            for (NFAVertexND targetState : reachableFromSource) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (sourceState.equals(targetState)) continue;
                NFAEdge newEdge = new NFAEdge(sourceState, targetState, new EpsilonTransitionLabel("\u03b5" + priorityCounter));
                flatGraph.addEdge(newEdge);
                ++priorityCounter;
            }
        }
        return flatGraph;
    }

    public static LinkedList<NFAVertexND> dfsFlatten(NFAGraph m, NFAVertexND startVertex) throws InterruptedException {
        LinkedList<NFAVertexND> endVertices = new LinkedList<NFAVertexND>();
        NFAAnalyserFlattening.dfsFlatten(m, startVertex, new HashSet<NFAEdge>(), endVertices);
        return endVertices;
    }

    private static void dfsFlatten(NFAGraph m, NFAVertexND currentVertex, HashSet<NFAEdge> visitedEdges, LinkedList<NFAVertexND> endVertices) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Set outgoingEdges = m.outgoingEdgesOf(currentVertex);
        if (!outgoingEdges.isEmpty()) {
            NFAEdge edge = (NFAEdge)outgoingEdges.iterator().next();
            if (edge.getIsEpsilonTransition()) {
                LinkedList sortedEdges = new LinkedList(outgoingEdges);
                Collections.sort(sortedEdges);
                for (NFAEdge e : sortedEdges) {
                    if (visitedEdges.contains(e)) continue;
                    visitedEdges.add(e);
                    NFAAnalyserFlattening.dfsFlatten(m, e.getTargetVertex(), visitedEdges, endVertices);
                    visitedEdges.remove(e);
                }
            } else {
                endVertices.add(currentVertex);
            }
        } else if (m.isAcceptingState(currentVertex)) {
            endVertices.add(currentVertex);
        }
    }

    public static HashMap<NFAVertexND, Integer> numWalksFrom(NFAGraph m, NFAVertexND s) {
        HashMap<NFAVertexND, Integer> paths = new HashMap<NFAVertexND, Integer>();
        for (NFAVertexND v : m.vertexSet()) {
            paths.put(v, 0);
        }
        HashMap<NFAEdge, Integer> visitedEdges = new HashMap<NFAEdge, Integer>();
        for (NFAEdge e : m.edgeSet()) {
            visitedEdges.put(e, 0);
        }
        NFAAnalyserFlattening.numWalksFromSearch(m, s, visitedEdges, paths);
        return paths;
    }

    static void numWalksFromSearch(NFAGraph m, NFAVertexND current, HashMap<NFAEdge, Integer> visitedEdges, HashMap<NFAVertexND, Integer> paths) {
        for (NFAEdge e : m.outgoingEdgesOf(current)) {
            if (!e.getIsEpsilonTransition()) continue;
            int currentNumVisit = visitedEdges.get(e);
            visitedEdges.put(e, currentNumVisit + 1);
            for (int i = currentNumVisit; i < e.getNumParallel(); ++i) {
                paths.put(e.getTargetVertex(), paths.get(e.getTargetVertex()) + 1);
                NFAAnalyserFlattening.numWalksFromSearch(m, e.getTargetVertex(), visitedEdges, paths);
            }
            visitedEdges.put(e, currentNumVisit);
        }
    }
}

