/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import nfa.FilterEdge;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;
import nfa.UPNFAState;
import nfa.transitionlabel.CharacterClassTransitionLabel;
import nfa.transitionlabel.EmptyTransitionLabelException;
import nfa.transitionlabel.TransitionLabel;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.KosarajuStrongConnectivityInspector;

public class NFAAnalysisTools {
    public static void prepareForFilter(NFAGraph m, String modifyLabel, String selfloopLabel) {
        for (NFAVertexND v : m.vertexSet()) {
            for (NFAEdge e : m.outgoingEdgesOf(v)) {
                if (!e.getIsEpsilonTransition()) continue;
                e.setTransitionLabel(modifyLabel);
            }
            try {
                m.addEdge(new NFAEdge(v, v, selfloopLabel));
            }
            catch (EmptyTransitionLabelException e1) {
                throw new RuntimeException("Empty transition label");
            }
        }
    }

    public static NFAGraph createFilter() {
        NFAGraph mohriFilter = new NFAGraph();
        NFAVertexND v0 = new NFAVertexND(0);
        NFAVertexND v1 = new NFAVertexND(1);
        NFAVertexND v2 = new NFAVertexND(2);
        mohriFilter.addVertex(v0);
        mohriFilter.addVertex(v1);
        mohriFilter.addVertex(v2);
        try {
            mohriFilter.addEdge(new FilterEdge(v0, v0, "\u03b52", "\u03b51"));
            mohriFilter.addEdge(new FilterEdge(v0, v0, "x", "x"));
            mohriFilter.addEdge(new FilterEdge(v0, v1, "\u03b51", "\u03b51"));
            mohriFilter.addEdge(new FilterEdge(v0, v2, "\u03b52", "\u03b52"));
            mohriFilter.addEdge(new FilterEdge(v1, v1, "\u03b51", "\u03b51"));
            mohriFilter.addEdge(new FilterEdge(v1, v0, "x", "x"));
            mohriFilter.addEdge(new FilterEdge(v2, v2, "\u03b52", "\u03b52"));
            mohriFilter.addEdge(new FilterEdge(v2, v0, "x", "x"));
        }
        catch (EmptyTransitionLabelException e1) {
            throw new RuntimeException("Empty transition label");
        }
        mohriFilter.setInitialState(v0);
        mohriFilter.addAcceptingState(v0);
        mohriFilter.addAcceptingState(v1);
        mohriFilter.addAcceptingState(v2);
        return mohriFilter;
    }

    public static NFAGraph productConstructionAFB(NFAGraph a, NFAGraph b) throws InterruptedException {
        NFAGraph m1 = a.copy();
        NFAGraph m2 = b.copy();
        NFAGraph f = NFAAnalysisTools.createFilter();
        NFAAnalysisTools.prepareForFilter(m1, "\u03b52", "\u03b51");
        NFAAnalysisTools.prepareForFilter(m2, "\u03b51", "\u03b52");
        HashMap<NFAEdge, TransitionLabel> originalWords = new HashMap<NFAEdge, TransitionLabel>();
        NFAGraph af = NFAAnalysisTools.productConstruction(m1, f, originalWords);
        return NFAAnalysisTools.productConstruction(af, m2, originalWords);
    }

    public static NFAGraph productConstructionAFA(NFAGraph m) throws InterruptedException {
        return NFAAnalysisTools.productConstructionAFB(m, m);
    }

    public static NFAGraph productConstructionAFAFA(NFAGraph m) throws InterruptedException {
        NFAGraph m1 = m.copy();
        NFAGraph m2 = m.copy();
        NFAGraph f = NFAAnalysisTools.createFilter();
        NFAAnalysisTools.prepareForFilter(m1, "\u03b52", "\u03b51");
        NFAAnalysisTools.prepareForFilter(m2, "\u03b51", "\u03b52");
        HashMap<NFAEdge, TransitionLabel> originalWords = new HashMap<NFAEdge, TransitionLabel>();
        NFAGraph af = NFAAnalysisTools.productConstruction(m1, f, originalWords);
        NFAGraph afa = NFAAnalysisTools.productConstruction(af, m2, originalWords);
        NFAAnalysisTools.prepareForFilter(afa, "\u03b52", "\u03b51");
        NFAGraph afaf = NFAAnalysisTools.productConstruction(afa, f, originalWords);
        NFAGraph afafa = NFAAnalysisTools.productConstruction(afaf, m2, originalWords);
        return afafa;
    }

    public static NFAGraph productConstruction(NFAGraph m1, NFAGraph m2, HashMap<NFAEdge, TransitionLabel> originalWords) throws InterruptedException {
        NFAGraph productConstruction = new NFAGraph();
        NFAVertexND m1SourceState = m1.getInitialState();
        NFAVertexND m2SourceState = m2.getInitialState();
        int m1Dimensions = m1SourceState.getNumDimensions();
        int m2Dimensions = m2SourceState.getNumDimensions();
        NFAVertexND firstVertex = new NFAVertexND(m1SourceState, m2SourceState);
        LinkedList<NFAVertexND> toVisit = new LinkedList<NFAVertexND>();
        toVisit.add(firstVertex);
        productConstruction.addVertex(firstVertex);
        productConstruction.setInitialState(firstVertex);
        while (!toVisit.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            NFAVertexND sourceVertex = (NFAVertexND)toVisit.poll();
            m1SourceState = sourceVertex.getStateByDimensionRange(1, 1 + m1Dimensions);
            m2SourceState = sourceVertex.getStateByDimensionRange(1 + m1Dimensions, 1 + m1Dimensions + m2Dimensions);
            if (m1.isAcceptingState(m1SourceState) && m2.isAcceptingState(m2SourceState)) {
                productConstruction.addAcceptingState(sourceVertex);
            }
            for (NFAEdge currentM1Edge : m1.outgoingEdgesOf(m1SourceState)) {
                TransitionLabel word;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                int m1NumParallel = currentM1Edge.getNumParallel();
                NFAVertexND m1TargetState = currentM1Edge.getTargetVertex();
                TransitionLabel originalWord = word = currentM1Edge.getTransitionLabel();
                if (originalWords.containsKey(currentM1Edge)) {
                    originalWord = originalWords.get(currentM1Edge);
                }
                for (NFAEdge currentM2Edge : m2.outgoingEdgesOf(m2SourceState)) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    if (!currentM2Edge.isTransitionFor(word)) continue;
                    int m2NumParallel = currentM2Edge.getNumParallel();
                    NFAVertexND m2TargetState = currentM2Edge.getTargetVertex();
                    NFAVertexND targetVertex = new NFAVertexND(m1TargetState, m2TargetState);
                    if (!productConstruction.containsVertex(targetVertex)) {
                        toVisit.add(targetVertex);
                        productConstruction.addVertex(targetVertex);
                    }
                    NFAEdge newEdge = new NFAEdge(sourceVertex, targetVertex, originalWord);
                    if (NFAAnalysisTools.isFilterEdge(currentM2Edge)) {
                        FilterEdge fEdge = (FilterEdge)currentM2Edge;
                        if (fEdge.getIsEpsilonTransition()) {
                            newEdge.setTransitionLabel(fEdge.getOutGoingTransitionCharacter());
                            originalWords.put(newEdge, originalWord);
                        }
                    } else if (!currentM2Edge.getIsEpsilonTransition()) {
                        TransitionLabel tl2 = currentM2Edge.getTransitionLabel();
                        TransitionLabel intersection = originalWord.intersection(tl2);
                        newEdge.setTransitionLabel(intersection);
                    }
                    newEdge.setNumParallel(m1NumParallel * m2NumParallel);
                    productConstruction.addEdge(newEdge);
                }
            }
        }
        return productConstruction;
    }

    public static NFAGraph makeTrimFromStart(NFAGraph m) throws InterruptedException {
        NFAGraph trimmed = m.copy();
        NFAVertexND mInitialVertex = m.getInitialState();
        Set vSet = m.vertexSet();
        HashSet<NFAVertexND> usefulStates = new HashSet<NFAVertexND>();
        NFAAnalysisTools.makeTrimFromStartDFS(m, mInitialVertex, usefulStates);
        for (NFAVertexND currentVertex : vSet) {
            if (usefulStates.contains(currentVertex)) continue;
            trimmed.removeVertex(currentVertex);
        }
        return trimmed;
    }

    private static void makeTrimFromStartDFS(NFAGraph m, NFAVertexND currentVertex, HashSet<NFAVertexND> usefulStates) {
        usefulStates.add(currentVertex);
        for (NFAEdge e : m.outgoingEdgesOf(currentVertex)) {
            NFAVertexND target = e.getTargetVertex();
            if (usefulStates.contains(target)) continue;
            NFAAnalysisTools.makeTrimFromStartDFS(m, target, usefulStates);
        }
    }

    public static NFAGraph makeTrimAlternative(NFAGraph m) throws InterruptedException {
        NFAGraph trimmed = m.copy();
        Set vSet = m.vertexSet();
        LinkedList<NFAVertexND> toRemove = new LinkedList<NFAVertexND>();
        HashSet<NFAVertexND> usefulStates = new HashSet<NFAVertexND>();
        for (NFAVertexND acceptingState : m.getAcceptingStates()) {
            usefulStates.add(acceptingState);
        }
        for (NFAVertexND currentVertex : vSet) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (!NFAAnalysisTools.makeTrimIsUseful(trimmed, currentVertex, new HashSet<NFAVertexND>(), usefulStates)) {
                if (m.getInitialState().equals(currentVertex)) continue;
                toRemove.add(currentVertex);
                continue;
            }
            usefulStates.add(currentVertex);
        }
        for (NFAVertexND currentVertex : toRemove) {
            trimmed.removeVertex(currentVertex);
        }
        return trimmed;
    }

    static boolean makeTrimIsUseful(NFAGraph m, NFAVertexND currentVertex, HashSet<NFAVertexND> visited, HashSet<NFAVertexND> usefulStates) {
        if (usefulStates.contains(currentVertex)) {
            return true;
        }
        if (visited.contains(currentVertex)) {
            return false;
        }
        visited.add(currentVertex);
        boolean result = false;
        for (NFAEdge currentEdge : m.outgoingEdgesOf(currentVertex)) {
            if (!(result |= NFAAnalysisTools.makeTrimIsUseful(m, currentEdge.getTargetVertex(), visited, usefulStates))) continue;
            return true;
        }
        return result;
    }

    public static NFAGraph makeTrimUPNFA(NFAGraph m, NFAGraph upnfa) throws InterruptedException {
        HashSet<UPNFAState> usefulStates = new HashSet<UPNFAState>();
        for (NFAVertexND v : upnfa.vertexSet()) {
            UPNFAState upNFAState = (UPNFAState)v;
            if (!NFAAnalysisTools.upNFAStateIsUseful(m, upnfa, upNFAState)) continue;
            usefulStates.add(upNFAState);
        }
        NFAGraph trimmedUPNFA = upnfa.copy();
        for (NFAVertexND v : upnfa.vertexSet()) {
            if (usefulStates.contains(v)) continue;
            if (trimmedUPNFA.isAcceptingState(v)) {
                trimmedUPNFA.removeAcceptingState(v);
            }
            trimmedUPNFA.removeVertex(v);
        }
        return trimmedUPNFA;
    }

    public static boolean upNFAStateIsUseful(NFAGraph m, NFAGraph upnfa, UPNFAState upNFAState) throws InterruptedException {
        NFAVertexND p2;
        HashSet<TransitionLabel> alphabet = new HashSet<TransitionLabel>();
        alphabet.add(CharacterClassTransitionLabel.wildcardLabel());
        HashSet P = (HashSet)upNFAState.getP();
        TransitionLabel higherPrioritySymbols = new CharacterClassTransitionLabel();
        boolean containsAcceptState = false;
        for (NFAVertexND p2 : P) {
            if (m.isAcceptingState(p2)) {
                containsAcceptState = true;
            }
            Set outgoingEdges = m.outgoingEdgesOf(p2);
            for (NFAEdge e : outgoingEdges) {
                if (e.getIsEpsilonTransition()) continue;
                higherPrioritySymbols = higherPrioritySymbols.union(e.getTransitionLabel());
            }
        }
        if (!containsAcceptState || !higherPrioritySymbols.complement().isEmpty()) {
            return true;
        }
        Iterator i0 = P.iterator();
        p2 = (NFAVertexND)i0.next();
        HashSet<NFAVertexND> reachableFromStart = new HashSet<NFAVertexND>();
        reachableFromStart.addAll(P);
        NFAGraph intersectionDfa = NFAAnalysisTools.determinize(m, reachableFromStart, alphabet);
        intersectionDfa = NFAAnalysisTools.complementDfa(intersectionDfa);
        Stack<NFAVertexND> toVisit = new Stack<NFAVertexND>();
        HashSet<NFAVertexND> visited = new HashSet<NFAVertexND>();
        toVisit.push(intersectionDfa.getInitialState());
        while (!toVisit.isEmpty()) {
            NFAVertexND currentState = (NFAVertexND)toVisit.pop();
            if (intersectionDfa.isAcceptingState(currentState)) {
                return true;
            }
            Set outgoingEdges = intersectionDfa.outgoingEdgesOf(currentState);
            for (NFAEdge e : outgoingEdges) {
                NFAVertexND targetVertex = e.getTargetVertex();
                if (visited.contains(targetVertex)) continue;
                toVisit.push(targetVertex);
                visited.add(targetVertex);
            }
        }
        return false;
    }

    public static NFAGraph complementDfa(NFAGraph dfa) {
        NFAGraph resultGraph = dfa.copy();
        for (NFAVertexND currentState : dfa.vertexSet()) {
            if (dfa.isAcceptingState(currentState)) {
                resultGraph.removeAcceptingState(currentState);
                continue;
            }
            resultGraph.addAcceptingState(currentState);
        }
        return resultGraph;
    }

    public static NFAGraph makeTrim(NFAGraph m) throws InterruptedException {
        NFAGraph trimmed = m.copy();
        NFAGraph reversedGraph = m.reverse();
        HashSet<NFAVertexND> usefulStates = NFAAnalysisTools.makeTrimReachable(reversedGraph, reversedGraph.getAcceptingStates());
        for (NFAVertexND v : m.vertexSet()) {
            if (usefulStates.contains(v) || m.getInitialState().equals(v)) continue;
            trimmed.removeVertex(v);
        }
        return trimmed;
    }

    private static HashSet<NFAVertexND> makeTrimReachable(NFAGraph reversedGraph, Set<NFAVertexND> defaultUsefulStates) throws InterruptedException {
        HashSet<NFAVertexND> usefulStates = new HashSet<NFAVertexND>();
        LinkedList<NFAVertexND> toVisit = new LinkedList<NFAVertexND>();
        for (NFAVertexND defaultUsefulState : defaultUsefulStates) {
            toVisit.add(defaultUsefulState);
        }
        while (!toVisit.isEmpty()) {
            if (NFAAnalysisTools.isInterrupted()) {
                throw new InterruptedException();
            }
            NFAVertexND currentVertex = (NFAVertexND)toVisit.pop();
            usefulStates.add(currentVertex);
            for (NFAEdge outGoingEdge : reversedGraph.outgoingEdgesOf(currentVertex)) {
                NFAVertexND targetVertex = outGoingEdge.getTargetVertex();
                if (usefulStates.contains(targetVertex) || toVisit.contains(targetVertex)) continue;
                toVisit.push(targetVertex);
            }
        }
        return usefulStates;
    }

    public static NFAGraph convertUpNFAToNFAGraph(NFAGraph m, HashMap<NFAVertexND, UPNFAState> newStateMap) {
        HashMap<UPNFAState, NFAVertexND> stateMap = new HashMap<UPNFAState, NFAVertexND>();
        int stateCounter = 0;
        NFAGraph resultGraph = new NFAGraph();
        for (NFAVertexND v : m.vertexSet()) {
            NFAVertexND correspondingState = new NFAVertexND("q" + stateCounter);
            stateMap.put((UPNFAState)v, correspondingState);
            newStateMap.put(correspondingState, (UPNFAState)v);
            resultGraph.addVertex(correspondingState);
            if (m.isAcceptingState(v)) {
                resultGraph.addAcceptingState(correspondingState);
            }
            ++stateCounter;
        }
        resultGraph.setInitialState((NFAVertexND)stateMap.get(m.getInitialState()));
        for (NFAEdge e : m.edgeSet()) {
            UPNFAState sourceState = (UPNFAState)e.getSourceVertex();
            UPNFAState targetState = (UPNFAState)e.getTargetVertex();
            NFAVertexND newSource = (NFAVertexND)stateMap.get(sourceState);
            NFAVertexND newTarget = (NFAVertexND)stateMap.get(targetState);
            TransitionLabel transitionLabel = e.getTransitionLabel();
            NFAEdge newEdge = new NFAEdge(newSource, newTarget, transitionLabel);
            resultGraph.addEdge(newEdge);
        }
        return resultGraph;
    }

    public static LinkedList<NFAGraph> getStronglyConnectedComponents(NFAGraph m) throws InterruptedException {
        KosarajuStrongConnectivityInspector sci = new KosarajuStrongConnectivityInspector((Graph)m);
        List sccs = sci.getStronglyConnectedComponents();
        LinkedList<NFAGraph> sccNFAs = new LinkedList<NFAGraph>();
        for (Graph scc : sccs) {
            if (NFAAnalysisTools.isInterrupted()) {
                throw new InterruptedException();
            }
            if (scc.edgeSet().size() <= 0) continue;
            NFAGraph currentNFAG = new NFAGraph();
            for (NFAVertexND v : scc.vertexSet()) {
                if (NFAAnalysisTools.isInterrupted()) {
                    throw new InterruptedException();
                }
                currentNFAG.addVertex(v);
            }
            for (NFAEdge e : scc.edgeSet()) {
                if (NFAAnalysisTools.isInterrupted()) {
                    throw new InterruptedException();
                }
                currentNFAG.addEdge(e);
            }
            sccNFAs.add(currentNFAG);
        }
        return sccNFAs;
    }

    private static boolean isFilterEdge(NFAEdge e) {
        return FilterEdge.class.isAssignableFrom(e.getClass());
    }

    public static LinkedList<NFAGraph> getEpsilonStronglyConnectedComponents(NFAGraph m) throws InterruptedException {
        NFAGraph epsilonGraph = m.copy();
        for (NFAEdge e : m.edgeSet()) {
            if (e.getIsEpsilonTransition()) continue;
            epsilonGraph.removeEdge(e);
        }
        return NFAAnalysisTools.getStronglyConnectedComponents(epsilonGraph);
    }

    public static Map<NFAVertexND, NFAGraph> mergeStronglyConnectedComponents(NFAGraph m, boolean epsilon) throws InterruptedException {
        HashMap<NFAVertexND, NFAGraph> mergedStates = new HashMap<NFAVertexND, NFAGraph>();
        LinkedList<NFAGraph> sccs = epsilon ? NFAAnalysisTools.getEpsilonStronglyConnectedComponents(m) : NFAAnalysisTools.getStronglyConnectedComponents(m);
        for (NFAGraph scc : sccs) {
            NFAVertexND mergedState = null;
            boolean isAccepting = false;
            boolean isInitial = false;
            LinkedList<NFAEdge> edgesToRestore = new LinkedList<NFAEdge>();
            for (NFAVertexND v : scc.vertexSet()) {
                if (NFAAnalysisTools.isInterrupted()) {
                    throw new InterruptedException();
                }
                if (mergedState == null) {
                    mergedState = new NFAVertexND(v.getStateNumberByDimension(1));
                }
                if (m.isAcceptingState(v)) {
                    isAccepting = true;
                    m.removeAcceptingState(v);
                }
                if (m.getInitialState() != null && m.getInitialState().equals(v)) {
                    isInitial = true;
                }
                for (NFAEdge e : m.edgesOf(v)) {
                    if (scc.containsEdge(e)) continue;
                    NFAVertexND sourceVertex = scc.containsVertex(e.getSourceVertex()) ? mergedState : e.getSourceVertex();
                    NFAVertexND targetVertex = scc.containsVertex(e.getTargetVertex()) ? mergedState : e.getTargetVertex();
                    NFAEdge newEdge = new NFAEdge(sourceVertex, targetVertex, e.getTransitionLabel());
                    newEdge.setNumParallel(e.getNumParallel());
                    edgesToRestore.add(newEdge);
                }
                m.removeVertex(v);
            }
            m.addVertex(mergedState);
            if (isInitial) {
                m.setInitialState(mergedState);
            }
            if (isAccepting) {
                m.addAcceptingState(mergedState);
            }
            for (NFAEdge e : edgesToRestore) {
                m.addEdge(e);
            }
            mergedStates.put(mergedState, scc);
        }
        return mergedStates;
    }

    public static HashMap<NFAVertexND, Integer> numWalksFrom(NFAGraph m, NFAVertexND s) {
        HashMap<NFAVertexND, Integer> paths = new HashMap<NFAVertexND, Integer>();
        for (NFAVertexND v : m.vertexSet()) {
            paths.put(v, 0);
        }
        HashMap<NFAEdge, Integer> visitedEdges = new HashMap<NFAEdge, Integer>();
        for (NFAEdge e : m.edgeSet()) {
            visitedEdges.put(e, 0);
        }
        NFAAnalysisTools.numWalksFromSearch(m, s, visitedEdges, paths);
        return paths;
    }

    static void numWalksFromSearch(NFAGraph m, NFAVertexND current, HashMap<NFAEdge, Integer> visitedEdges, HashMap<NFAVertexND, Integer> paths) {
        paths.put(current, paths.get(current) + 1);
        for (NFAEdge e : m.outgoingEdgesOf(current)) {
            int currentNumVisit = visitedEdges.get(e);
            visitedEdges.put(e, currentNumVisit + 1);
            for (int i = currentNumVisit; i < e.getNumParallel(); ++i) {
                NFAAnalysisTools.numWalksFromSearch(m, e.getTargetVertex(), visitedEdges, paths);
            }
            visitedEdges.put(e, currentNumVisit);
        }
    }

    public static Set<TransitionLabel> getAlphabet(NFAGraph n) {
        HashSet<TransitionLabel> regexAlphabet = new HashSet<TransitionLabel>();
        for (NFAEdge e : n.edgeSet()) {
            CharacterClassTransitionLabel cctl;
            TransitionLabel tl;
            if (e.getIsEpsilonTransition() || !((tl = e.getTransitionLabel()) instanceof CharacterClassTransitionLabel) || regexAlphabet.contains(cctl = (CharacterClassTransitionLabel)tl)) continue;
            regexAlphabet.add(cctl);
        }
        return regexAlphabet;
    }

    public static LinkedList<NFAEdge> shortestPathTo(NFAGraph m, NFAVertexND finish) {
        return NFAAnalysisTools.shortestPathBetween(m, m.getInitialState(), finish);
    }

    public static LinkedList<NFAEdge> shortestPathBetween(NFAGraph m, NFAVertexND start, NFAVertexND finish) {
        HashMap pathToMap = new HashMap();
        HashSet<NFAEdge> traversed = new HashSet<NFAEdge>();
        LinkedList<NFAVertexND> queue = new LinkedList<NFAVertexND>();
        NFAVertexND firstVertex = start;
        LinkedList emptyPath = new LinkedList();
        queue.add(firstVertex);
        pathToMap.put(firstVertex, emptyPath);
        while (!queue.isEmpty()) {
            NFAVertexND currentVertex = (NFAVertexND)queue.removeLast();
            LinkedList currentPath = (LinkedList)pathToMap.get(currentVertex);
            if (currentVertex.equals(finish)) {
                return currentPath;
            }
            for (NFAEdge e : m.outgoingEdgesOf(currentVertex)) {
                if (traversed.contains(e)) continue;
                traversed.add(e);
                NFAVertexND target = e.getTargetVertex();
                LinkedList<NFAEdge> newPath = new LinkedList<NFAEdge>(currentPath);
                newPath.add(e);
                pathToMap.put(target, newPath);
                queue.addFirst(target);
            }
        }
        return null;
    }

    public static HashSet<NFAVertexND> reachableWithEpsilon(NFAGraph n, NFAVertexND v) {
        HashSet<NFAVertexND> visited = new HashSet<NFAVertexND>();
        LinkedList<NFAVertexND> toVisit = new LinkedList<NFAVertexND>();
        toVisit.add(v);
        while (!toVisit.isEmpty()) {
            NFAVertexND currentVertex = (NFAVertexND)toVisit.removeLast();
            visited.add(currentVertex);
            for (NFAEdge e : n.outgoingEdgesOf(currentVertex)) {
                NFAVertexND targetVertex;
                if (!e.getIsEpsilonTransition() || visited.contains(targetVertex = e.getTargetVertex())) continue;
                toVisit.add(targetVertex);
            }
        }
        return visited;
    }

    public static NFAGraph determinize(NFAGraph input, Set<NFAVertexND> reachableFromStart, Set<TransitionLabel> alphabet) throws InterruptedException {
        NFAGraph dfa = new NFAGraph();
        LinkedList<NFAVertexND> toVisit = new LinkedList<NFAVertexND>();
        LinkedList<NFAVertexND> sortedReachableFromStart = new LinkedList<NFAVertexND>(reachableFromStart);
        Collections.sort(sortedReachableFromStart);
        StringBuilder labelBuilder = new StringBuilder();
        Iterator i0 = sortedReachableFromStart.iterator();
        while (i0.hasNext()) {
            if (NFAAnalysisTools.isInterrupted()) {
                throw new InterruptedException();
            }
            NFAVertexND startState = (NFAVertexND)i0.next();
            ArrayList<String> subStates = startState.getStates();
            if (subStates.size() == 1) {
                String currentLabel = (String)subStates.iterator().next();
                labelBuilder.append(currentLabel);
            } else {
                Iterator<Object> i1 = subStates.iterator();
                labelBuilder.append("(");
                while (i1.hasNext()) {
                    String currentLabel = (String)i1.next();
                    labelBuilder.append(currentLabel);
                    if (!i1.hasNext()) continue;
                    labelBuilder.append(", ");
                }
                labelBuilder.append(")");
            }
            if (!i0.hasNext()) continue;
            labelBuilder.append(", ");
        }
        NFAVertexND dfaStartState = new NFAVertexND(labelBuilder.toString());
        toVisit.add(dfaStartState);
        HashMap<NFAVertexND, Set<NFAVertexND>> dfaStateToSubStatesMap = new HashMap<NFAVertexND, Set<NFAVertexND>>();
        dfaStateToSubStatesMap.put(dfaStartState, reachableFromStart);
        dfa.addVertex(dfaStartState);
        dfa.setInitialState(dfaStartState);
        for (NFAVertexND i : reachableFromStart) {
            if (NFAAnalysisTools.isInterrupted()) {
                throw new InterruptedException();
            }
            if (!input.isAcceptingState(i)) continue;
            dfa.addAcceptingState(dfaStartState);
        }
        NFAVertexND emptyState = new NFAVertexND(0);
        while (!toVisit.isEmpty()) {
            if (NFAAnalysisTools.isInterrupted()) {
                throw new InterruptedException();
            }
            NFAVertexND P = (NFAVertexND)toVisit.removeLast();
            HashMap<TransitionLabel, HashSet> newStates = new HashMap<TransitionLabel, HashSet>();
            Set subStates = (Set)dfaStateToSubStatesMap.get(P);
            for (NFAVertexND nFAVertexND : subStates) {
                if (NFAAnalysisTools.isInterrupted()) {
                    throw new InterruptedException();
                }
                for (Iterator<TransitionLabel> e : input.outgoingEdgesOf(nFAVertexND)) {
                    if (NFAAnalysisTools.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    if (((NFAEdge)((Object)e)).getIsEpsilonTransition()) continue;
                    TransitionLabel label = ((NFAEdge)((Object)e)).getTransitionLabel();
                    NFAVertexND targetState = ((NFAEdge)((Object)e)).getTargetVertex();
                    HashSet newState = newStates.containsKey(label) ? (HashSet)newStates.get(label) : new HashSet();
                    if (!newState.contains(targetState)) {
                        newState.add(targetState);
                    }
                    if (!newStates.containsKey(label)) {
                        HashSet entries = new HashSet(newStates.entrySet());
                        for (Map.Entry entry : entries) {
                            if (NFAAnalysisTools.isInterrupted()) {
                                throw new InterruptedException();
                            }
                            TransitionLabel tl1 = (TransitionLabel)entry.getKey();
                            TransitionLabel intersection = tl1.intersection(label);
                            if (intersection.isEmpty()) continue;
                            HashSet tmpVertices = (HashSet)newStates.remove(entry.getKey());
                            TransitionLabel uniqueTl1 = tl1.intersection(label.complement());
                            if (!uniqueTl1.isEmpty()) {
                                newStates.put(uniqueTl1, tmpVertices);
                            }
                            HashSet unionStates = new HashSet(tmpVertices);
                            unionStates.addAll(newState);
                            newStates.put(intersection, unionStates);
                            label = label.intersection(tl1.complement());
                        }
                    }
                    if (label.isEmpty()) continue;
                    newStates.put(label, newState);
                }
            }
            for (TransitionLabel transitionLabel : alphabet) {
                Iterator<TransitionLabel> e;
                if (NFAAnalysisTools.isInterrupted()) {
                    throw new InterruptedException();
                }
                TransitionLabel toEmptyState = transitionLabel;
                e = newStates.keySet().iterator();
                while (e.hasNext()) {
                    TransitionLabel tl = (TransitionLabel)e.next();
                    if (NFAAnalysisTools.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    if (!(toEmptyState = toEmptyState.intersection(tl.complement())).isEmpty()) continue;
                    break;
                }
                if (toEmptyState.isEmpty()) continue;
                if (!dfa.containsVertex(emptyState)) {
                    dfa.addVertex(emptyState);
                    e = alphabet.iterator();
                    while (e.hasNext()) {
                        TransitionLabel s2 = e.next();
                        dfa.addEdge(new NFAEdge(emptyState, emptyState, s2));
                    }
                }
                dfa.addEdge(new NFAEdge(P, emptyState, toEmptyState));
            }
            for (Map.Entry entry : newStates.entrySet()) {
                if (NFAAnalysisTools.isInterrupted()) {
                    throw new InterruptedException();
                }
                TransitionLabel label = (TransitionLabel)entry.getKey();
                HashSet<NFAVertexND> reachableViaSymbolEpsilon = new HashSet<NFAVertexND>();
                for (NFAVertexND v : (HashSet)entry.getValue()) {
                    if (NFAAnalysisTools.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    reachableViaSymbolEpsilon.add(v);
                    HashSet<NFAVertexND> reachableViaEpsilon = NFAAnalysisTools.reachableWithEpsilon(input, v);
                    reachableViaSymbolEpsilon.addAll(reachableViaEpsilon);
                }
                LinkedList sortedReachableViaSymbolEpsilon = new LinkedList(reachableViaSymbolEpsilon);
                Collections.sort(sortedReachableViaSymbolEpsilon);
                labelBuilder = new StringBuilder();
                Iterator i1 = sortedReachableViaSymbolEpsilon.iterator();
                while (i1.hasNext()) {
                    if (NFAAnalysisTools.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    NFAVertexND currentSubState = (NFAVertexND)i1.next();
                    ArrayList<String> labelSubStates = currentSubState.getStates();
                    if (labelSubStates.size() == 1) {
                        String currentLabel = (String)labelSubStates.iterator().next();
                        labelBuilder.append(currentLabel);
                    } else {
                        Iterator i2 = labelSubStates.iterator();
                        labelBuilder.append("(");
                        while (i2.hasNext()) {
                            if (NFAAnalysisTools.isInterrupted()) {
                                throw new InterruptedException();
                            }
                            String string = (String)i2.next();
                            labelBuilder.append(string);
                            if (!i2.hasNext()) continue;
                            labelBuilder.append(", ");
                        }
                        labelBuilder.append(")");
                    }
                    if (!i1.hasNext()) continue;
                    labelBuilder.append(", ");
                }
                NFAVertexND stateToAdd = new NFAVertexND(labelBuilder.toString());
                dfaStateToSubStatesMap.put(stateToAdd, reachableViaSymbolEpsilon);
                if (!dfa.containsVertex(stateToAdd)) {
                    toVisit.add(stateToAdd);
                    dfa.addVertex(stateToAdd);
                    for (NFAVertexND i : reachableViaSymbolEpsilon) {
                        if (!input.isAcceptingState(i)) continue;
                        dfa.addAcceptingState(stateToAdd);
                    }
                }
                dfa.addEdge(new NFAEdge(P, stateToAdd, label));
            }
        }
        return dfa;
    }

    public static NFAGraph dfaIntersection(NFAGraph m1, NFAGraph m2) {
        boolean isAcceptingState;
        NFAGraph intersectionGraph = new NFAGraph();
        NFAVertexND intersectionGraphInitialstate = new NFAVertexND(m1.getInitialState(), m2.getInitialState());
        int stateCounter = 0;
        HashMap<NFAVertexND, NFAVertexND> stateMap = new HashMap<NFAVertexND, NFAVertexND>();
        NFAVertexND mappedinitialState = new NFAVertexND("q" + stateCounter);
        ++stateCounter;
        stateMap.put(intersectionGraphInitialstate, mappedinitialState);
        intersectionGraph.addVertex(mappedinitialState);
        boolean bl = isAcceptingState = m1.isAcceptingState(m1.getInitialState()) && m2.isAcceptingState(m2.getInitialState());
        if (isAcceptingState) {
            intersectionGraph.addAcceptingState(mappedinitialState);
        }
        intersectionGraph.setInitialState(mappedinitialState);
        Stack<NFAVertexND> toVisit = new Stack<NFAVertexND>();
        toVisit.push(intersectionGraphInitialstate);
        boolean containsSinkState = false;
        NFAVertexND sinkState = null;
        while (!toVisit.isEmpty()) {
            NFAVertexND currentIntersectionState = (NFAVertexND)toVisit.pop();
            NFAVertexND m1SourceState = currentIntersectionState.getStateByDimension(1);
            NFAVertexND m2SourceState = currentIntersectionState.getStateByDimension(2);
            NFAVertexND currentMappedState = (NFAVertexND)stateMap.get(currentIntersectionState);
            TransitionLabel accountedSymbols = new CharacterClassTransitionLabel();
            for (NFAEdge e1 : m1.outgoingEdgesOf(m1SourceState)) {
                for (NFAEdge e2 : m2.outgoingEdgesOf(m2SourceState)) {
                    NFAVertexND targetMappedState;
                    NFAVertexND m2TargetState;
                    TransitionLabel e2TransitionLabel;
                    TransitionLabel e1TransitionLabel = e1.getTransitionLabel();
                    TransitionLabel intersectionTransitionLabel = e1TransitionLabel.intersection(e2TransitionLabel = e2.getTransitionLabel());
                    if (intersectionTransitionLabel.isEmpty()) continue;
                    NFAVertexND m1TargetState = e1.getTargetVertex();
                    NFAVertexND newIntersectionState = new NFAVertexND(m1TargetState, m2TargetState = e2.getTargetVertex());
                    if (!stateMap.containsKey(newIntersectionState)) {
                        targetMappedState = new NFAVertexND("q" + stateCounter);
                        ++stateCounter;
                        stateMap.put(newIntersectionState, targetMappedState);
                        intersectionGraph.addVertex(targetMappedState);
                        toVisit.push(newIntersectionState);
                        boolean bl2 = isAcceptingState = m1.isAcceptingState(m1TargetState) && m2.isAcceptingState(m2TargetState);
                        if (isAcceptingState) {
                            intersectionGraph.addAcceptingState(targetMappedState);
                        }
                    } else {
                        targetMappedState = (NFAVertexND)stateMap.get(newIntersectionState);
                    }
                    intersectionGraph.addEdge(new NFAEdge(currentMappedState, targetMappedState, intersectionTransitionLabel));
                    accountedSymbols = accountedSymbols.union(intersectionTransitionLabel);
                }
            }
            TransitionLabel unaccountedSymbols = accountedSymbols.complement();
            if (unaccountedSymbols.isEmpty()) continue;
            if (containsSinkState) {
                intersectionGraph.addEdge(new NFAEdge(currentIntersectionState, sinkState, unaccountedSymbols));
                continue;
            }
            sinkState = new NFAVertexND("q" + stateCounter);
            ++stateCounter;
            stateMap.put(sinkState, sinkState);
            intersectionGraph.addVertex(sinkState);
            containsSinkState = true;
            NFAEdge wildcardLoop = new NFAEdge(sinkState, sinkState, CharacterClassTransitionLabel.wildcardLabel());
            intersectionGraph.addEdge(wildcardLoop);
        }
        return intersectionGraph;
    }

    public static HashMap<NFAVertexND, Integer> topologicalSort(NFAGraph originalM) {
        NFAGraph m = originalM.copy();
        LinkedList<NFAVertexND> toVisit = new LinkedList<NFAVertexND>();
        HashMap<NFAVertexND, Integer> oldNewMap = new HashMap<NFAVertexND, Integer>();
        int orderCounter = 0;
        toVisit.addLast(m.getInitialState());
        while (!toVisit.isEmpty()) {
            NFAVertexND n = (NFAVertexND)toVisit.removeLast();
            oldNewMap.put(n, orderCounter++);
            for (NFAEdge e : originalM.outgoingEdgesOf(n)) {
                NFAVertexND targetVertex = e.getTargetVertex();
                m.removeEdge(e);
                if (m.inDegreeOf(targetVertex) != 0) continue;
                toVisit.addLast(targetVertex);
            }
        }
        if (!m.edgeSet().isEmpty()) {
            throw new RuntimeException("G5 cannot have cycles.");
        }
        return oldNewMap;
    }

    protected static boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }
}

