/*
 * Decompiled with CFR 0.152.
 */
package matcher.driver;

import analysis.AnalysisSettings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import matcher.MyMatcher;
import regexcompiler.MyPattern;

public class MatcherExploitStringTester {
    public static void main(String[] args) throws InterruptedException {
        int i;
        if (args.length < 4 || args.length % 2 != 0) {
            System.out.println("usage: <regex> <prefix> <pump_0> <pumpseparator_1> <pump_1> ... <pumpseparator_n> <pump_n> <suffix>");
            System.exit(0);
        }
        String patternStr = args[0];
        int numPumpSeparators = (args.length - 2) / 2;
        int numPumps = (args.length - 2) / 2;
        String prefix = MatcherExploitStringTester.makeVerbatim(args[1]);
        String[] pumpSeparators = new String[numPumpSeparators];
        String[] pumps = new String[numPumps];
        for (i = 1; i < args.length - 1; i += 2) {
            pumpSeparators[(i - 1) / 2] = MatcherExploitStringTester.makeVerbatim(args[i]);
            pumps[(i - 1) / 2] = MatcherExploitStringTester.makeVerbatim(args[i + 1]);
        }
        for (i = 0; i < numPumps; ++i) {
            System.out.println("ps_" + i + ": " + pumps[i] + " p_" + i + ": " + pumpSeparators[i]);
        }
        String suffix = MatcherExploitStringTester.makeVerbatim(args[args.length - 1]);
        int counter = 1;
        StringBuilder sb = new StringBuilder("Trying to exploit " + patternStr + " with ");
        for (int i2 = 1; i2 < args.length - 1; i2 += 2) {
            sb.append(args[i2] + args[i2 + 1] + "..." + args[i2 + 1]);
        }
        sb.append(suffix);
        System.out.println(sb.toString());
        StringBuilder[] pumpers = new StringBuilder[numPumps];
        for (int i3 = 0; i3 < numPumps; ++i3) {
            pumpers[i3] = new StringBuilder(pumps[i3]);
        }
        while (true) {
            StringBuilder exploitStringBuilder = new StringBuilder();
            for (int i4 = 0; i4 < numPumps; ++i4) {
                exploitStringBuilder.append(pumpSeparators[i4]);
                exploitStringBuilder.append(pumpers[i4].toString());
                pumpers[i4].append(pumps[i4]);
            }
            exploitStringBuilder.append(suffix);
            String exploitString = exploitStringBuilder.toString();
            MyPattern pattern = MyPattern.compile(patternStr, AnalysisSettings.NFAConstruction.JAVA);
            MyMatcher matcher = pattern.matcher(exploitString);
            long startTime = System.currentTimeMillis();
            boolean matches = matcher.matches();
            long endTime = System.currentTimeMillis();
            System.out.println("Iteration: " + counter + "| String length: " + exploitString.length() + "| Match time: " + (endTime - startTime));
            ++counter;
        }
    }

    private static String makeVerbatim(String s) {
        String toReturn = s;
        Pattern hexCharsPattern = Pattern.compile("\\\\x([0-9a-fA-F]{2})");
        Matcher m = hexCharsPattern.matcher(s);
        while (m.find()) {
            toReturn = toReturn.replaceAll(Matcher.quoteReplacement(m.group(0)), Matcher.quoteReplacement("" + (char)Integer.parseInt(m.group(1), 16)));
        }
        return toReturn;
    }
}

