/*
 * Decompiled with CFR 0.152.
 */
package nfa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nfa.NFAEdge;
import nfa.NFAVertexND;
import nfa.transitionlabel.TransitionLabel;
import org.jgrapht.graph.DirectedPseudograph;

public class NFAGraph
extends DirectedPseudograph<NFAVertexND, NFAEdge> {
    private static final long serialVersionUID = 1L;
    private NFAVertexND initialState;
    private HashSet<NFAVertexND> acceptingStates = new HashSet();

    public NFAVertexND getInitialState() {
        return this.initialState;
    }

    public void setInitialState(NFAVertexND initialState) {
        if (!super.containsVertex((Object)initialState)) {
            throw new IllegalArgumentException("Graph does not contain vertex: " + initialState);
        }
        this.initialState = initialState;
    }

    public void addAcceptingState(NFAVertexND acceptingState) {
        if (!super.containsVertex((Object)acceptingState)) {
            throw new IllegalArgumentException("Graph does not contain vertex: " + acceptingState);
        }
        this.acceptingStates.add(acceptingState);
    }

    public boolean isAcceptingState(String stateNumber) {
        return this.acceptingStates.contains(new NFAVertexND(stateNumber));
    }

    public boolean isAcceptingState(NFAVertexND state) {
        return this.acceptingStates.contains(state);
    }

    public void removeAcceptingState(NFAVertexND acceptingState) {
        if (!super.containsVertex((Object)acceptingState)) {
            throw new IllegalArgumentException("Graph does not contains accepting state: " + acceptingState);
        }
        this.acceptingStates.remove(acceptingState);
    }

    public Set<NFAVertexND> getAcceptingStates() {
        return this.acceptingStates;
    }

    public NFAGraph() {
        super(NFAEdge.class);
    }

    public NFAGraph copy() {
        NFAGraph c = new NFAGraph();
        for (NFAVertexND v : super.vertexSet()) {
            c.addVertex(v.copy());
        }
        for (NFAEdge e : super.edgeSet()) {
            c.addEdge(e.copy());
        }
        if (this.initialState != null) {
            c.initialState = this.initialState.copy();
        }
        for (NFAVertexND v : this.acceptingStates) {
            c.addAcceptingState(v.copy());
        }
        return c;
    }

    public boolean addEdge(NFAEdge newEdge) {
        if (newEdge == null) {
            throw new NullPointerException("New edge cannot be null");
        }
        if (newEdge.getTransitionLabel().isEmpty()) {
            return false;
        }
        NFAVertexND s = newEdge.getSourceVertex();
        NFAVertexND t = newEdge.getTargetVertex();
        if (super.containsEdge((Object)newEdge)) {
            NFAEdge e = this.getEdge(newEdge);
            e.incNumParallel();
        } else if (newEdge.getIsEpsilonTransition()) {
            Set es = super.getAllEdges((Object)s, (Object)t);
            for (NFAEdge currentEdge : es) {
                if (!currentEdge.equals(newEdge)) continue;
                currentEdge.incNumParallel();
                return true;
            }
        } else {
            Set es = super.getAllEdges((Object)s, (Object)t);
            for (NFAEdge currentEdge : es) {
                if (currentEdge.getTransitionType() != TransitionLabel.TransitionType.SYMBOL) continue;
                TransitionLabel tlCurrentEdge = currentEdge.getTransitionLabel();
                TransitionLabel tlNewEdge = newEdge.getTransitionLabel();
                TransitionLabel intersection = tlNewEdge.intersection(tlCurrentEdge);
                if (intersection.isEmpty()) continue;
                TransitionLabel currentEdgeRelabel = tlCurrentEdge.intersection(tlNewEdge.complement());
                int currentEdgeWeight = 0;
                if (!currentEdgeRelabel.isEmpty()) {
                    currentEdgeWeight = currentEdge.getNumParallel();
                    this.removeEdge(currentEdge);
                    NFAEdge currentEdgeRelabeled = new NFAEdge(s, t, currentEdgeRelabel);
                    currentEdgeRelabeled.setNumParallel(currentEdgeWeight);
                    this.addEdge(currentEdgeRelabeled);
                }
                NFAEdge overlappingEdge = new NFAEdge(s, t, intersection);
                overlappingEdge.setNumParallel(currentEdgeWeight + newEdge.getNumParallel());
                this.addEdge(overlappingEdge);
                TransitionLabel newEdgeRelabel = tlNewEdge.intersection(tlCurrentEdge.complement());
                if (!newEdgeRelabel.isEmpty()) {
                    int newEdgeWeight = newEdge.getNumParallel();
                    NFAEdge newEdgeRelabeled = new NFAEdge(s, t, newEdgeRelabel);
                    newEdgeRelabeled.setNumParallel(newEdgeWeight);
                    this.addEdge(newEdgeRelabeled);
                }
                return true;
            }
        }
        if (!super.containsVertex((Object)newEdge.getSourceVertex())) {
            throw new IllegalArgumentException("Graph doesn't contain vertex: " + newEdge.getSourceVertex());
        }
        if (!super.containsVertex((Object)newEdge.getTargetVertex())) {
            throw new IllegalArgumentException("Graph doesn't contain vertex: " + newEdge.getTargetVertex());
        }
        return super.addEdge((Object)newEdge.getSourceVertex(), (Object)newEdge.getTargetVertex(), (Object)newEdge);
    }

    public Set<NFAEdge> outgoingEpsilonEdgesOf(NFAVertexND v) {
        Set allEdges = super.outgoingEdgesOf((Object)v);
        HashSet<NFAEdge> toReturn = new HashSet<NFAEdge>();
        for (NFAEdge e : allEdges) {
            if (!e.getIsEpsilonTransition()) continue;
            toReturn.add(e);
        }
        return toReturn;
    }

    public boolean addVertex(NFAVertexND v) {
        if (this.containsVertex(v)) {
            throw new IllegalArgumentException("Graph already contains vertex: " + v);
        }
        return super.addVertex((Object)v);
    }

    public NFAEdge getEdge(NFAEdge e) {
        if (!super.containsEdge((Object)e)) {
            throw new IllegalArgumentException("Graph does not contain edge: " + e.getSourceVertex() + "->" + e.getTargetVertex() + ":" + e.getTransitionLabel());
        }
        Set edges = super.getAllEdges((Object)e.getSourceVertex(), (Object)e.getTargetVertex());
        for (NFAEdge currentE : edges) {
            if (!currentE.equals(e)) continue;
            return currentE;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        NFAGraph n = (NFAGraph)((Object)o);
        if (this.initialState != null && !this.initialState.equals(n.getInitialState())) {
            return false;
        }
        if (this.acceptingStates.size() != n.acceptingStates.size()) {
            return false;
        }
        for (NFAEdge e : n.edgeSet()) {
            Set nEdges = super.getAllEdges((Object)e.getSourceVertex(), (Object)e.getTargetVertex());
            for (NFAEdge nEdge : nEdges) {
                if (!e.equals(nEdge) || e.getNumParallel() == nEdge.getNumParallel()) continue;
                return false;
            }
        }
        if (!this.acceptingStates.containsAll(n.acceptingStates)) {
            return false;
        }
        return n.acceptingStates.containsAll(this.acceptingStates);
    }

    public NFAGraph reverse() {
        NFAGraph reversedGraph = this.copy();
        for (NFAEdge e : this.edgeSet()) {
            NFAVertexND newSource = e.getTargetVertex();
            NFAVertexND newTarget = e.getSourceVertex();
            NFAEdge reversedEdge = new NFAEdge(newSource, newTarget, e.getTransitionLabel());
            reversedGraph.removeEdge(e);
            reversedGraph.addEdge(reversedEdge);
        }
        return reversedGraph;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("I:" + this.initialState + " A:");
        if (!this.acceptingStates.isEmpty()) {
            for (NFAVertexND a : this.acceptingStates) {
                sb.append(a + ";");
            }
        } else {
            sb.append("No Accepting states;");
        }
        return sb.toString() + " " + super.toString();
    }

    private String nameState(NFAVertexND v) {
        StringBuilder sb = new StringBuilder("\"");
        ArrayList<String> states = v.getStates();
        Collections.sort(states);
        Iterator<String> stateIterator = states.iterator();
        while (stateIterator.hasNext()) {
            sb.append(stateIterator.next());
            if (!stateIterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("\"");
        return sb.toString();
    }
}

