/*
 * Decompiled with CFR 0.152.
 */
package nfa.transitionlabel;

import java.util.HashSet;
import java.util.Set;
import nfa.transitionlabel.TransitionLabel;
import nfa.transitionlabel.TransitionLabelParserRecursive;
import util.RangeSet;

public class CharacterClassTransitionLabel
implements TransitionLabel,
Comparable<CharacterClassTransitionLabel> {
    private final char PREFERRED_CHAR1 = (char)97;
    private final char PREFERRED_CHAR2 = (char)36;
    private static final boolean WILDCARD_MATCHES_NEWLINE = true;
    private final RangeSet ranges;

    public static CharacterClassTransitionLabel wildcardLabel() {
        CharacterClassTransitionLabel wildcardLabel = new CharacterClassTransitionLabel(CharacterClassTransitionLabel.predefinedRangeWildcard());
        return wildcardLabel;
    }

    public static RangeSet predefinedRangeWildcard() {
        RangeSet ranges = new RangeSet(0, 65536);
        RangeSet.Range wildCardRange = ranges.createRange(0, 65536);
        ranges.union(wildCardRange);
        return ranges;
    }

    public static RangeSet predefinedRangeSetDigits() {
        RangeSet ranges = new RangeSet(0, 65536);
        RangeSet.Range digitsRange = ranges.createRange(48, 58);
        ranges.union(digitsRange);
        return ranges;
    }

    public static RangeSet predefinedRangeSetWhiteSpaces() {
        RangeSet ranges = new RangeSet(0, 65536);
        RangeSet.Range spacesRange = ranges.createRange(9, 14);
        ranges.union(spacesRange);
        return ranges;
    }

    public static RangeSet predefinedRangeSetWordCharacters() {
        RangeSet ranges = new RangeSet(0, 65536);
        RangeSet.Range wordsRange1 = ranges.createRange(65, 91);
        RangeSet.Range wordsRange2 = ranges.createRange(95, 96);
        RangeSet.Range wordsRange3 = ranges.createRange(97, 123);
        ranges.union(wordsRange1);
        ranges.union(wordsRange2);
        ranges.union(wordsRange3);
        return ranges;
    }

    public static RangeSet predefinedRangeSetVerticalTab() {
        RangeSet ranges = new RangeSet(0, 65536);
        RangeSet.Range verticalTabRange = ranges.createRange(11);
        ranges.union(verticalTabRange);
        return ranges;
    }

    public static RangeSet predefinedRangeSetHorizontalTab() {
        RangeSet ranges = new RangeSet(0, 65536);
        RangeSet.Range horizontalTabRange = ranges.createRange(9);
        ranges.union(horizontalTabRange);
        return ranges;
    }

    public CharacterClassTransitionLabel() {
        this.ranges = new RangeSet(0, 65536);
    }

    public CharacterClassTransitionLabel(String word) {
        if (word.length() > 1) {
            throw new IllegalArgumentException("Parameter word must be of length 1.");
        }
        this.ranges = new RangeSet(0, 65536);
        RangeSet.Range r = this.ranges.createRange(word.charAt(0));
        this.ranges.union(r);
    }

    public CharacterClassTransitionLabel(RangeSet ranges) {
        this.ranges = new RangeSet(ranges);
    }

    @Override
    public boolean matches(String word) {
        TransitionLabelParserRecursive tlpr = new TransitionLabelParserRecursive(word);
        return this.matches(tlpr.parseTransitionLabel());
    }

    @Override
    public boolean matches(TransitionLabel tl) {
        if (tl instanceof CharacterClassTransitionLabel) {
            CharacterClassTransitionLabel cctl = (CharacterClassTransitionLabel)tl;
            RangeSet rs1 = new RangeSet(this.ranges);
            RangeSet rs2 = new RangeSet(cctl.ranges);
            rs1.intersection(rs2);
            return !rs1.isEmpty();
        }
        return false;
    }

    @Override
    public TransitionLabel intersection(TransitionLabel tl) {
        if (tl instanceof CharacterClassTransitionLabel) {
            CharacterClassTransitionLabel cctl = (CharacterClassTransitionLabel)tl;
            RangeSet rs1 = new RangeSet(this.ranges);
            RangeSet rs2 = new RangeSet(cctl.ranges);
            rs1.intersection(rs2);
            return new CharacterClassTransitionLabel(rs1);
        }
        throw new IllegalArgumentException("Invalid TransitionLabel type.");
    }

    @Override
    public TransitionLabel union(TransitionLabel tl) {
        if (tl instanceof CharacterClassTransitionLabel) {
            CharacterClassTransitionLabel cctl = (CharacterClassTransitionLabel)tl;
            RangeSet rs1 = new RangeSet(this.ranges);
            RangeSet rs2 = new RangeSet(cctl.ranges);
            rs1.union(rs2);
            return new CharacterClassTransitionLabel(rs1);
        }
        throw new IllegalArgumentException("Invalid TransitionLabel type.");
    }

    @Override
    public TransitionLabel complement() {
        RangeSet rs = new RangeSet(this.ranges);
        rs.complement();
        return new CharacterClassTransitionLabel(rs);
    }

    @Override
    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    public String getSymbol() {
        if (this.ranges.contains(97)) {
            return "a";
        }
        if (this.ranges.contains(36)) {
            return "$";
        }
        return "" + (char)this.ranges.sampleRangeSet();
    }

    @Override
    public TransitionLabel copy() {
        CharacterClassTransitionLabel toReturn = new CharacterClassTransitionLabel(this.ranges);
        assert (this.equals(toReturn)) : this + " " + toReturn;
        return toReturn;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharacterClassTransitionLabel)) {
            return false;
        }
        CharacterClassTransitionLabel cctl = (CharacterClassTransitionLabel)o;
        return cctl.ranges.equals(this.ranges);
    }

    public Set<String> getSymbols() {
        Set<Integer> symbolCodes = this.ranges.discretize();
        HashSet<String> symbols = new HashSet<String>();
        for (int sc : symbolCodes) {
            symbols.add("" + (char)sc);
        }
        return symbols;
    }

    public int hashCode() {
        return this.ranges.hashCode();
    }

    public String toString() {
        if (this.ranges.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (RangeSet.Range r : this.ranges) {
            String lowString = 33 <= r.low && r.low <= 126 ? "" + (char)r.low : String.format("\\x{%02x}", r.low);
            String highString = 33 <= r.high && r.high <= 126 ? "" + (char)(r.high - 1) : String.format("\\x{%02x}", r.high - 1);
            if (r.low == r.high - 2) {
                sb.append(lowString + highString);
                continue;
            }
            if (r.low != r.high - 1) {
                sb.append(lowString + "-" + highString);
                continue;
            }
            sb.append(lowString);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public TransitionLabel.TransitionType getTransitionType() {
        return TransitionLabel.TransitionType.SYMBOL;
    }

    @Override
    public int compareTo(CharacterClassTransitionLabel cctl) {
        return this.ranges.sampleRangeSet() - cctl.ranges.sampleRangeSet();
    }
}

