/*
 * Decompiled with CFR 0.152.
 */
package nfa.transitionlabel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import util.RangeSet;

public class CharacterPropertyParser {
    public static final int MIN_16UNICODE = 0;
    public static final int MAX_16UNICODE = 65536;
    private final String regex;
    private int index;
    private static final HashMap<String, HashMap<String, RangeSet>> prefixToSuffixesToRanges = new HashMap();
    private static final HashSet<String> caseInsensitivePrefixes = new HashSet();
    private static final HashSet<String> caseInsensitiveSuffixes = new HashSet();

    public void setIndex(int index) {
        this.index = index;
    }

    public CharacterPropertyParser(String regex, int index) {
        this.regex = regex;
        this.index = index;
    }

    public RangeSet parseCharacterPropertyIterative(String characterProperty) {
        int i;
        RangeSet toReturn = new RangeSet(0, 65536);
        LinkedList<RangeSet.Range> rangesToAdd = new LinkedList<RangeSet.Range>();
        String regex = "\\p{" + characterProperty + "}";
        Pattern p1 = Pattern.compile(regex);
        int startRange = 0;
        for (i = 0; i < 65536; ++i) {
            String input = "" + (char)i;
            if (p1.matcher(input).matches()) continue;
            if (startRange < i - 1) {
                RangeSet.Range r1;
                if (startRange + 1 == i - 1) {
                    r1 = toReturn.createRange(startRange + 1);
                    rangesToAdd.add(r1);
                } else {
                    r1 = toReturn.createRange(startRange + 1, i);
                    rangesToAdd.add(r1);
                }
            }
            startRange = i;
        }
        toReturn.union(rangesToAdd);
        if (startRange < i - 1) {
            RangeSet.Range r1;
            if (startRange + 1 == i - 1) {
                r1 = toReturn.createRange(startRange + 1);
                toReturn.union(r1);
            } else {
                r1 = toReturn.createRange(startRange + 1, i);
                toReturn.union(r1);
            }
        }
        return toReturn;
    }

    public RangeSet parseCharacterProperty(String characterProperty) {
        return this.parseCharacterPropertyStored(characterProperty);
    }

    public RangeSet parseCharacterPropertyStored(String characterProperty) {
        RangeSet toReturn = null;
        boolean found = false;
        for (String prefix : prefixToSuffixesToRanges.keySet()) {
            if (!characterProperty.startsWith(prefix) && (!caseInsensitivePrefixes.contains(prefix) || !characterProperty.toLowerCase().startsWith(prefix))) continue;
            String suffix = characterProperty.substring(prefix.length());
            HashMap<String, RangeSet> suffixesToRanges = prefixToSuffixesToRanges.get(prefix);
            if (suffixesToRanges.containsKey(suffix)) {
                toReturn = suffixesToRanges.get(suffix);
                found = true;
                continue;
            }
            if (!caseInsensitiveSuffixes.contains(suffix.toUpperCase()) || !suffixesToRanges.containsKey(suffix.toUpperCase())) continue;
            toReturn = suffixesToRanges.get(suffix.toUpperCase());
            found = true;
        }
        if (!found) {
            throw new PatternSyntaxException("Unknown character property name {" + characterProperty + "}", this.regex, this.index);
        }
        return toReturn;
    }

    public static void main(String[] args) {
        CharacterPropertyParser.testAll();
    }

    private static void testAll() {
        CharacterPropertyParser cpp = new CharacterPropertyParser("\\p{...}", 3);
        for (Map.Entry<String, HashMap<String, RangeSet>> kv : prefixToSuffixesToRanges.entrySet()) {
            String prefixOriginal = kv.getKey();
            LinkedList<String> prefixes = new LinkedList<String>();
            prefixes.add(prefixOriginal);
            if (caseInsensitivePrefixes.contains(prefixOriginal)) {
                int maxToAdd;
                int possibleRandomCasesLeft = (1 << prefixOriginal.length()) - 1;
                int numToAdd = possibleRandomCasesLeft > (maxToAdd = 3) ? maxToAdd : possibleRandomCasesLeft;
                prefixes.addAll(CharacterPropertyParser.randomiseCase(prefixOriginal, numToAdd));
            }
            for (String prefix : prefixes) {
                int prefixCounter = 0;
                HashMap<String, RangeSet> suffixToRangeSet = kv.getValue();
                for (Map.Entry<String, RangeSet> kv2 : suffixToRangeSet.entrySet()) {
                    String suffixOriginal = kv2.getKey();
                    LinkedList<String> suffixes = new LinkedList<String>();
                    suffixes.add(suffixOriginal);
                    if (caseInsensitiveSuffixes.contains(suffixOriginal)) {
                        int maxToAdd;
                        int possibleRandomCasesLeft = (1 << suffixOriginal.length()) - 1;
                        int numToAdd = possibleRandomCasesLeft > (maxToAdd = 3) ? maxToAdd : possibleRandomCasesLeft;
                        suffixes.addAll(CharacterPropertyParser.randomiseCase(suffixOriginal, numToAdd));
                    }
                    for (String suffix : suffixes) {
                        String charProperty;
                        RangeSet correctRangeSet;
                        RangeSet rangeSet = kv2.getValue();
                        if (!rangeSet.equals(correctRangeSet = cpp.parseCharacterPropertyIterative(charProperty = prefix + suffix))) {
                            System.err.println("\tFile:\t" + rangeSet);
                            System.err.println("\tItr:\t" + correctRangeSet);
                        }
                        ++prefixCounter;
                    }
                }
                System.out.println(prefix + " total: " + prefixCounter);
            }
        }
    }

    private static List<String> randomiseCase(String original, int numToAdd) {
        HashSet<String> generated = new HashSet<String>();
        int breakCounter = 0;
        int breakMax = 10000;
        int i = 0;
        Random r = new Random();
        while (i < numToAdd) {
            StringBuilder sb = new StringBuilder();
            for (char c : original.toCharArray()) {
                double randomDouble = r.nextDouble();
                c = randomDouble >= 0.5 ? Character.toUpperCase(c) : Character.toLowerCase(c);
                sb.append(c);
            }
            String toAdd = sb.toString();
            if (!generated.contains(toAdd) && !original.equals(toAdd)) {
                generated.add(toAdd);
                breakCounter = 0;
                ++i;
                continue;
            }
            if (++breakCounter <= breakMax) continue;
            throw new IllegalArgumentException("Cannot generate " + numToAdd + " unique from " + original);
        }
        return new LinkedList<String>(generated);
    }

    static {
        try (BufferedReader fileReader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(CharacterPropertyParser.class.getClassLoader().getResourceAsStream("/predef_ranges.txt"))));){
            while (fileReader.ready()) {
                String[] prefixes;
                String line = fileReader.readLine();
                String[] fields = line.split(":");
                String prefixesStr = fields[0];
                String prefixCS = fields[1];
                String suffixesStr = fields[2];
                String suffixCS = fields[3];
                String rangesStr = fields[4];
                String[] ranges = rangesStr.split(",");
                RangeSet rangeSet = new RangeSet(0, 65536);
                LinkedList<RangeSet.Range> rangesToAdd = new LinkedList<RangeSet.Range>();
                for (String range : ranges) {
                    if (range.contains("-")) {
                        int index = range.indexOf("-");
                        String minBoundStr = range.substring(0, index);
                        String maxBoundStr = range.substring(index + 1);
                        int minBound = Integer.parseInt(minBoundStr);
                        int maxBound = Integer.parseInt(maxBoundStr);
                        rangesToAdd.add(rangeSet.createRange(minBound, maxBound + 1));
                        continue;
                    }
                    int rangeInt = Integer.parseInt(range);
                    rangesToAdd.add(rangeSet.createRange(rangeInt));
                }
                rangeSet.union(rangesToAdd);
                for (String prefix : prefixes = prefixesStr.split(",")) {
                    String[] suffixes;
                    for (String suffix : suffixes = suffixesStr.split(",")) {
                        HashMap<Object, Object> newSuffixesToRanges;
                        if (prefixCS.equals("false")) {
                            caseInsensitivePrefixes.add(prefix);
                        }
                        if (suffixCS.equals("false")) {
                            caseInsensitiveSuffixes.add(suffix);
                        }
                        if (prefixToSuffixesToRanges.containsKey(prefix)) {
                            newSuffixesToRanges = prefixToSuffixesToRanges.get(prefix);
                            if (newSuffixesToRanges.containsKey(suffix)) {
                                RangeSet oldRangesSet = (RangeSet)newSuffixesToRanges.get(suffix);
                                if (oldRangesSet.equals(rangeSet)) continue;
                                throw new RuntimeException("Contradicting ranges for prefix and suffix");
                            }
                            newSuffixesToRanges.put(suffix, rangeSet);
                            prefixToSuffixesToRanges.put(prefix, newSuffixesToRanges);
                            continue;
                        }
                        newSuffixesToRanges = new HashMap();
                        newSuffixesToRanges.put(suffix, rangeSet);
                        prefixToSuffixesToRanges.put(prefix, newSuffixesToRanges);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't load predef_ranges: " + e.getMessage(), e);
        }
    }
}

