/*
 * Decompiled with CFR 0.152.
 */
package preprocessor;

import java.util.List;
import preprocessor.ParsingPreprocessor;
import preprocessor.PreprocessorRule;

public abstract class OperatorExpansionRule
implements PreprocessorRule {
    protected abstract void expandOperator(StringBuilder var1, ParsingPreprocessor.RegexToken var2, ParsingPreprocessor.RegexToken var3);

    protected abstract ParsingPreprocessor.RegexOperator getOperator();

    protected abstract ParsingPreprocessor.RegexOperator.OperatorType getOperatorType();

    @Override
    public String process(List<ParsingPreprocessor.RegexToken> tokenStream) {
        StringBuilder regexBuilder = new StringBuilder();
        ParsingPreprocessor.RegexToken[] tokens = new ParsingPreprocessor.RegexToken[tokenStream.size()];
        tokens = tokenStream.toArray(tokens);
        int numTokens = tokens.length;
        int i = 0;
        while (i < numTokens) {
            if (tokens[i].getTokenType() == ParsingPreprocessor.RegexToken.TokenType.REGEX_FACTOR) {
                ParsingPreprocessor.RegexFactor factorToken = (ParsingPreprocessor.RegexFactor)tokens[i];
                if (factorToken.getFactorType() == ParsingPreprocessor.RegexFactor.FactorType.GROUP) {
                    ParsingPreprocessor.GroupFactor groupFactor = (ParsingPreprocessor.GroupFactor)factorToken;
                    String processedContent = this.process((List)groupFactor.factorContent);
                    ParsingPreprocessor.GroupFactor processedGroup = new ParsingPreprocessor.GroupFactor(processedContent, groupFactor.getGroupType(), groupFactor.getLevel());
                    factorToken = processedGroup;
                }
                if (i < numTokens - 1) {
                    if (tokens[++i].getTokenType() == ParsingPreprocessor.RegexToken.TokenType.REGEX_OPERATOR) {
                        ParsingPreprocessor.RegexOperator operatorToken = (ParsingPreprocessor.RegexOperator)tokens[i];
                        ++i;
                        if (operatorToken.getOperatorType() == this.getOperatorType()) {
                            this.expandOperator(regexBuilder, factorToken, operatorToken);
                            continue;
                        }
                        regexBuilder.append(factorToken.getRepresentation());
                        regexBuilder.append(operatorToken.getRepresentation());
                        continue;
                    }
                    regexBuilder.append(factorToken.getRepresentation());
                    continue;
                }
                regexBuilder.append(factorToken.getRepresentation());
                ++i;
                continue;
            }
            regexBuilder.append(tokens[i].getRepresentation());
            ++i;
        }
        return regexBuilder.toString();
    }
}

