/*
 * Decompiled with CFR 0.152.
 */
package preprocessor;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Scanner;
import preprocessor.CountClosureOperatorExpansion;
import preprocessor.DequantifierRule;
import preprocessor.EscapeSequenceExpansionRule;
import preprocessor.ParsingPreprocessor;
import preprocessor.PlusOperatorExpansion;
import preprocessor.QuestionMarkOperatorExpansion;
import preprocessor.WildCardExpansionRule;

public class PreciseSubstitutionPreprocessor
extends ParsingPreprocessor {
    public PreciseSubstitutionPreprocessor() {
        DequantifierRule dr = new DequantifierRule();
        this.addRule(dr);
        EscapeSequenceExpansionRule eer = new EscapeSequenceExpansionRule();
        this.addRule(eer);
        WildCardExpansionRule wcer = new WildCardExpansionRule();
        this.addRule(wcer);
        PlusOperatorExpansion poe = new PlusOperatorExpansion();
        this.addRule(poe);
        QuestionMarkOperatorExpansion qmoe = new QuestionMarkOperatorExpansion();
        this.addRule(qmoe);
        CountClosureOperatorExpansion ccoe = new CountClosureOperatorExpansion();
        this.addRule(ccoe);
    }

    public static void main(String[] args) {
        PreciseSubstitutionPreprocessor.testingCount();
    }

    private static void testingVulnerable() {
        String orinigalRegex = " <[a-zA-Z][^>]*\\son\\w+=(\\w+|'[^']*'|\"[^\"]*\")[^>]*> ";
        PreciseSubstitutionPreprocessor p = new PreciseSubstitutionPreprocessor();
        String newRegex = p.applyRules(orinigalRegex);
        System.out.println(newRegex);
    }

    private static void testingPlus() {
        String[] originalRegexs = new String[]{"(a)+?", "[a]+", "b+", "a\\+", "[ba+]", "(ab+)+", "abc+", "\\Qabc+\\E+", "[\\Qabc\\E]+", "\\++", "\\(+", "\\x{FFF}+", "\\uffff+", "\\077+", "\\s+", "(abc){0,1}+", "[\\[]+"};
        String[] correctRegexs = new String[]{"(a)(a)*", "[a][a]*", "bb*", "a\\+", "[ba+]", "(abb*)(abb*)*", "abcc*", "\\Qabc+\\E\\+*", "[\\Qabc\\E][\\Qabc\\E]*", "\\+\\+*", "\\(\\(*", "\\x{FFF}", "\\uffff\\uffff*", "\\077\\077*", "\\s\\s*", "(abc){0,1}", "[\\[][\\[]*"};
        PreciseSubstitutionPreprocessor p = new PreciseSubstitutionPreprocessor();
        for (int i = 0; i < originalRegexs.length; ++i) {
            String originalRegex = originalRegexs[i];
            String correctRegex = correctRegexs[i];
            String newRegex = p.applyRules(originalRegex);
            if (newRegex.equals(correctRegex)) continue;
            System.out.println("Original: " + originalRegex + "\tReplace: " + newRegex + "\tCorrect: " + correctRegex);
        }
    }

    private static void testingCount() {
        String[] originalRegexs = new String[]{"a{1,2}", "(a){0,3}", "(abc){2,5}", "a{3,}", "a{3}"};
        String[] correctRegexs = new String[]{"(a(\\l|a))", "((\\l|(a)|(a)(a)|(a)(a)(a)))", "((abc)(abc)(\\l|(abc)|(abc)(abc)|(abc)(abc)(abc)))", "(aaaa*)", "(aaa)"};
        PreciseSubstitutionPreprocessor p = new PreciseSubstitutionPreprocessor();
        for (int i = 0; i < originalRegexs.length; ++i) {
            String originalRegex = originalRegexs[i];
            String correctRegex = correctRegexs[i];
            String newRegex = p.applyRules(originalRegex);
            if (newRegex.equals(correctRegex)) continue;
            System.out.println("Original: " + originalRegex + "\tReplace: " + newRegex + "\tCorrect: " + correctRegex);
        }
    }

    private static void testingNonCapturingGroups() {
        String[] originalRegexs = new String[]{"(?:a)", "(?:)", "(a)", "(?:(?:a))"};
        String[] correctRegexs = new String[]{"(a)", "()", "(a)", "((a))"};
        PreciseSubstitutionPreprocessor p = new PreciseSubstitutionPreprocessor();
        for (int i = 0; i < originalRegexs.length; ++i) {
            String originalRegex = originalRegexs[i];
            String correctRegex = correctRegexs[i];
            String newRegex = p.applyRules(originalRegex);
            if (newRegex.equals(correctRegex)) continue;
            System.out.println("Original: " + originalRegex + "\tReplace: " + newRegex + "\tCorrect: " + correctRegex);
        }
    }

    private static void testingDequantifier() {
        String[] originalRegexs = new String[]{"[a]++", "([a++]*?)", "a+?b*+", "\\d*?"};
        String[] correctRegexs = new String[]{"[a]+", "([a++]*)", "a+b*", "\\d*"};
        PreciseSubstitutionPreprocessor p = new PreciseSubstitutionPreprocessor();
        for (int i = 0; i < originalRegexs.length; ++i) {
            String originalRegex = originalRegexs[i];
            String correctRegex = correctRegexs[i];
            String newRegex = p.applyRules(originalRegex);
            if (newRegex.equals(correctRegex)) continue;
            System.out.println("Original: " + originalRegex + "\tReplace: " + newRegex + "\tCorrect: " + correctRegex);
        }
    }

    private static void testingQuestionMark() {
        String[] originalRegexs = new String[]{"a?+", "(abc)?", "\\Qabc\\E?", "a{0,1}?", "a|[[b\\[]]?"};
        String[] correctRegexs = new String[]{"(\\l|a)", "(\\l|(abc))", "\\Qab\\E(\\l|c)", "a{0,1}", "a|(\\l|[[b\\[]])"};
        PreciseSubstitutionPreprocessor p = new PreciseSubstitutionPreprocessor();
        for (int i = 0; i < originalRegexs.length; ++i) {
            String originalRegex = originalRegexs[i];
            String correctRegex = correctRegexs[i];
            String newRegex = p.applyRules(originalRegex);
            if (newRegex.equals(correctRegex)) continue;
            System.out.println("Original: " + originalRegex + "\tReplace: " + newRegex + "\tCorrect: " + correctRegex);
        }
    }

    private static void driver(String inputFileName) {
        try {
            Scanner inputReader = new Scanner(new FileReader(inputFileName));
            PrintWriter outputWriter = new PrintWriter("output.txt");
            int counter = 1;
            int skipCounter = 0;
            PreciseSubstitutionPreprocessor p = new PreciseSubstitutionPreprocessor();
            while (inputReader.hasNextLine()) {
                String line = inputReader.nextLine();
                try {
                    String processedLine = p.applyRules(line);
                    System.out.println(counter + " " + line);
                    System.out.println(counter + " " + processedLine);
                    System.out.println();
                    outputWriter.println(processedLine);
                    System.out.flush();
                }
                catch (Exception e) {
                    System.out.println("SKIPPING: " + counter + " " + line);
                    System.out.println();
                    ++skipCounter;
                    System.out.flush();
                }
                ++counter;
            }
            System.out.println("Amount skipped: " + skipCounter);
            inputReader.close();
            outputWriter.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

