/*
 * Decompiled with CFR 0.152.
 */
package regexcompiler;

import java.util.List;
import regexcompiler.RegexSubexpression;
import regexcompiler.RegexToken;

public class RegexGroup
extends RegexSubexpression<List<RegexToken>> {
    private final RegexGroupType groupType;

    public RegexGroupType getGroupType() {
        return this.groupType;
    }

    public RegexGroup(List<RegexToken> subexpressionContent, RegexGroupType groupType, int index) {
        super(subexpressionContent, index);
        this.groupType = groupType;
    }

    @Override
    public RegexSubexpression.SubexpressionType getSubexpressionType() {
        return RegexSubexpression.SubexpressionType.GROUP;
    }

    public String toString() {
        return '(' + this.groupType.toString() + ((List)this.getSubexpressionContent()).toString() + ')';
    }

    public static enum RegexGroupType {
        NORMAL(""),
        NONCAPTURING("?:"),
        POSLOOKAHEAD("?="),
        POSLOOKBEHIND("?<="),
        NEGLOOKAHEAD("?!"),
        NEGLOOKBEHIND("?<!");

        private final String symbol;

        private RegexGroupType(String symbol) {
            this.symbol = symbol;
        }

        public String toString() {
            return this.symbol;
        }
    }
}

