/*
 * Decompiled with CFR 0.152.
 */
package regexcompiler;

import regexcompiler.RegexOperator;

public class RegexQuantifiableOperator
extends RegexOperator {
    private final QuantifierType quantifierType;

    public QuantifierType getQuantifierType() {
        return this.quantifierType;
    }

    public RegexQuantifiableOperator(RegexOperator.OperatorType operatorType, QuantifierType quantifierType, int index) {
        super(operatorType, index);
        this.quantifierType = quantifierType;
    }

    @Override
    public String toString() {
        String operator = this.getOperatorType().toString();
        String quantifier = this.getQuantifierType().toString();
        return operator + quantifier;
    }

    public static class RegexQuestionMarkOperator
    extends RegexQuantifiableOperator {
        public RegexQuestionMarkOperator(QuantifierType quantifierType, int index) {
            super(RegexOperator.OperatorType.QUESTION_MARK, quantifierType, index);
        }
    }

    public static class RegexPlusOperator
    extends RegexQuantifiableOperator {
        public RegexPlusOperator(QuantifierType quantifierType, int index) {
            super(RegexOperator.OperatorType.PLUS, quantifierType, index);
        }
    }

    public static class RegexStarOperator
    extends RegexQuantifiableOperator {
        public RegexStarOperator(QuantifierType quantifierType, int index) {
            super(RegexOperator.OperatorType.STAR, quantifierType, index);
        }
    }

    public static enum QuantifierType {
        GREEDY(""),
        RELUCTANT("?"),
        POSSESSIVE("+");

        private final String symbol;

        private QuantifierType(String symbol) {
            this.symbol = symbol;
        }

        public String toString() {
            return this.symbol;
        }
    }
}

