/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class RangeSet
implements Iterable<Range> {
    private final int rangesLowerBound;
    private final int rangesUpperBound;
    private TreeSet<Range> ranges;

    public RangeSet(int rangesLowerBound, int rangesUpperBound) {
        this.rangesLowerBound = rangesLowerBound;
        this.rangesUpperBound = rangesUpperBound;
        this.ranges = new TreeSet();
    }

    public RangeSet(RangeSet rs) {
        this.rangesLowerBound = rs.rangesLowerBound;
        this.rangesUpperBound = rs.rangesUpperBound;
        this.ranges = new TreeSet<Range>((SortedSet<Range>)rs.ranges);
    }

    public Range createRange(int num) {
        return new Range(num);
    }

    public Range createRange(int low, int high) {
        return new Range(low, high);
    }

    public void union(RangeSet rs) {
        this.ranges.addAll(rs.ranges);
        this.mergeRanges();
    }

    public void union(Range r) {
        this.ranges.add(r);
        this.mergeRanges();
    }

    public void union(List<Range> rangesToAdd) {
        this.ranges.addAll(rangesToAdd);
        this.mergeRanges();
    }

    public void intersection(RangeSet rs) {
        this.complement();
        rs.complement();
        this.union(rs);
        this.complement();
    }

    public void complement() {
        if (this.ranges.isEmpty()) {
            this.union(new Range(this.rangesLowerBound, this.rangesUpperBound));
            return;
        }
        TreeSet<Range> rangesComplement = new TreeSet<Range>();
        Iterator<Range> i0 = this.ranges.iterator();
        Range currentRange = i0.next();
        if (currentRange.low != this.rangesLowerBound) {
            rangesComplement.add(new Range(this.rangesLowerBound, currentRange.low));
        }
        while (i0.hasNext()) {
            int newLow = currentRange.high;
            currentRange = i0.next();
            int newHigh = currentRange.low;
            Range newRange = new Range(newLow, newHigh);
            rangesComplement.add(newRange);
        }
        if (currentRange.high != this.rangesUpperBound) {
            rangesComplement.add(new Range(currentRange.high, this.rangesUpperBound));
        }
        this.ranges = rangesComplement;
    }

    public Set<Integer> discretize() {
        HashSet<Integer> values = new HashSet<Integer>();
        for (Range r : this.ranges) {
            for (int i = r.low; i < r.high; ++i) {
                values.add(i);
            }
        }
        return values;
    }

    private void mergeRanges() {
        LinkedList<Range> l = new LinkedList<Range>(this.ranges);
        int i = 0;
        while (i < l.size() - 1) {
            Range r2;
            Range r1 = (Range)l.get(i);
            if (r1.overlapsAdjacent(r2 = (Range)l.get(i + 1))) {
                l.set(i, r1.merge(r2));
                l.remove(i + 1);
                continue;
            }
            ++i;
        }
        this.ranges = new TreeSet<Range>(l);
    }

    public int sampleRangeSet() {
        if (this.ranges.isEmpty()) {
            throw new IllegalStateException("Cannot sample from empty range set.");
        }
        return this.ranges.first().low;
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeSet)) {
            return false;
        }
        RangeSet rs = (RangeSet)o;
        if (this.ranges.size() != rs.ranges.size()) {
            return false;
        }
        Iterator<Range> i0 = this.ranges.iterator();
        Iterator<Range> i1 = rs.ranges.iterator();
        while (i0.hasNext()) {
            Range r1;
            Range r0 = i0.next();
            if (r0.equals(r1 = i1.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 17 * this.rangesLowerBound + 33 * this.rangesUpperBound + this.ranges.hashCode();
    }

    public boolean contains(int num) {
        Range numRange = new Range(num);
        for (Range r : this.ranges) {
            if (!r.overlaps(numRange)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Range r : this.ranges) {
            sb.append("[" + r.low + "," + r.high + ") ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        RangeSet rs1 = new RangeSet(0, 256);
        Range r11 = rs1.createRange(0, 10);
        rs1.union(r11);
        Range r12 = rs1.createRange(20, 30);
        rs1.union(r12);
        Range r13 = rs1.createRange(40, 50);
        rs1.union(r13);
        RangeSet rs2 = new RangeSet(0, 256);
        Range r21 = rs2.createRange(10, 20);
        rs2.union(r21);
        Range r22 = rs2.createRange(30, 40);
        rs1.union(r22);
        Range r23 = rs2.createRange(50, 60);
        rs2.union(r23);
        System.out.println(rs1);
        System.out.println(rs2);
        rs1.intersection(rs2);
        System.out.println(rs1);
        RangeSet rs3 = new RangeSet(0, 256);
        Range r31 = rs3.createRange(0, 256);
        rs3.union(r31);
        System.out.println(rs3);
        rs3.complement();
        System.out.println(rs3);
        rs3.complement();
        System.out.println(rs3);
    }

    @Override
    public Iterator<Range> iterator() {
        return this.ranges.iterator();
    }

    public class Range
    implements Comparable<Range> {
        public final int low;
        public final int high;

        public Range(int low, int high) {
            if (low < RangeSet.this.rangesLowerBound || high > RangeSet.this.rangesUpperBound + 1) {
                throw new IllegalArgumentException("Range exceeds bounds.");
            }
            if (low >= high) {
                throw new IllegalArgumentException("Low must less than high.");
            }
            this.low = low;
            this.high = high;
        }

        public Range(int num) {
            if (num < RangeSet.this.rangesLowerBound || num > RangeSet.this.rangesUpperBound + 1) {
                throw new IllegalArgumentException("Range exceeds bounds.");
            }
            this.low = num;
            this.high = num + 1;
        }

        public boolean overlaps(Range r) {
            return this.low < r.high && r.low < this.high;
        }

        public boolean overlapsAdjacent(Range r) {
            return this.low <= r.high && r.low <= this.high;
        }

        public Range merge(Range r) {
            int newLow = 0;
            int newHigh = 0;
            if (!this.overlapsAdjacent(r)) {
                throw new RuntimeException("Cannot merge non-overlapping ranges");
            }
            newLow = this.low <= r.low ? this.low : r.low;
            newHigh = this.high >= r.high ? this.high : r.high;
            return new Range(newLow, newHigh);
        }

        public RangeSet complement() {
            if (this.low == RangeSet.this.rangesLowerBound && this.high == RangeSet.this.rangesUpperBound + 1) {
                return new RangeSet(RangeSet.this.rangesLowerBound, RangeSet.this.rangesUpperBound);
            }
            if (this.low == RangeSet.this.rangesLowerBound) {
                Range rComplement = new Range(this.high, RangeSet.this.rangesUpperBound + 1);
                RangeSet rs = new RangeSet(RangeSet.this.rangesLowerBound, RangeSet.this.rangesUpperBound);
                rs.union(rComplement);
                return rs;
            }
            if (this.high == RangeSet.this.rangesUpperBound + 1) {
                Range rComplement = new Range(RangeSet.this.rangesLowerBound, this.low);
                RangeSet rs = new RangeSet(RangeSet.this.rangesLowerBound, RangeSet.this.rangesUpperBound);
                rs.union(rComplement);
                return rs;
            }
            Range r1 = new Range(RangeSet.this.rangesLowerBound, this.low);
            Range r2 = new Range(this.high, RangeSet.this.rangesUpperBound + 1);
            RangeSet comp1 = new RangeSet(RangeSet.this.rangesLowerBound, RangeSet.this.rangesUpperBound);
            comp1.union(r1);
            RangeSet comp2 = new RangeSet(RangeSet.this.rangesLowerBound, RangeSet.this.rangesUpperBound);
            comp2.union(r2);
            comp1.union(comp2);
            return comp1;
        }

        @Override
        public int compareTo(Range r) {
            if (this.low != r.low) {
                return this.low - r.low;
            }
            return this.high - r.high;
        }

        public String toString() {
            return "[" + this.low + ", " + (this.high - 1) + "]";
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range r = (Range)o;
            return this.low == r.low && this.high == r.high;
        }

        public int hashCode() {
            return 5 * this.low + 7 * this.high;
        }
    }
}

