/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import analysis.AnalysisSettings;
import analysis.EdaAnalysisResults;
import analysis.IdaAnalysisResults;
import analysis.NFAAnalyser;
import analysis.NFAAnalyserInterface;
import analysis.NFAAnalysisTools;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;

public class NFAAnalyserMerging
extends NFAAnalyser {
    public NFAAnalyserMerging(AnalysisSettings.PriorityRemovalStrategy priorityRemovalStrategy, int maxComplexity) {
        super(priorityRemovalStrategy, maxComplexity);
    }

    private EdaAnalysisResults testCaseESCC(NFAGraph originalM, LinkedList<NFAGraph> sccsInOriginal, Map<NFAVertexND, NFAGraph> esccs) {
        HashMap<NFAGraph, LinkedList> sccToMergedESCCStatesMap = new HashMap<NFAGraph, LinkedList>();
        for (NFAGraph currentSCCInOriginal : sccsInOriginal) {
            for (NFAVertexND currentVertex : currentSCCInOriginal.vertexSet()) {
                if (!esccs.containsKey(currentVertex)) continue;
                LinkedList newList = sccToMergedESCCStatesMap.containsKey(currentVertex) ? (LinkedList)sccToMergedESCCStatesMap.get(currentVertex) : new LinkedList();
                newList.add(currentVertex);
                sccToMergedESCCStatesMap.put(currentSCCInOriginal, newList);
            }
        }
        for (NFAGraph currentSCCInOriginal : sccsInOriginal) {
            LinkedList esscsInCurrentSCC = sccToMergedESCCStatesMap.containsKey((Object)currentSCCInOriginal) ? (LinkedList)sccToMergedESCCStatesMap.get((Object)currentSCCInOriginal) : new LinkedList();
            for (NFAVertexND mergedESCCInSCC : esscsInCurrentSCC) {
                NFAGraph currentESCC = esccs.get(mergedESCCInSCC);
                HashMap<NFAVertexND, NFAEdge> entranceStates = new HashMap<NFAVertexND, NFAEdge>();
                HashMap<NFAVertexND, NFAEdge> exitStates = new HashMap<NFAVertexND, NFAEdge>();
                for (NFAVertexND v : currentESCC.vertexSet()) {
                    for (NFAEdge e : currentSCCInOriginal.incomingEdgesOf(v)) {
                        if (currentESCC.containsEdge(e) || entranceStates.containsKey(v)) continue;
                        entranceStates.put(v, e);
                    }
                    for (NFAEdge e : currentSCCInOriginal.outgoingEdgesOf(v)) {
                        if (currentESCC.containsEdge(e) || exitStates.containsKey(v)) continue;
                        exitStates.put(v, e);
                    }
                }
                for (NFAVertexND start : entranceStates.keySet()) {
                    HashMap<NFAVertexND, Integer> pathsToOtherVertices = NFAAnalysisTools.numWalksFrom(currentESCC, start);
                    for (Map.Entry<NFAVertexND, Integer> kv : pathsToOtherVertices.entrySet()) {
                        NFAVertexND p = kv.getKey();
                        if (!exitStates.containsKey(p) || kv.getValue() <= 1) continue;
                        NFAEdge entranceEdge = (NFAEdge)entranceStates.get(start);
                        NFAEdge exitEdge = (NFAEdge)exitStates.get(p);
                        NFAAnalyserInterface.EdaAnalysisResultsESCC resultsObject = new NFAAnalyserInterface.EdaAnalysisResultsESCC(originalM, currentSCCInOriginal, entranceEdge, exitEdge);
                        return resultsObject;
                    }
                }
            }
        }
        return new NFAAnalyserInterface.EdaAnalysisResultsNoEda(originalM);
    }

    @Override
    protected EdaAnalysisResults calculateEdaAnalysisResults(NFAGraph originalM) {
        LinkedList<NFAGraph> sccsInOriginal = NFAAnalysisTools.getStronglyConnectedComponents(originalM, this.maxComplexity);
        if (sccsInOriginal == null) {
            return new NFAAnalyserInterface.TooComplexEdaAnalysisResults(originalM);
        }
        NFAGraph merged = originalM.copy();
        Map<NFAVertexND, NFAGraph> esccs = NFAAnalysisTools.mergeStronglyConnectedComponents(merged, true, this.maxComplexity);
        if (esccs == null) {
            return new NFAAnalyserInterface.TooComplexEdaAnalysisResults(originalM);
        }
        LinkedList<NFAGraph> sccsInMerged = NFAAnalysisTools.getStronglyConnectedComponents(merged, this.maxComplexity);
        if (sccsInMerged == null) {
            return new NFAAnalyserInterface.TooComplexEdaAnalysisResults(originalM);
        }
        EdaAnalysisResults toReturn = new NFAAnalyserInterface.EdaAnalysisResultsNoEda(originalM);
        toReturn = this.edaTestCaseParallel(originalM, sccsInMerged);
        if (toReturn.edaCase != EdaAnalysisResults.EdaCases.NO_EDA) {
            return toReturn;
        }
        toReturn = this.testCaseESCC(originalM, sccsInOriginal, esccs);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        if (toReturn.edaCase != EdaAnalysisResults.EdaCases.NO_EDA) {
            return toReturn;
        }
        toReturn = this.edaTestCaseFilter(originalM, merged);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        return toReturn;
    }

    @Override
    protected EdaAnalysisResults calculateEdaUnprioritisedAnalysisResults(NFAGraph originalM) {
        NFAGraph merged = originalM.copy();
        if (NFAAnalysisTools.mergeStronglyConnectedComponents(merged, true, this.maxComplexity) == null) {
            return new NFAAnalyserInterface.TooComplexEdaAnalysisResults(originalM);
        }
        EdaAnalysisResults toReturn = this.edaUnprioritisedAnalysis(merged, this.maxComplexity);
        if (toReturn == null) {
            return new NFAAnalyserInterface.TooComplexEdaAnalysisResults(originalM);
        }
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.UNPRIORITISE);
        return toReturn;
    }

    @Override
    protected IdaAnalysisResults calculateIdaAnalysisResults(NFAGraph originalM) {
        NFAGraph merged = originalM.copy();
        if (NFAAnalysisTools.mergeStronglyConnectedComponents(merged, true, this.maxComplexity) == null) {
            return new NFAAnalyserInterface.TooComplexIdaAnalysisResults(originalM);
        }
        IdaAnalysisResults toReturn = new NFAAnalyserInterface.IdaAnalysisResultsNoIda(originalM);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        toReturn = this.idaTestCaseFilter(originalM, merged);
        if (toReturn == null) {
            return new NFAAnalyserInterface.TooComplexIdaAnalysisResults(originalM);
        }
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.IGNORE);
        return toReturn;
    }

    @Override
    protected IdaAnalysisResults calculateIdaUnprioritisedAnalysisResults(NFAGraph originalM) {
        NFAGraph merged = originalM.copy();
        if (NFAAnalysisTools.mergeStronglyConnectedComponents(merged, true, this.maxComplexity) == null) {
            return new NFAAnalyserInterface.TooComplexIdaAnalysisResults(originalM);
        }
        IdaAnalysisResults toReturn = new NFAAnalyserInterface.IdaAnalysisResultsNoIda(originalM);
        toReturn = this.idaUnprioritisedAnalysis(merged);
        toReturn.setPriorityRemovalStrategy(AnalysisSettings.PriorityRemovalStrategy.UNPRIORITISE);
        return toReturn;
    }
}

