/*
 * Decompiled with CFR 0.152.
 */
package analysis.driver;

import analysis.AnalysisResults;
import analysis.AnalysisSettings;
import analysis.ExploitString;
import analysis.NFAAnalyser;
import analysis.NFAAnalyserFlattening;
import analysis.NFAAnalyserInterface;
import analysis.NFAAnalyserMerging;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import nfa.NFAGraph;
import preprocessor.NonpreciseSubstitutionPreprocessor;
import preprocessor.PreciseSubstitutionPreprocessor;
import regexcompiler.MyPattern;
import util.InterfaceSettings;
import util.InterruptibleMatchingString;

public class AnalysisDriverStdOut {
    private static boolean DEBUG = true;
    private static InterfaceSettings.InputType inputType;
    private static boolean isVerbose;
    private static AnalysisSettings.NFAConstruction nfaConstruction;
    private static AnalysisSettings.PreprocessingType preprocessingType;
    private static AnalysisSettings.EpsilonLoopRemovalStrategy epsilonLoopRemovalStrategy;
    private static AnalysisSettings.PriorityRemovalStrategy priorityRemovalStrategy;
    private static boolean shouldTestIDA;
    private static boolean shouldConstructEdaExploitString;
    private static boolean shouldTestEdaExploitString;
    private static boolean shouldConstructIdaExploitString;
    private static int maxComplexity;
    private static int timeout;
    private static boolean timeoutEnabled;

    public static void performAnalysis(BufferedReader regexesReader, InterfaceSettings interfaceSettings, AnalysisSettings analysisSettings) {
        inputType = interfaceSettings.getInputType();
        isVerbose = interfaceSettings.getIsVerbose();
        DEBUG = interfaceSettings.getIsDebug();
        nfaConstruction = analysisSettings.getNFAConstruction();
        preprocessingType = analysisSettings.getPreprocessingType();
        epsilonLoopRemovalStrategy = analysisSettings.getEpsilonLoopRemovalStrategy();
        priorityRemovalStrategy = analysisSettings.getPriorityRemovalStrategy();
        shouldTestIDA = analysisSettings.getShouldTestIDA();
        shouldConstructEdaExploitString = analysisSettings.getShouldConstructEdaExploitString();
        shouldTestEdaExploitString = analysisSettings.getShouldTestExploitString();
        shouldConstructIdaExploitString = analysisSettings.getShouldConstructIdaExploitString();
        timeout = analysisSettings.getTimeout();
        if (timeout > 0) {
            timeoutEnabled = true;
        }
        maxComplexity = analysisSettings.getMaxComplexity();
        int counter = 0;
        int numAnalysed = 0;
        int numVulnerable = 0;
        int numEda = 0;
        int numIda = 0;
        int numSafe = 0;
        LinkedList<Integer> edaVulnerableNumbers = new LinkedList<Integer>();
        LinkedList<Integer> idaVulnerableNumbers = new LinkedList<Integer>();
        int numSkipped = 0;
        int numTimeout = 0;
        int numTimeoutInEda = 0;
        int numTimeoutInIda = 0;
        if (isVerbose) {
            System.out.println("---Interface settings:---");
            System.out.println("Input type:\t\t\t" + (Object)((Object)inputType));
            System.out.println("Is Verbose:\t\t\t" + isVerbose);
            System.out.println("---Analysis settings:---");
            System.out.println("NFA Construction:\t\t" + (Object)((Object)nfaConstruction));
            System.out.println("Preprocessing type:\t\t" + (Object)((Object)preprocessingType));
            System.out.println("Epsilon loop removal:\t\t" + (Object)((Object)epsilonLoopRemovalStrategy));
            System.out.println("Priority removal:\t\t" + (Object)((Object)priorityRemovalStrategy));
            System.out.println("Testing for IDA:\t\t" + shouldTestIDA);
            System.out.println("Construct EDA exploit strings:\t" + shouldConstructEdaExploitString);
            System.out.println("Testing EDA exploit strings:\t" + shouldTestEdaExploitString);
            System.out.println("Construct IDA exploit strings:\t" + shouldConstructIdaExploitString);
            if (timeout > 0) {
                System.out.println("Timeout:\t\t\t" + timeout + "s");
            } else {
                System.out.println("Timeout:\t\t\tDISABLED");
            }
            System.out.println("Max complexity:\t\t\t" + maxComplexity);
            System.out.println("------------------------");
        }
        NFAAnalyser analyser = AnalysisDriverStdOut.getCorrectNFAAnalyser(epsilonLoopRemovalStrategy);
        Pattern slashesRegex = Pattern.compile("^/(.*)/[a-zA-Z]*$");
        if (isVerbose && inputType == InterfaceSettings.InputType.USER_INPUT) {
            System.out.println("Enter a regular expression to analyze:");
        }
        try {
            String pattern;
            long startTime = System.currentTimeMillis();
            while ((pattern = regexesReader.readLine()) != null) {
                Matcher slashMatcher = slashesRegex.matcher(pattern);
                if (slashMatcher.find()) {
                    pattern = slashMatcher.group(1);
                }
                if (isVerbose) {
                    System.out.println(counter + 1 + ". pattern = \"" + pattern + "\"");
                } else {
                    System.out.println(counter + 1 + ": " + pattern);
                }
                try {
                    String finalPattern = AnalysisDriverStdOut.preprocessToFinalPattern(pattern);
                    if (isVerbose && !pattern.equals(finalPattern)) {
                        System.out.println("preprocessed pattern = \"" + finalPattern + "\"");
                    }
                    AnalysisRunner ar = new AnalysisRunner(finalPattern, analyser);
                    ar.run();
                    NFAAnalyserInterface.AnalysisResultsType results = ar.getAnalysisResultsType();
                    switch (results) {
                        case EDA: {
                            NFAGraph analysisGraph = ar.getAnalysisGraph();
                            boolean constructedEdaExploitString = ar.constructedExploitString();
                            ExploitString edaExploitString = null;
                            String edaExploitStringStr = null;
                            if (constructedEdaExploitString) {
                                edaExploitString = ar.getExploitString();
                                edaExploitStringStr = edaExploitString.toString();
                            } else {
                                edaExploitStringStr = !shouldConstructEdaExploitString ? "**Not Constructed**" : "**TIMEOUT**";
                            }
                            if (isVerbose) {
                                System.out.println("NFA constructed in: " + ar.getNfaConstructionTime() + "ms");
                                System.out.println("EDA analysis performed in: " + ar.getEdaAnalysisTime() + "ms");
                                System.out.println("Contains EDA with: " + edaExploitStringStr);
                                if (constructedEdaExploitString) {
                                    System.out.println("\tEDA exploit string as JSON:\t" + new Gson().toJson((Object)edaExploitString));
                                    System.out.println("\tPrefix:\t\"" + edaExploitString.getPrefixVisual() + "\"");
                                    System.out.println("\tPump:\t\"" + edaExploitString.getPumpByDegreeVisual(0) + "\"");
                                    System.out.println("\tSuffix:\t\"" + edaExploitString.getSuffixVisual() + "\"");
                                } else {
                                    System.out.println("\tDid not construct EDA exploit string");
                                }
                                System.out.println("Total analysis time: " + ar.getTotalAnalysisTime());
                            } else {
                                System.out.print("EDA ");
                            }
                            if (shouldTestEdaExploitString) {
                                if (constructedEdaExploitString) {
                                    AnalysisDriverStdOut.testWithMatcher(edaExploitString, pattern);
                                } else {
                                    System.out.println("NO_EXPLOIT_STRING_CONSTRUCTED");
                                }
                            } else {
                                System.out.println();
                            }
                            ++numVulnerable;
                            ++numEda;
                            edaVulnerableNumbers.add(counter + 1);
                            ++numAnalysed;
                            break;
                        }
                        case NO_EDA: {
                            if (isVerbose) {
                                System.out.println("NFA constructed in: " + ar.getNfaConstructionTime() + "ms");
                                System.out.println("EDA analysis performed in: " + ar.getEdaAnalysisTime() + "ms");
                                System.out.println("Does not contain EDA");
                                System.out.println("Total analysis time: " + ar.getTotalAnalysisTime());
                            } else {
                                System.out.println("NO EDA");
                            }
                            ++numSafe;
                            ++numAnalysed;
                            break;
                        }
                        case IDA: {
                            NFAAnalyserInterface.IdaAnalysisResultsIda idaAnalysisResults = (NFAAnalyserInterface.IdaAnalysisResultsIda)ar.getAnalysisResults();
                            NFAGraph analysisGraph = ar.getAnalysisGraph();
                            boolean constructedIdaExploitString = ar.constructedExploitString();
                            ExploitString idaExploitString = null;
                            String idaExploitStringStr = null;
                            int degree = idaAnalysisResults.getDegree();
                            String idaDegreeString = "" + degree;
                            if (constructedIdaExploitString) {
                                idaExploitString = ar.getExploitString();
                                idaExploitStringStr = idaExploitString.toString();
                            } else {
                                idaExploitStringStr = !shouldConstructIdaExploitString ? "** Not Constructed **" : "**TIMEOUT**";
                            }
                            if (isVerbose) {
                                System.out.println("NFA constructed in: " + ar.getNfaConstructionTime() + "ms");
                                System.out.println("EDA analysis performed in: " + ar.getEdaAnalysisTime() + "ms");
                                System.out.println("Does not contain EDA");
                                System.out.println("IDA analysis performed in: " + ar.getIdaAnalysisTime() + "ms");
                                System.out.println("Contains IDA, degree " + idaDegreeString + ", with: " + idaExploitStringStr);
                                if (constructedIdaExploitString) {
                                    System.out.println("\tIDA exploit string as JSON:\t" + new Gson().toJson((Object)idaExploitString));
                                    for (int i = 0; i < degree; ++i) {
                                        if (i == 0) {
                                            System.out.println("\tPrefix:\t\t\"" + idaExploitString.getSeparatorByDegreeVisual(i) + "\"");
                                        } else {
                                            System.out.println("\tSeparator " + i + ":\t\"" + idaExploitString.getSeparatorByDegreeVisual(i) + "\"");
                                        }
                                        System.out.println("\tPump " + i + ":\t\t\"" + idaExploitString.getPumpByDegreeVisual(i) + "\"");
                                    }
                                    System.out.println("\tSuffix:\t\t\"" + idaExploitString.getSuffixVisual() + "\"");
                                } else {
                                    System.out.println("\tDid not construct IDA exploit string");
                                }
                                System.out.println("Total analysis time: " + ar.getTotalAnalysisTime());
                            } else {
                                System.out.println("IDA_" + idaDegreeString);
                            }
                            ++numVulnerable;
                            ++numIda;
                            idaVulnerableNumbers.add(counter + 1);
                            ++numAnalysed;
                            break;
                        }
                        case NO_IDA: {
                            if (isVerbose) {
                                System.out.println("NFA constructed in: " + ar.getNfaConstructionTime() + "ms");
                                System.out.println("EDA analysis performed in: " + ar.getEdaAnalysisTime() + "ms");
                                System.out.println("Does not contain EDA");
                                System.out.println("IDA analysis performed in: " + ar.getIdaAnalysisTime() + "ms");
                                System.out.println("Does not contain IDA");
                                System.out.println("Total analysis time: " + ar.getTotalAnalysisTime());
                            } else {
                                System.out.println("NO IDA");
                            }
                            ++numSafe;
                            ++numAnalysed;
                            break;
                        }
                        case TOO_COMPLEX: {
                            System.out.println("TOO COMPLEX");
                            ++numTimeout;
                            ++numTimeoutInEda;
                            break;
                        }
                        case ANALYSIS_FAILED: {
                            System.out.println("SKIPPED");
                            ++numSkipped;
                        }
                    }
                }
                catch (PatternSyntaxException pse) {
                    if (DEBUG) {
                        pse.printStackTrace();
                    }
                    System.out.println(counter + 1 + ": SKIPPED: " + pse.getDescription());
                    ++numSkipped;
                }
                catch (Exception e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    System.out.println(counter + 1 + ": SKIPPED: " + e.getMessage());
                    ++numSkipped;
                }
                catch (OutOfMemoryError oome) {
                    if (DEBUG) {
                        oome.printStackTrace();
                    }
                    System.out.println(counter + 1 + ": SKIPPED: " + oome.getMessage());
                    ++numSkipped;
                }
                ++counter;
                if (!isVerbose || inputType != InterfaceSettings.InputType.USER_INPUT) continue;
                System.out.println("Enter a regular expression to analyze:");
            }
            long endTime = System.currentTimeMillis();
            if (!isVerbose) {
                System.out.println("Construction: " + (Object)((Object)nfaConstruction));
                System.out.println("\u03b5-loop removing strategy: " + (Object)((Object)epsilonLoopRemovalStrategy));
            }
            System.out.println("Analysed:\t" + numAnalysed + "/" + counter);
            System.out.println("\tSafe:\t\t" + numSafe + "/" + counter);
            System.out.println("\tVulnerable:\t" + numVulnerable + "/" + counter);
            System.out.println("\t\tEDA:\t\t" + numEda + "/" + counter);
            if (shouldTestIDA) {
                System.out.println("\t\tIDA:\t\t" + numIda + "/" + counter);
            }
            System.out.println("\tVulnerable EDA:\t" + edaVulnerableNumbers);
            if (shouldTestIDA) {
                System.out.println("\tVulnerable IDA:\t" + idaVulnerableNumbers);
            }
            System.out.println("Skipped:\t" + numSkipped + "/" + counter);
            System.out.println("Timeout:\t" + numTimeout + "/" + counter);
            System.out.println("\t\tEDA:\t" + numTimeoutInEda + "/" + counter);
            if (shouldTestIDA) {
                System.out.println("\t\tIDA:\t" + numTimeoutInIda + "/" + counter);
            }
            System.out.println("Total running time: " + (endTime - startTime));
        }
        catch (IOException ioe) {
            System.err.println("Error while reading pattern.");
            System.exit(0);
        }
    }

    private static NFAAnalyser getCorrectNFAAnalyser(AnalysisSettings.EpsilonLoopRemovalStrategy epsilonLoopRemovalStrategy) {
        NFAAnalyser analyser;
        switch (epsilonLoopRemovalStrategy) {
            case MERGING: {
                analyser = new NFAAnalyserMerging(priorityRemovalStrategy, maxComplexity);
                break;
            }
            case FLATTENING: {
                analyser = new NFAAnalyserFlattening(priorityRemovalStrategy, maxComplexity);
                break;
            }
            default: {
                throw new RuntimeException("Unknown Strategy: " + (Object)((Object)epsilonLoopRemovalStrategy));
            }
        }
        return analyser;
    }

    private static String preprocessToFinalPattern(String pattern) {
        String finalPattern;
        switch (preprocessingType) {
            case NONE: {
                finalPattern = pattern;
                break;
            }
            case PRECISE: {
                PreciseSubstitutionPreprocessor preprocessor = new PreciseSubstitutionPreprocessor();
                finalPattern = preprocessor.applyRules(pattern);
                break;
            }
            case NONPRECISE: {
                NonpreciseSubstitutionPreprocessor preprocessor = new NonpreciseSubstitutionPreprocessor();
                finalPattern = preprocessor.applyRules(pattern);
                break;
            }
            default: {
                throw new RuntimeException("Unknown preprocessing type: " + (Object)((Object)preprocessingType));
            }
        }
        return finalPattern;
    }

    private static void testWithMatcher(ExploitString es, String regex) {
        int max_tries = 500;
        final Thread parentThread = Thread.currentThread();
        Pattern pattern = Pattern.compile(regex, 32);
        int pumpLength = es.getPumpByDegree(0).length();
        int i = 0;
        int shortPumpIterations = 1;
        while (i < max_tries) {
            int longPumpIterations;
            ++i;
            String exploitStringShort = es.getPrefix();
            for (int j = 0; j < shortPumpIterations; ++j) {
                exploitStringShort = exploitStringShort + es.getPumpByDegree(0);
            }
            exploitStringShort = exploitStringShort + es.getSuffix();
            Thread thread1 = new Thread(){

                @Override
                public void run() {
                    try {
                        1.sleep(timeout * 1000);
                        parentThread.interrupt();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
            InterruptibleMatchingString matchingStringShort = new InterruptibleMatchingString(exploitStringShort);
            Matcher matcher = pattern.matcher(matchingStringShort);
            long shortTimeTmp = -1L;
            try {
                if (timeoutEnabled) {
                    thread1.start();
                }
                long shortStartTime = System.currentTimeMillis();
                matcher.matches();
                thread1.interrupt();
                long shortEndtTime = System.currentTimeMillis();
                shortTimeTmp = shortEndtTime - shortStartTime;
                longPumpIterations = shortPumpIterations + 1;
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                if (isVerbose) {
                    System.out.println("\t\t\tVulnerable:");
                    System.out.println("\t\t\t" + ExploitString.visualiseString(exploitStringShort) + " Time: (timeout) >(" + timeout + "s)");
                } else {
                    System.out.println("MATCHER_CONFIRMED_EXP_TIME");
                }
                return;
            }
            final long shortTime = shortTimeTmp;
            if (shortTime < 250L) {
                ++shortPumpIterations;
                continue;
            }
            StringBuilder exploitBuilder = new StringBuilder(es.getPrefix());
            for (int j = 0; j < longPumpIterations; ++j) {
                exploitBuilder.append(es.getPumpByDegree(0));
            }
            exploitBuilder.append(es.getSuffix());
            String exploitStringLong = exploitBuilder.toString();
            InterruptibleMatchingString matchingString = new InterruptibleMatchingString(exploitStringLong);
            Thread thread2 = new Thread(){

                @Override
                public void run() {
                    try {
                        2.sleep(shortTime * 10L);
                        parentThread.interrupt();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
            long longStartTime = 0L;
            long longEndTime = 0L;
            try {
                thread2.start();
                matcher = pattern.matcher(matchingString);
                longStartTime = System.currentTimeMillis();
                matcher.matches();
                thread2.interrupt();
                longEndTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                if (isVerbose) {
                    System.out.println("\t\t\tVulnerable:");
                    System.out.println("\t\t\t" + String.format("%1$-" + pumpLength + "s", ExploitString.visualiseString(exploitStringShort)) + " Time: " + shortTime);
                    System.out.println("\t\t\t" + ExploitString.visualiseString(exploitStringLong) + " Time: (timeout) >(" + shortTime + " * 10)");
                } else {
                    System.out.println("MATCHER_CONFIRMED_EXP_TIME");
                }
                return;
            }
            long longTime = longEndTime - longStartTime;
            if (longTime <= 2L * shortTime) continue;
            if (isVerbose) {
                System.out.println("\t\t\tVulnerable:");
                System.out.println("\t\t\t" + String.format("%1$-" + pumpLength + "s", ExploitString.visualiseString(exploitStringShort)) + " Time: " + shortTime);
                System.out.println("\t\t\t" + ExploitString.visualiseString(exploitStringLong) + " Time: " + longTime);
            } else {
                System.out.println("MATCHER_CONFIRMED_EXP_TIME");
            }
            return;
        }
        if (isVerbose) {
            System.out.println("Java matcher did not display exponential matching time...");
        } else {
            System.out.println("MATCHER_DID_NOT_DISPLAY_EXP_TIME");
        }
    }

    private static class AnalysisRunner
    implements Runnable {
        private final String pattern;
        private final NFAAnalyserInterface analyser;
        private NFAGraph analysisGraph;
        private long totalAnalysisTime;
        private long nfaConstructionTime;
        private long edaAnalysisTime;
        private long idaAnalysisTime;
        private NFAAnalyserInterface.AnalysisResultsType analysisResultsType;
        private AnalysisResults analysisResults;
        private ExploitString exploitString;

        private AnalysisRunner(String pattern, NFAAnalyserInterface analyser) {
            this.pattern = pattern;
            this.analyser = analyser;
        }

        public NFAGraph getAnalysisGraph() {
            return this.analysisGraph;
        }

        public long getTotalAnalysisTime() {
            return this.totalAnalysisTime;
        }

        public long getNfaConstructionTime() {
            return this.nfaConstructionTime;
        }

        public long getEdaAnalysisTime() {
            return this.edaAnalysisTime;
        }

        public long getIdaAnalysisTime() {
            return this.idaAnalysisTime;
        }

        public NFAAnalyserInterface.AnalysisResultsType getAnalysisResultsType() {
            return this.analysisResultsType;
        }

        private AnalysisResults getAnalysisResults() {
            return this.analysisResults;
        }

        public ExploitString getExploitString() {
            return this.exploitString;
        }

        public boolean constructedExploitString() {
            return this.exploitString != null;
        }

        @Override
        public void run() {
            block20: {
                try {
                    long totalAnalysisStartTime = System.currentTimeMillis();
                    this.analysisGraph = MyPattern.toNFAGraph(this.pattern, nfaConstruction);
                    if (DEBUG) {
                        System.out.println((Object)this.analysisGraph);
                    }
                    this.nfaConstructionTime = System.currentTimeMillis() - totalAnalysisStartTime;
                    long edaAnalysisStartTime = System.currentTimeMillis();
                    this.analysisResultsType = this.analyser.containsEDA(this.analysisGraph);
                    if (this.analysisResultsType == NFAAnalyserInterface.AnalysisResultsType.TOO_COMPLEX) break block20;
                    this.analysisResults = this.analyser.getEdaAnalysisResults(this.analysisGraph);
                    this.edaAnalysisTime = System.currentTimeMillis() - edaAnalysisStartTime;
                    this.totalAnalysisTime += this.nfaConstructionTime + this.edaAnalysisTime;
                    block1 : switch (this.analysisResultsType) {
                        case EDA: {
                            if (shouldConstructEdaExploitString) {
                                this.exploitString = this.analyser.findEDAExploitString(this.analysisGraph);
                            }
                            break;
                        }
                        case NO_EDA: {
                            if (!shouldTestIDA) break;
                            long idaAnalysisStartTime = System.currentTimeMillis();
                            this.analysisResultsType = this.analyser.containsIDA(this.analysisGraph);
                            if (this.analysisResultsType == NFAAnalyserInterface.AnalysisResultsType.TOO_COMPLEX) break;
                            this.analysisResults = this.analyser.getIdaAnalysisResults(this.analysisGraph);
                            this.idaAnalysisTime = System.currentTimeMillis() - idaAnalysisStartTime;
                            this.totalAnalysisTime += this.idaAnalysisTime;
                            switch (this.analysisResultsType) {
                                case IDA: {
                                    if (shouldConstructIdaExploitString) {
                                        this.exploitString = this.analyser.findIDAExploitString(this.analysisGraph);
                                        break block1;
                                    }
                                    break block20;
                                }
                                case NO_IDA: {
                                    break block1;
                                }
                                case ANALYSIS_FAILED: {
                                    break block1;
                                }
                                default: {
                                    throw new RuntimeException("Unexpected Analysis Results Type after IDA analysis: " + (Object)((Object)this.analysisResultsType));
                                }
                            }
                        }
                        case ANALYSIS_FAILED: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected Analysis Results Type after EDA analysis: " + (Object)((Object)this.analysisResultsType));
                        }
                    }
                }
                catch (Exception e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    } else if (isVerbose) {
                        System.out.println("  " + e.getMessage());
                    }
                    Thread.currentThread().interrupt();
                    this.analysisResultsType = NFAAnalyserInterface.AnalysisResultsType.ANALYSIS_FAILED;
                }
                catch (OutOfMemoryError oome) {
                    if (DEBUG) {
                        oome.printStackTrace();
                    }
                    Thread.currentThread().interrupt();
                    this.analysisResultsType = NFAAnalyserInterface.AnalysisResultsType.ANALYSIS_FAILED;
                }
            }
        }
    }
}

