/*
 * Decompiled with CFR 0.152.
 */
package matcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import matcher.MyMatcher;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;
import nfa.transitionlabel.TransitionLabel;

public abstract class NFAMatcher
implements MyMatcher {
    private final NFAGraph nfaGraph;
    private final String inputString;
    private final int inputStringLength;

    protected NFAMatcher(NFAGraph nfaGraph, String inputString) {
        this.nfaGraph = nfaGraph;
        this.inputString = inputString;
        this.inputStringLength = inputString.length();
    }

    @Override
    public boolean matches() {
        NFAVertexND initialState = this.nfaGraph.getInitialState();
        HashMap<NFAEdge, Integer> transitionToNumTraversedMap = new HashMap<NFAEdge, Integer>();
        return this.matchingDFS(initialState, 0, transitionToNumTraversedMap);
    }

    private boolean matchingDFS(NFAVertexND currentState, int inputStringPosition, HashMap<NFAEdge, Integer> transitionToNumTraversedMap) {
        if (this.nfaGraph.isAcceptingState(currentState) && inputStringPosition == this.inputStringLength) {
            return true;
        }
        Set outgoingEdges = this.nfaGraph.outgoingEdgesOf(currentState);
        LinkedList sortedOutgoingEdges = new LinkedList(outgoingEdges);
        Collections.sort(sortedOutgoingEdges);
        for (NFAEdge outgoingEdge : sortedOutgoingEdges) {
            NFAVertexND targetState = outgoingEdge.getTargetVertex();
            int currentTimesTraversed = 0;
            if (transitionToNumTraversedMap.containsKey(outgoingEdge)) {
                currentTimesTraversed = transitionToNumTraversedMap.get(outgoingEdge);
            }
            if (currentTimesTraversed >= outgoingEdge.getNumParallel()) continue;
            if (outgoingEdge.getIsEpsilonTransition()) {
                transitionToNumTraversedMap.put(outgoingEdge, currentTimesTraversed + 1);
                boolean foundMatch = this.matchingDFS(targetState, inputStringPosition, transitionToNumTraversedMap);
                if (foundMatch) {
                    return true;
                }
                transitionToNumTraversedMap.put(outgoingEdge, currentTimesTraversed);
                continue;
            }
            TransitionLabel transitionLabel = outgoingEdge.getTransitionLabel();
            if (inputStringPosition >= this.inputStringLength || !transitionLabel.matches("" + this.inputString.charAt(inputStringPosition))) continue;
            transitionToNumTraversedMap.put(outgoingEdge, currentTimesTraversed + 1);
            boolean foundMatch = this.matchingDFS(targetState, inputStringPosition + 1, new HashMap<NFAEdge, Integer>());
            if (foundMatch) {
                return true;
            }
            transitionToNumTraversedMap.put(outgoingEdge, currentTimesTraversed);
        }
        return false;
    }
}

