/*
 * Decompiled with CFR 0.152.
 */
package nfa;

import nfa.NFAEdge;
import nfa.NFAVertexND;
import nfa.transitionlabel.CharacterClassTransitionLabel;
import nfa.transitionlabel.EmptyTransitionLabelException;
import nfa.transitionlabel.EpsilonTransitionLabel;
import nfa.transitionlabel.TransitionLabel;
import nfa.transitionlabel.TransitionLabelParserRecursive;

public class FilterEdge
extends NFAEdge {
    private static final long serialVersionUID = 1L;
    private TransitionLabel outGoingTransitionCharacter;

    public TransitionLabel getOutGoingTransitionCharacter() {
        return this.outGoingTransitionCharacter;
    }

    public void setOutGoingTransitionCharacter(String outGoingTransitionCharacter) {
        TransitionLabelParserRecursive tlpr = new TransitionLabelParserRecursive(outGoingTransitionCharacter);
        this.outGoingTransitionCharacter = tlpr.parseTransitionLabel();
    }

    public FilterEdge(NFAVertexND sourceVertex, NFAVertexND targetVertex, String transitionCharacter, String outGoingTransitionCharacter) throws EmptyTransitionLabelException {
        super(sourceVertex, targetVertex, transitionCharacter);
        TransitionLabelParserRecursive tlpr = new TransitionLabelParserRecursive(outGoingTransitionCharacter);
        this.outGoingTransitionCharacter = tlpr.parseTransitionLabel();
    }

    public FilterEdge(NFAVertexND sourceVertex, NFAVertexND targetVertex, TransitionLabel transitionCharacter, TransitionLabel outGoingTransitionCharacter) {
        super(sourceVertex, targetVertex, transitionCharacter);
        this.outGoingTransitionCharacter = outGoingTransitionCharacter;
    }

    @Override
    public NFAEdge copy() {
        return new FilterEdge(super.getSourceVertex(), super.getTargetVertex(), super.getTransitionLabel(), this.outGoingTransitionCharacter);
    }

    @Override
    public boolean isTransitionFor(String word) {
        if (super.getIsEpsilonTransition()) {
            return super.isTransitionFor(word);
        }
        return !word.matches("\u03b5\\d*");
    }

    @Override
    public boolean isTransitionFor(TransitionLabel tl) {
        if (super.getIsEpsilonTransition()) {
            if (tl instanceof CharacterClassTransitionLabel) {
                return false;
            }
            EpsilonTransitionLabel stl = (EpsilonTransitionLabel)tl;
            String word = stl.getSymbol();
            return super.isTransitionFor(word);
        }
        return tl instanceof CharacterClassTransitionLabel;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        FilterEdge n = (FilterEdge)o;
        boolean condition1 = super.getSourceVertex().equals(n.getSourceVertex());
        boolean condition2 = super.getTargetVertex().equals(n.getTargetVertex());
        boolean condition3 = super.getTransitionLabel().equals(n.getTransitionLabel());
        boolean condition4 = this.outGoingTransitionCharacter.equals(n.getOutGoingTransitionCharacter());
        return condition1 && condition2 && condition3 && condition4;
    }

    @Override
    public String toString() {
        return super.getTransitionLabel() + ":" + this.outGoingTransitionCharacter;
    }

    @Override
    public int hashCode() {
        return super.getSourceVertex().hashCode() + super.getTargetVertex().hashCode() + super.getTransitionLabel().hashCode() + this.outGoingTransitionCharacter.hashCode();
    }
}

