/*
 * Decompiled with CFR 0.152.
 */
package nfa.transitionlabel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nfa.transitionlabel.CharacterClassTransitionLabel;
import nfa.transitionlabel.TransitionLabel;

public class EpsilonTransitionLabel
implements TransitionLabel,
Comparable<EpsilonTransitionLabel> {
    private final String transitionLabel;
    private final int priority;

    public EpsilonTransitionLabel(String transitionLabel) {
        Pattern pattern = Pattern.compile("\u03b5(\\d*)");
        Matcher matcher = pattern.matcher(transitionLabel);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Transition label must be of the format \u03b5\\d*");
        }
        this.priority = Integer.parseInt(matcher.group(1));
        this.transitionLabel = transitionLabel;
    }

    @Override
    public boolean matches(String word) {
        return this.transitionLabel.equals(word);
    }

    @Override
    public boolean matches(TransitionLabel tl) {
        if (tl instanceof CharacterClassTransitionLabel) {
            return false;
        }
        EpsilonTransitionLabel etl = (EpsilonTransitionLabel)tl;
        return this.matches(etl.transitionLabel);
    }

    @Override
    public TransitionLabel intersection(TransitionLabel tl) {
        throw new UnsupportedOperationException("The intersection operation is invalid for epsilon transitions.");
    }

    @Override
    public TransitionLabel union(TransitionLabel tl) {
        throw new UnsupportedOperationException("The union operation is invalid for epsilon transitions.");
    }

    @Override
    public TransitionLabel complement() {
        throw new UnsupportedOperationException("The complement operation is invalid for epsilon transitions.");
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getSymbol() {
        return this.transitionLabel;
    }

    @Override
    public TransitionLabel copy() {
        return new EpsilonTransitionLabel(this.transitionLabel);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof EpsilonTransitionLabel)) {
            return false;
        }
        EpsilonTransitionLabel etl = (EpsilonTransitionLabel)o;
        return this.transitionLabel.equals(etl.transitionLabel);
    }

    public String toString() {
        return this.transitionLabel;
    }

    public int hashCode() {
        return this.transitionLabel.hashCode();
    }

    @Override
    public TransitionLabel.TransitionType getTransitionType() {
        return TransitionLabel.TransitionType.EPSILON;
    }

    @Override
    public int compareTo(EpsilonTransitionLabel o) {
        return this.priority - o.priority;
    }
}

