/*
 * Decompiled with CFR 0.152.
 */
package regexcompiler;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import regexcompiler.RegexGroup;
import regexcompiler.RegexOperator;
import regexcompiler.RegexSubexpression;
import regexcompiler.RegexToken;

public class ParseTree {
    private TreeNode root;

    public TreeNode getRoot() {
        return this.root;
    }

    public void addTreeNode(TreeNode child) {
        this.root.addChild(child);
    }

    public void newRoot(TreeNode child) {
        if (this.root != null) {
            child.addChild(this.root);
        }
        this.root = child;
    }

    public String toString() {
        StringBuilder treeStringBuilder = new StringBuilder();
        this.dfsTree(this.root, treeStringBuilder);
        return treeStringBuilder.toString();
    }

    private void dfsTree(TreeNode currentNode, StringBuilder sb) {
        if (!currentNode.getChildren().isEmpty()) {
            sb.append(currentNode);
            sb.append(this.getBracketType(currentNode, true));
            Iterator<TreeNode> childIterator = currentNode.getChildren().iterator();
            while (childIterator.hasNext()) {
                TreeNode child = childIterator.next();
                this.dfsTree(child, sb);
                if (!childIterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(this.getBracketType(currentNode, false));
        } else {
            sb.append("'" + currentNode + "'");
        }
    }

    private String getBracketType(TreeNode node, boolean isOpen) {
        RegexToken token = node.getRegexToken();
        if (token.getTokenType() == RegexToken.TokenType.OPERATOR) {
            RegexOperator operatorToken = (RegexOperator)token;
            if (isOpen) {
                switch (operatorToken.getOperatorType()) {
                    case JOIN: {
                        return "[";
                    }
                    case UNION: {
                        return "{";
                    }
                }
                return "<";
            }
            switch (operatorToken.getOperatorType()) {
                case JOIN: {
                    return "]";
                }
                case UNION: {
                    return "}";
                }
            }
            return ">";
        }
        if (isOpen) {
            return "(";
        }
        return ")";
    }

    public static class TreeNode {
        private List<TreeNode> children;
        private final RegexToken regexToken;

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public void addChild(TreeNode child) {
            this.children.add(child);
        }

        public RegexToken getRegexToken() {
            return this.regexToken;
        }

        private int getRegexIndex() {
            return this.regexToken.getIndex();
        }

        public TreeNode(RegexToken regexToken) {
            this.regexToken = regexToken;
            this.children = new LinkedList<TreeNode>();
        }

        public String toString() {
            RegexSubexpression subexpressionToken;
            if (this.regexToken.getTokenType() == RegexToken.TokenType.SUBEXPRESSION && (subexpressionToken = (RegexSubexpression)this.regexToken).getSubexpressionType() == RegexSubexpression.SubexpressionType.GROUP) {
                RegexGroup groupToken = (RegexGroup)subexpressionToken;
                return groupToken.getGroupType().toString();
            }
            return this.regexToken.toString();
        }
    }
}

