/*
 * Decompiled with CFR 0.152.
 */
package regexcompiler;

import regexcompiler.RegexSubexpression;

public class RegexEscapedSymbol
extends RegexSubexpression<String> {
    private final RegexEscapedSymbolType escapedSymbolType;

    @Override
    public RegexSubexpression.SubexpressionType getSubexpressionType() {
        return RegexSubexpression.SubexpressionType.ESCAPED_SYMBOL;
    }

    public RegexEscapedSymbolType getRegexEscapedSymbolType() {
        return this.escapedSymbolType;
    }

    public RegexEscapedSymbol(String escapedContent, RegexEscapedSymbolType escapedSymbolType, int index) {
        super(escapedContent, index);
        this.escapedSymbolType = escapedSymbolType;
    }

    public String toString() {
        switch (this.escapedSymbolType) {
            case CHARACTER: {
                return "\\" + (String)this.getSubexpressionContent();
            }
            case OCTAL: {
                return "\\0" + (String)this.getSubexpressionContent();
            }
            case UNICODE: {
                return "\\u" + (String)this.getSubexpressionContent();
            }
            case HEX: {
                return "\\x{" + (String)this.getSubexpressionContent() + "}";
            }
            case CHARACTER_PROPERTY: {
                return "\\p{" + (String)this.getSubexpressionContent() + "}";
            }
        }
        throw new RuntimeException("Unknown RegexEscapedSymbolType");
    }

    public static enum RegexEscapedSymbolType {
        CHARACTER,
        OCTAL,
        UNICODE,
        HEX,
        CHARACTER_PROPERTY;

    }
}

